// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

static void hclSimClothData_13_to_14(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helperhkDataObject)
{
    // Set constraint Id for static constraints
    {
        hkReflect::ArrayVar staticConstraintSets(obj["staticConstraintSets"]);
        int numStaticConstraints = staticConstraintSets.getCount();

        for (int staticConstraintIdx = 0; staticConstraintIdx < numStaticConstraints; ++staticConstraintIdx)
        {
            hkReflect::PointerVar staticConstraintPtr(staticConstraintSets[staticConstraintIdx]);
            hkReflect::Var staticConstraintVar = staticConstraintPtr.getValue();

            staticConstraintVar["constraintId"]["value"].assign(&staticConstraintIdx);
        }
    }

    // Set constraint Id for anti-pinch constraints
    {
        hkReflect::ArrayVar antiPinchConstraintSets(obj["antiPinchConstraintSets"]);
        int numAntiPinchConstraints = antiPinchConstraintSets.getCount();

        for (int antiPinchConstraintIdx = 0; antiPinchConstraintIdx < numAntiPinchConstraints; ++antiPinchConstraintIdx)
        {
            hkReflect::PointerVar antiPinchConstraintPtr(antiPinchConstraintSets[antiPinchConstraintIdx]);
            hkReflect::Var antiPinchConstraintVar = antiPinchConstraintPtr.getValue();

            antiPinchConstraintVar["constraintId"]["value"].assign(&antiPinchConstraintIdx);
        }
    }
}

void HK_CALL registerClothPatches_2016_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_2/hclPatches_2016_2.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
