// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// NewPhysics specific product patches applied to release 2016_1.
// This file is #included by hknpPatches_2016_1.cpp

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCharacterSurfaceInfo", 0)
    ADD("isSurfaceDynamic", "hkBool")
    ADD("supportedState", "hkUint8")
    ADD("surfaceDistanceExcess", "hkReal")
    ADD("surfaceNormal", "hkVector4")
    ADD("surfaceVelocity", "hkVector4")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintGroup", 0)
    ADD("microStepMultiplier", "hkUint8")
    ADD("id", "hknpConstraintGroupId")
    ADD("firstConstraintId", "hknpConstraintId")
    ADD("numConstraintIds", "unsigned int")
    ADD("flags", "hkUint16")
    ADD("userData", "hkUint64")
    DEPENDS("hknpConstraintGroupId", 1)
    DEPENDS("hknpConstraintId", 1)
END()

BEGIN_EMPTY("hknpConstraintGroupId", 0, "hknpConstraintGroupId", 1)
END_EMPTY()

BEGIN("hknpWorldCinfo", 10, "hknpWorldCinfo", 11)
    ADD("bodyIntegrator", "hknpBodyIntegrator*")
    ADD("weldingConfig", "hknpWeldingConfig")
    DEPENDS("hknpBodyIntegrator", 0)
    DEPENDS("hknpWeldingConfig", 0)
    ADD("adjustSolverSettingsBasedOnTimestep", "hkBool")
    FUNCTION(hknpWorldCInfo_adjustSolverSettingsBasedOnTimestep_10_11_Init)
    ADD("expectedDeltaTime", "hkReal")
    FUNCTION(hknpWorldCInfo_expectedDeltaTime_10_11_Init)
    ADD("minSolverIterations", "hkInt32")
    FUNCTION(hknpWorldCInfo_minSolverIterations_10_11_Init)
    ADD("maxSolverIterations", "hkInt32")
    FUNCTION(hknpWorldCInfo_maxSolverIterations_10_11_Init)
END()

BEGIN("hknpBodyQuality", 2, "hknpBodyQuality", 3)
    ADD("motionRangeBreachPolicy", "hkUint8")
END()

BEGIN("hknpHeightFieldShape", 5, "hknpHeightFieldShape", 6)
    REMOVE("markBorderEdgesForWelding", "unsigned char")
END()

BEGIN("hknpCompositeShape", 1, "hknpCompositeShape", 2)
    REMOVE("edgeWeldingMap", "hknpSparseCompactMap< hkUint16 >")
    DEPENDS("hknpSparseCompactMap< hkUint16 >", 0)
END()

BEGIN("hknpSparseCompactMap< hkUint16 >", 0, HK_NULL, HK_CLASS_REMOVED)
    REMOVE("valueAndSecondaryKeys", "hkArray< int >")
    REMOVE("primaryKeyToIndex", "hkArray< int >")
    REMOVE("sencondaryKeyBits", "int")
    REMOVE("secondaryKeyMask", "int")
END()

BEGIN("hknpBroadPhaseConfig::Layer", 0, "hknpBroadPhaseConfig::Layer", 1)
    ADD("recollideOnDirty", "hkBool")
END()

BEGIN("hknpDefaultBroadPhaseConfig", 0, "hknpDefaultBroadPhaseConfig", 1)
    REMOVE("layers", "hknpBroadPhaseConfig::Layer[4]" )
    DEPENDS("hknpBroadPhaseConfig::Layer", 1)
END()

BEGIN("hknpMaterial", 3, "hknpMaterial", 4)
    ADD("weldingTolerance_new", "hkReal")
    FUNCTION(hknpMaterial_weldingTolerance_3_4)
    REMOVE("weldingTolerance", "hkHalf16")
    RENAME("weldingTolerance_new", "weldingTolerance")
    DEPENDS("hkHalf16", 0)
END()

BEGIN("hkFreeListArrayElement< hknpMaterial >", 3, "hkFreeListArrayElement< hknpMaterial >", 4)
    DEPENDS("hknpMaterial", 4)
END()

BEGIN("hknpConvexShape", 0, "hknpConvexShape", 1)
    ADD("maxAllowedPenetration", "hkUint16")
    DEPENDS("hkUint16", 0)
    FUNCTION(hknpConvexShape_maxAllowedPenetration_0_1_Init)
END()

BEGIN("hknpShapeInstance", 2, "hknpShapeInstance", 3)
    DEPENDS("hknpShapeInstanceId", 0)
    DEPENDS("hknpCompoundShapeBase", 4)
    ADD("isEmpty", "hkUint8")
    ADD("nextEmptyElement", "hkUint32")
    ADD("instanceId", "hknpShapeInstanceId")
    ADD("parentShape", "hknpCompoundShapeBase*")
    FUNCTION(hknpShapeInstance_2_3)
    REMOVE("padding", "unsigned char[30]")
END()

BEGIN( "hkFreeListArrayElement< hknpShapeInstance >", 2, "hkFreeListArrayElement< hknpShapeInstance >", 3 )
    DEPENDS( "hknpShapeInstance", 3 )
END()

BEGIN("hknpCharacterRigidBodyCinfo", 5, "hknpCharacterRigidBodyCinfo", 6)
    RENAME("reservedBodyId", "desiredBodyId")
    REMOVE("additionMode", "hkUint8")
    REMOVE("activationMode", "hkUint8")
END()

BEGIN( "hknpCharacterSurfaceInfo", 0, "hknpCharacterSurfaceInfo", 1 )
    ADD( "surfaceAngularVelocity", "hkVector4" )
END()

BEGIN("hknpBodyCinfo", 5, "hknpBodyCinfo", 6)
    RENAME("reservedBodyId", "desiredBodyId")
    RENAME("reservedMotionId", "motionId")
    FUNCTION(hknpBodyCinfo_5_6)
END()

BEGIN("hknpBodyQualityLibrary", 0, "hknpBodyQualityLibrary", 1)
    DEPENDS("hknpBodyQuality", 3)
    FUNCTION(hknpBodyQualityLibrary_0_1)
END()

BEGIN("hknpBody", 7, "hknpBody", 8)
    FUNCTION(hknpBody_7_8)
END()

BEGIN("hknpPhysicsSystemData", 1, "hknpPhysicsSystemData", 2)
    ADD("microStepMultiplier", "hkUint8")
END()

BEGIN("hknpRagdollData", 0, "hknpRagdollData", 1)
    ADD("bodyTags", "hkArray< hkUint32 >")
END()

BEGIN( HK_NULL, HK_CLASS_ADDED, "hknpWorldSnapshot::ConstraintGroupInfo", 0 )
    ADD( "id", "hknpConstraintGroupId" )
    ADD( "multiplier", "hkUint8" )
    DEPENDS( "hknpConstraintGroupId", 1 )
END()

BEGIN( HK_NULL, HK_CLASS_ADDED, "hknpCylinderShape", 0 )
    SET_PARENT( HK_NULL, "hknpConvexPolytopeShape" )
    ADD( "a", "hkVector4" )
    ADD( "b", "hkVector4" )
    DEPENDS( "hknpConvexPolytopeShape", 4 )
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaskedCompoundShape", 0)
    SET_PARENT(HK_NULL, "hknpMaskedShape")
    ADD("aabb", "hkAabb")
    ADD("isEnabledInstanceCacheEnabled", "hkBool")
    ADD("enabledInstanceCache", "hkArray< hknpShapeInstanceId >")
    DEPENDS("hknpMaskedShape", 1)
    DEPENDS("hkAabb", 0)
    DEPENDS("hknpShapeInstanceId", 0)
END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
