// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

namespace
{
    void hknpWorldCInfo_adjustSolverSettingsBasedOnTimestep_10_11_Init(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkBool adjustSolverSettingsBasedOnTimestep = false;
        obj["adjustSolverSettingsBasedOnTimestep"].assign(&adjustSolverSettingsBasedOnTimestep);
    }

    void hknpWorldCInfo_expectedDeltaTime_10_11_Init(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReal expectedDeltaTime = 1.0f / 30;
        obj["expectedDeltaTime"].assign(&expectedDeltaTime);
    }

    void hknpWorldCInfo_minSolverIterations_10_11_Init(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkInt32 minSolverIterations = 1;
        obj["minSolverIterations"].assign(&minSolverIterations);
    }

    void hknpWorldCInfo_maxSolverIterations_10_11_Init(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkInt32 maxSolverIterations = 8;
        obj["maxSolverIterations"].assign(&maxSolverIterations);
    }

    void hknpConvexShape_maxAllowedPenetration_0_1_Init(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        // maxAllowedPenetration is set to negative number so that after reflect new can detect that value has to be recalculated.
        hkHalf16 maxHalf; maxHalf.setNegativeOne();
        obj["maxAllowedPenetration"].assign(&maxHalf);
    }

    void hknpMaterial_weldingTolerance_3_4(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var src(obj["weldingTolerance"]);
        hkReflect::Var dst(obj["weldingTolerance_new"]);

        hkReflect::FloatVar fSrc = src;
        float fValue = (float)fSrc.getValue().m_value;
        dst.assign(&fValue);
    }

    void hknpShapeInstance_2_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        // Move free list info out of padding, into new members
        hkReflect::Var sPaddingArray(obj["padding"]);
        hkUint8 paddingByte0 = hkReflect::IntVar(sPaddingArray[0]).getValue().convertTo<hkUint8>();
        hkUint8 paddingByte1 = hkReflect::IntVar(sPaddingArray[1]).getValue().convertTo<hkUint8>();
        hkUint8 paddingByte2 = hkReflect::IntVar(sPaddingArray[2]).getValue().convertTo<hkUint8>();
        hkUint8 paddingByte3 = hkReflect::IntVar(sPaddingArray[3]).getValue().convertTo<hkUint8>();
        hkUint8 paddingByte4 = hkReflect::IntVar(sPaddingArray[4]).getValue().convertTo<hkUint8>();

        hkReflect::Var tNextEmptyElement(obj["nextEmptyElement"]);
        hkUint32 vNextEmptyElement = (paddingByte3 << 24) | (paddingByte2 << 16) | (paddingByte1 << 8) | paddingByte0;
        tNextEmptyElement.assign(&vNextEmptyElement);

        hkReflect::Var tIsEmpty(obj["isEmpty"]);
        tIsEmpty.assign(&paddingByte4);
    }

    void hknpBodyQualityLibrary_0_1(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        hkReflect::Var dstArray(obj["qualities"]);

        // Old version had 12 presets. PRESET_ALL_WELDING has been added at index 7 so all from 7 to 11 have to be shifted by one place.
        for (int i = 11; i > 6; i--)
        {
            hkReflect::Var src = dstArray[i];
            hkReflect::Var dst = dstArray[i + 1];

            int priority = (i + 1) * 10;
            dst["priority"].assign(&priority);
            dst["supportedFlags"].assign(src["supportedFlags"]);
            dst["requestedFlags"].assign(src["requestedFlags"]);
            dst["contactCachingRelativeMovementThreshold"].assign(src["contactCachingRelativeMovementThreshold"]);
            dst["motionRangeBreachPolicy"].assign(src["motionRangeBreachPolicy"]);
        }

        // Fill in PRESET_ALL_WELDING
        hkReflect::Var dst = dstArray[7];
        int priority = 70;
        hkUint32 supportedFlags = 0xfffffbff;
        hkUint32 requestedFlags = 0x00020982;
        hkReal contactCachingRelativeMovementThreshold = 0.1f;
        int motionRangeBreachPolicy = 0;
        dst["priority"].assign(&priority);
        dst["supportedFlags"].assign(&supportedFlags);
        dst["requestedFlags"].assign(&requestedFlags);
        dst["contactCachingRelativeMovementThreshold"].assign(&contactCachingRelativeMovementThreshold);
        dst["motionRangeBreachPolicy"].assign(&motionRangeBreachPolicy);
    }

    HK_INLINE void patchBodyQualityId(hkReflect::Var obj, const char* field)
    {
        hkReflect::Var src(obj[field]);

        hkReflect::IntVar iSrc = src;
        hkUint8 iValue = (hkUint8)iSrc.getValue().absValue();

        HK_WARN_ONCE_ON_DEBUG_IF(iValue > 11 && iValue < 16, 0xaf14e219,
            "Customer presets shouldn't be added with index less than FIRST_USER_ID");

        // All references to predefined shifted presets have to be adjusted.
        if (iValue > 6 && iValue < 12)
        {
            iValue++;
            src.assign(&iValue);
        }
    }

    void hknpBody_7_8(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        patchBodyQualityId(obj, "qualityId");
    }

    void hknpBodyCinfo_5_6(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        patchBodyQualityId(obj, "qualityId");
    }
}

void HK_CALL registerNewPhysicsPatches_2016_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2016_1/hknpPatches_2016_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
