// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Ai specific product patches applied to release 2016_1.
// This file is #included by hkaiPatches_2016_1.cpp

BEGIN("hkaiNavMeshInstanceCutter", 0, "hkaiNavMeshInstanceCutter", 1)
    ADD("modifiedFaces", "hkHashSet< hkaiIndex< hkInt32 > >")
    ADD("needMatchStreamingFaceIndices", "hkHashSet< hkaiIndex< hkInt32 > >")
    DEPENDS("hkHashSet< hkaiIndex< hkInt32 > >", 0)
    DEPENDS("hkHashSet< hkaiIndex< hkInt32 > >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiBalconyVaultAnalyzer", 2)
    SET_PARENT(HK_NULL, "hkaiTraversalAnalyzer")
    ADD("maxWallWidth", "hkReal")
    ADD("minWallHeight", "hkReal")
    ADD("maxWallHeight", "hkReal")
    ADD("minDropDistance", "hkReal")
    ADD("maxDropDistance", "hkReal")
    ADD("horizontalDistance", "hkReal")
    ADD("verticalApex", "hkReal")
    ADD("handPlantAngle", "hkReal")
    ADD("handPlantLeftExtent", "hkReal")
    ADD("handPlantRightExtent", "hkReal")
    ADD("handPlantMaxProfileAngle", "hkReal")
    DEPENDS("hkaiTraversalAnalyzer", 0)
END()

BEGIN("hkaiWorld", 37, "hkaiWorld", 38)
    ADD("navigatorManager", "hkaiNavigatorManager*")
    ADD("navigatorSignals", "hkaiNavigatorSignals")
    DEPENDS("hkaiNavigatorManager", 0)
    DEPENDS("hkaiNavigatorSignals", 0)
END()

#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
BEGIN_EMPTY("hkaiPhysics2012BodyObstacleGenerator", 1, "hkaiPhysics2012BodyObstacleGenerator_old", 1)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPhysics2012BodyObstacleGenerator", 2)
    SET_PARENT(HK_NULL, "hkaiCollisionAvoidance::SimpleObstacleGenerator")
    ADD("velocityThreshold", "hkReal")
    ADD("rigidBody", "hkpRigidBody*")
    DEPENDS("hkaiCollisionAvoidance::SimpleObstacleGenerator", 0)
    DEPENDS("hkpRigidBody", 0)
END()
#endif

#if defined(HK_FEATURE_PRODUCT_PHYSICS)
BEGIN_EMPTY("hkaiPhysicsBodyObstacleGenerator", 0, "hkaiPhysicsBodyObstacleGenerator_old", 1)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiPhysicsBodyObstacleGenerator", 2)
    SET_PARENT(HK_NULL, "hkaiCollisionAvoidance::SimpleObstacleGenerator")
    ADD("velocityThreshold", "hkReal")
    DEPENDS("hkaiCollisionAvoidance::SimpleObstacleGenerator", 0)
END()
#endif

BEGIN("hkaiDropDownAnalyzer", 3, "hkaiDropDownAnalyzer", 4)
    ADD("resolveHangExtraDist", "hkReal")
END()
BEGIN("hkaiClimbUpAnalyzer", 3, "hkaiClimbUpAnalyzer", 4)
    ADD("resolveHangExtraDist", "hkReal")
END()
BEGIN("hkaiGatePath::PathGate", 0, "hkaiGatePath::PathGate", 1)
    ADD("edgeIndex", "hkaiIndex< hkInt32 >")
END()
BEGIN("hkaiWorld", 38, "hkaiWorld", 39)
    ADD("volumeNavigatorManager", "hkaiVolumeNavigatorManager*")
    ADD("volumeNavigatorSignals", "hkaiVolumeNavigatorSignals")
    DEPENDS("hkaiVolumeNavigatorManager", 0)
    DEPENDS("hkaiVolumeNavigatorSignals", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::System", 0)
    SET_PARENT(HK_NULL, "hkReferencedObject")
    ADD("up", "hkVector4")
    ADD("characters", "hkArray< hkaiCollisionAvoidance::Character* >")
    ADD("enabledCharacters", "hkArray< hkaiCollisionAvoidance::Character* >")
    ADD("obstacleGenerators", "hkArray< hkaiCollisionAvoidance::ObstacleGenerator* >")
    ADD("filter", "hkaiCollisionAvoidance::Filter*")
    DEPENDS("hkReferencedObject", 3)
    DEPENDS("hkaiCollisionAvoidance::Character", 0)
    DEPENDS("hkaiCollisionAvoidance::Character", 0)
    DEPENDS("hkaiCollisionAvoidance::ObstacleGenerator", 0)
    DEPENDS("hkaiCollisionAvoidance::Filter", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::Solver::Output", 0)
    ADD("outputVelocity", "hkVector4")
    ADD("penetrating", "bool")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::Solver::Input", 0)
    ADD("up", "hkVector4")
    ADD("character", "hkaiCollisionAvoidance::Character*")
    ADD("neighbors", "hkaiCollisionAvoidance::NeighborCollector*")
    DEPENDS("hkaiCollisionAvoidance::Character", 0)
    DEPENDS("hkaiCollisionAvoidance::NeighborCollector", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::NeighborCollector", 0)
    ADD("lineSegments", "hkArray< hkaiCollisionAvoidance::LineSegmentObstacle >")
    ADD("spheres", "hkArray< hkaiCollisionAvoidance::SphereObstacle >")
    ADD("characters", "hkaiMinArray< hkViewPtr< hkaiCollisionAvoidance::Character > >")
    DEPENDS("hkaiCollisionAvoidance::LineSegmentObstacle", 0)
    DEPENDS("hkaiCollisionAvoidance::SphereObstacle", 0)
    DEPENDS("hkaiMinArray< hkViewPtr< hkaiCollisionAvoidance::Character > >", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::SteeringProperties", 0)
    ADD("wallFollowingAngle", "hkReal")
    ADD("dodgingPenalty", "hkReal")
    ADD("velocityHysteresis", "hkReal")
    ADD("sidednessChangingPenalty", "hkReal")
    ADD("collisionPenalty", "hkReal")
    ADD("penetrationPenalty", "hkReal")
    ADD("weight", "hkReal")
    ADD("priority", "int")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::Character::SensorSize", 0)
    ADD("halfWidth", "hkReal")
    ADD("topExtent", "hkReal")
    ADD("bottomExtent", "hkReal")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::Character", 0)
    SET_PARENT(HK_NULL, "hkReferencedObject")
    ADD("userData", "hkUlong")
    ADD("boundaryGathererData", "hkUlong")
    ADD("position", "hkVector4")
    ADD("velocity", "hkVector4")
    ADD("surfaceVelocity", "hkVector4")
    ADD("distanceToLocalGoal", "hkReal")
    ADD("localGoalPlane", "hkVector4")
    ADD("desiredDirection", "hkVector4")
    ADD("avoidanceVelocity", "hkVector4")
    ADD("radius", "hkReal")
    ADD("maximumSpeed", "hkReal")
    ADD("preferredSpeed", "hkReal")
    ADD("sensorSize", "hkaiCollisionAvoidance::Character::SensorSize")
    ADD("maximumAvoidanceCharacters", "int")
    ADD("steeringProperties", "hkaiCollisionAvoidance::SteeringProperties")
    ADD("boundaryGatherer", "hkaiCollisionAvoidance::BoundaryGatherer*")
    ADD("scoreModifiers", "hkArray< hkaiCollisionAvoidance::ReferencedScoreModifier* >")
    ADD("steeringEnabled", "bool")
    ADD("indexInSystem", "int")
    ADD("enabledIndexInSystem", "int")
    DEPENDS("hkReferencedObject", 3)
    DEPENDS("hkaiCollisionAvoidance::Character::SensorSize", 0)
    DEPENDS("hkaiCollisionAvoidance::SteeringProperties", 0)
    DEPENDS("hkaiCollisionAvoidance::BoundaryGatherer", 0)
    DEPENDS("hkaiCollisionAvoidance::ReferencedScoreModifier", 0)
END()

BEGIN("hkaiCollisionAvoidance::Character", 0, "hkaiCollisionAvoidance::Character", 1)
    ADD("system", "hkaiCollisionAvoidance::System*")
    DEPENDS("hkaiCollisionAvoidance::System", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::MediatorBoundaryGatherer", 0)
    SET_PARENT(HK_NULL, "hkaiCollisionAvoidance::BoundaryGatherer")
    ADD("world", "hkaiWorld*")
    ADD("layerIndex", "hkInt32")
    ADD("filterInfo", "hkUint32")
    DEPENDS("hkaiCollisionAvoidance::BoundaryGatherer", 0)
    DEPENDS("hkaiWorld", 38)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCollisionAvoidance::DefaultBoundaryGatherer", 0)
    SET_PARENT(HK_NULL, "hkaiCollisionAvoidance::BoundaryGatherer")
    ADD("world", "hkaiWorld*")
    ADD("layerIndex", "hkInt32")
    ADD("edgeFilter", "hkaiAstarEdgeFilter*")
    ADD("filterInfo", "hkUint32")
    DEPENDS("hkaiCollisionAvoidance::BoundaryGatherer", 0)
    DEPENDS("hkaiWorld", 38)
    DEPENDS("hkaiAstarEdgeFilter", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiBlockedCharacterDetector", 0)
    SET_PARENT(HK_NULL, "hkReferencedObject")
    ADD("smoothingFactor", "hkReal")
    ADD("initialProgress", "hkReal")
    ADD("blockedThreshold", "hkReal")
    ADD("sqrTeleportationThreshold", "hkReal")
    ADD("prevPos", "hkVector4")
    ADD("avgProgress", "hkReal")
    ADD("hasPrevPos", "hkBool")
    ADD("blocked", "hkBool")
    DEPENDS("hkReferencedObject", 3)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCornerPredictor::UserEdgeTraversal", 0)
    ADD("entrancePointLocal", "hkVector4")
    ADD("edgeDataPtr", "hkInt32*")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaiCornerPredictor", 0)
    ADD("up", "hkVector4")
    ADD("nextTravelVector", "hkVector4")
    ADD("nextEnterTurnPoint", "hkVector4")
    ADD("nextTransform", "hkMatrix4")
    ADD("nextEdgeIndex", "int")
    ADD("nextIsLeft", "hkUint32")
    ADD("nextUserEdgeTraversals", "hkArray< hkaiCornerPredictor::UserEdgeTraversal >")
    ADD("prevResult", "hkaiCornerPredictor::StepForwardResult")
    ADD("edgePath", "hkaiEdgePath*")
    ADD("streamingCollection", "hkaiStreamingCollection*")
    DEPENDS("hkaiCornerPredictor::UserEdgeTraversal", 0)
    DEPENDS("hkaiEdgePath", 1)
    DEPENDS("hkaiStreamingCollection", 4)
END()

BEGIN("hkaiGateFollowingBehavior", 1, HK_NULL, HK_CLASS_REMOVED)
        SET_PARENT("hkaiSingleCharacterBehavior", HK_NULL)
        REMOVE("savedCharacterState", "unsigned char")
        REMOVE("newCharacterState", "unsigned char")
        REMOVE("pathFollowingProperties", "hkaiPathFollowingProperties*")
        REMOVE("traversalState", "hkaiGatePath::TraversalState")
        REMOVE("gatePath", "hkaiGatePath*")
        REMOVE("updateQuerySize", "float")
        DEPENDS("hkaiSingleCharacterBehavior", 0)
        DEPENDS("hkaiPathFollowingProperties", 6)
        DEPENDS("hkaiGatePath::TraversalState", 0)
        DEPENDS("hkaiGatePath", 0)
END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
