// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Common specific product patches applied to release 2016_1.
// This file is #included by hkPatches_2016_1.cpp

// hkNewBase
#if defined(HK_BUILDING_WITH_ENGINE)
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkTag", 0)
    SET_PARENT(HK_NULL, "hkReferencedObject")
    ADD("name", "hkName")
    ADD("uuid", "hkUuid")
    ADD("bitIdx", "int")
    DEPENDS("hkName", 0)
    DEPENDS("hkUuid", 1)
    DEPENDS("hkReferencedObject", 3)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkTagGroup", 0)
    SET_PARENT(HK_NULL, "hkReferencedObject")
    ADD("name", "hkName")
    ADD("tags", "hkHashMap< hkName, hkTag*>")
    DEPENDS("hkTag", 0)
    DEPENDS("hkHashMap< hkName, hkTag*>", 0)
    DEPENDS("hkName", 0)
    DEPENDS("hkReferencedObject", 3)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkTagSet", 0)
    SET_PARENT(HK_NULL, "hkBaseObject")
    ADD("tagGroup", "hkTagGroup")
    ADD("bits", "hkBitField")
    DEPENDS("hkBitField", 2)
    DEPENDS("hkTagGroup", 0)
    DEPENDS("hkBaseObject", 0)
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkTagValue", 0)
    SET_PARENT(HK_NULL, "hkBaseObject")
    ADD("tagGroup", "hkTagGroup")
    ADD("value", "int")
    DEPENDS("hkTagGroup", 0)
    DEPENDS("hkBaseObject", 0)
END()
#endif

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::OpaqueType", 0)
        SET_PARENT(HK_NULL, "hkReflect::Type")
        DEPENDS("hkReflect::Type", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::VoidType", 0)
        SET_PARENT(HK_NULL, "hkReflect::Type")
        DEPENDS("hkReflect::Type", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::RecordType", 0)
        SET_PARENT(HK_NULL, "hkReflect::CompoundType")
        DEPENDS("hkReflect::CompoundType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::ArrayType", 0)
        SET_PARENT(HK_NULL, "hkReflect::ContainerType")
        DEPENDS("hkReflect::ContainerType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::ContainerType", 0)
        SET_PARENT(HK_NULL, "hkReflect::CompoundType")
        DEPENDS("hkReflect::CompoundType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::PointerType", 0)
        SET_PARENT(HK_NULL, "hkReflect::CompoundType")
        DEPENDS("hkReflect::CompoundType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::StringType", 0)
        SET_PARENT(HK_NULL, "hkReflect::ValueType")
        DEPENDS("hkReflect::ValueType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::FloatType", 0)
        SET_PARENT(HK_NULL, "hkReflect::ValueType")
        DEPENDS("hkReflect::ValueType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::IntType", 0)
        SET_PARENT(HK_NULL, "hkReflect::ValueType")
        DEPENDS("hkReflect::ValueType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::BoolType", 0)
        SET_PARENT(HK_NULL, "hkReflect::ValueType")
        DEPENDS("hkReflect::ValueType", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::CompoundType", 0)
        SET_PARENT(HK_NULL, "hkReflect::Type")
        DEPENDS("hkReflect::Type", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkReflect::ValueType", 0)
        SET_PARENT(HK_NULL, "hkReflect::Type")
        DEPENDS("hkReflect::Type", 0)
END()
BEGIN("hkxLight", 3, "hkxLight", 4)
        ADD("innerAngle", "hkReal")
        ADD("outerAngle", "hkReal")
        FUNCTION(hkxLight_3_to_4_var)
        REMOVE("angle", "float")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkInetAddr", 0)
        ADD("ipAddress", "hkInt32")
        ADD("port", "hkUint16")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkRadians", 0)
        ADD("radians", "hkReal")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMpRational", 0)
        ADD("num", "hkMpUint")
        ADD("den", "hkMpUint")
        ADD("signed", "bool")
        DEPENDS("hkMpUint", 0)
        DEPENDS("hkMpUint", 0)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkMpUint", 0)
        ADD("atoms", "hkArray< hkUint32 >")
END()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel::BlendShape", 1)
        ADD("name", "hkStringPtr")
        ADD("channnels", "hkArray< hkxBlendShapeCollectionChannel::Channel >")
        DEPENDS("hkxBlendShapeCollectionChannel::Channel", 1)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel::Channel", 1)
        ADD("name", "hkStringPtr")
        ADD("keyFrames", "hkArray< hkxBlendShapeCollectionChannel::KeyFrame >")
        ADD("curves", "hkArray< hkxBlendShapeCollectionChannel::FloatCurve >")
        DEPENDS("hkxBlendShapeCollectionChannel::KeyFrame", 1)
        DEPENDS("hkxBlendShapeCollectionChannel::FloatCurve", 1)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel::FloatCurve", 1)
        ADD("name", "hkStringPtr")
        ADD("values", "hkArray< hkxBlendShapeCollectionChannel::FloatCurveKey >")
        ADD("timeStart", "hkInt64")
        ADD("timeEnd", "hkInt64")
        DEPENDS("hkxBlendShapeCollectionChannel::FloatCurveKey", 1)
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel::FloatCurveKey", 1)
        ADD("name", "hkStringPtr")
        ADD("value", "float")
        ADD("time", "hkInt64")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel::KeyFrame", 1)
        ADD("name", "hkStringPtr")
        ADD("baseVertex", "hkUint32")
        ADD("vertexCount", "hkUint32")
        ADD("timeWeight", "double")
END()
BEGIN(HK_NULL, HK_CLASS_ADDED, "hkxBlendShapeCollectionChannel", 1)
        SET_PARENT(HK_NULL, "hkReferencedObject")
        ADD("name", "hkStringPtr")
        ADD("blendShapes", "hkArray< hkxBlendShapeCollectionChannel::BlendShape >")
        ADD("vertData", "hkxVertexBuffer")
        DEPENDS("hkReferencedObject", 3)
        DEPENDS("hkxBlendShapeCollectionChannel::BlendShape", 1)
        DEPENDS("hkxVertexBuffer", 1)
END()

BEGIN_EMPTY(HK_NULL, HK_CLASS_ADDED, "hkReflect::Type", 0)
END_EMPTY()
BEGIN_EMPTY(HK_NULL, HK_CLASS_ADDED, "hkReflect::Detail::Opaque", 0)
END_EMPTY()

BEGIN(HK_NULL, HK_CLASS_ADDED, "hkImageHeader", 0)
        ADD("numMipLevels", "hkUint32")
        ADD("numFaces", "hkUint32")
        ADD("numArrayElements", "hkUint32")
        ADD("width", "hkUint32")
        ADD("height", "hkUint32")
        ADD("depth", "hkUint32")
        ADD("format", "hkImageFormat::Enum")
END()


// hkeNodeComponent::getKey used to return a typle of <const hkReflect::Type*, const char*> which got serialized into hkObjectPath instances
// const char* should not be serialized directly since we're deallocating this string shortly after deserialization.
// This patch converts these existing tuples to tuples of <const hkReflect::Type*, hkStringPtr> which will work fine with the existing data.
BEGIN_EMPTY("hkTuple< T*< hkReflect::Type >, const char*, void, void, void, void, void, void >", 0, "hkTuple< T*< hkReflect::Type >, hkStringPtr, void, void, void, void, void, void >", 0)
END_EMPTY()
#if !defined(HK_FEATURE_PRODUCT_PHYSICS_2012)

// These moved from Common to Physics2012

BEGIN( "hkSweptTransform", 1, HK_NULL, HK_CLASS_REMOVED )
    REMOVE( "centerOfMassLocal", "hkVector4f" )
    REMOVE( "rotation1", "hkVector4f" )
    REMOVE( "rotation0", "hkVector4f" )
    REMOVE( "centerOfMass1", "hkVector4f" )
    REMOVE( "centerOfMass0", "hkVector4f" )
END()

// Destruction Ph2012 bridge registers this one
#if !defined(HK_FEATURE_PRODUCT_DESTRUCTION)
BEGIN( "hkMotionState", 3, HK_NULL, HK_CLASS_REMOVED )
    REMOVE( "sweptTransform", "hkVector4f[5]" )
    REMOVE( "maxAngularVelocity", "hkUFloat8" )
    REMOVE( "maxLinearVelocity", "hkUFloat8" )
    REMOVE( "timeFactor", "float" )
    REMOVE( "deactivationClass", "unsigned char" )
    REMOVE( "angularDamping", "float" )
    REMOVE( "linearDamping", "float" )
    REMOVE( "objectRadius", "float" )
    REMOVE( "deltaAngle", "hkVector4f" )
    REMOVE( "transform", "hkMatrix4Impl< float >" )
    DEPENDS( "hkUFloat8", 0 )
END()
#endif

BEGIN( "hkTraceStream::Title", 0, HK_NULL, HK_CLASS_REMOVED )
    REMOVE( "value", "const char*" )
END()

BEGIN( "hkContactPointMaterial", 1, HK_NULL, HK_CLASS_REMOVED )
    REMOVE( "maxImpulse", "hkUFloat8" )
    REMOVE( "friction", "hkUFloat8" )
    REMOVE( "flags", "unsigned char" )
    REMOVE( "restitution", "unsigned char" )
    REMOVE( "userData", "int" )
    DEPENDS( "hkUFloat8", 0 )
    DEPENDS( "hkUFloat8", 0 )
END()

#endif  // !HK_FEATURE_PRODUCT_PHYSICS_2012

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
