// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

void hkpGroupFilter_0_to_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    obj["nextFreeSystemGroup"].assign(obj["old_nextFreeSystemGroup"]);

    hkReflect::ArrayVar crtVals(obj["old_collisionLookupTable"]);
    hkReflect::ArrayVar newVals(obj["collisionLookupTable"]);

    const int crtSize = crtVals.getCount();
    const int newSize = newVals.getCount();
    const int minSize = (crtSize < newSize) ? crtSize : newSize;

    for (int k = minSize - 1; k >= 0; k--)
    {
        hkReflect::IntVar(newVals[k]).setValue((unsigned int)hkReflect::IntVar(crtVals[k]).getValue().convertTo<int>());
    }
}

void HK_CALL registerPhysicsPatches_2015_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2015_1/hkpPatches_2015_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
