// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Math/Vector/hkPackedVector3.h>

namespace
{
    void hknpLodMeshShape_infos_4_to_5_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper, const char* oldName, const char* newName)
    {
        hkReflect::Var srcArray(obj[oldName]);
        hkReflect::Var dstArray(obj[newName]);

        dstArray[0].assign(srcArray[0]);
        dstArray[1].assign(srcArray[1]);
        dstArray[2].assign(srcArray[2]);
        dstArray[3].assign(srcArray[3]);
    }

    void hknpLodShape_variants_4_to_5_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper, const char* oldName, const char* newName)
    {
        hkReflect::Var srcArray(obj[oldName]);
        hkReflect::Var dstArray(obj[newName]);

        dstArray[0].assign(srcArray[0]);
        dstArray[1].assign(srcArray[1]);
        dstArray[2].assign(srcArray[2]);
        dstArray[3].assign(srcArray[3]);
    }

    void hkFLAE_hknpShapeInstance_1_to_2(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        obj["destructionTag"].assign(obj["destructionTag_copy"]);
        obj["shapeTag"].assign(obj["shapeTag_copy"]);
        obj["shape"].assign(obj["shape_copy"]);
        obj["scale"].assign(obj["scale_copy"]);
        obj["transform"].assign(obj["transform_copy"]);
        obj["padding"].assign( obj["padding_copy"] );
    }

    void hkFLAE_hknpMotionProperties_3_to_4(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        obj["timeFactor"].assign(obj["timeFactor_copy"]);
        obj["flags"].assign(obj["flags_copy"]);
        obj["maxAngularSpeed"].assign(obj["maxAngularSpeed_copy"]);
        obj["maxLinearSpeed"].assign(obj["maxLinearSpeed_copy"]);
        obj["minimumSpikingVelocityScaleSquared"].assign(obj["minimumSpikingVelocityScaleSquared_copy"]);
        obj["spikingVelocityScaleThresholdSquared"].assign(obj["spikingVelocityScaleThresholdSquared_copy"]);
        obj["minimumPathingVelocityScaleSquare"].assign(obj["minimumPathingVelocityScaleSquare_copy"]);
        obj["deactivationVelocityScaleSquare"].assign(obj["deactivationVelocityScaleSquare_copy"]);
        obj["numDeactivationFrequencyPasses"].assign(obj["numDeactivationFrequencyPasses_copy"]);
        obj["pathingLowerThreshold"].assign(obj["pathingLowerThreshold_copy"]);
        obj["pathingUpperThreshold"].assign(obj["pathingUpperThreshol_copy"]);
        obj["invBlockSize"].assign(obj["invBlockSize_copy"]);
        obj["maxRotSqrd"].assign(obj["maxRotSqrd_copy"]);
        obj["maxDistSqrd"].assign(obj["maxDistSqrd_copy"]);
        obj["solverStabilizationSpeedReduction"].assign(obj["solverStabilizationSpeedReduction_copy"]);
        obj["solverStabilizationSpeedThreshold"].assign(obj["solverStabilizationSpeedThreshold_copy"]);
        obj["gravityFactor"].assign(obj["gravityFactor_copy"]);
        obj["angularDamping"].assign(obj["angularDamping_copy"]);
        obj["linearDamping"].assign(obj["linearDamping_copy"]);
        obj["isExclusive"].assign(obj["isExclusive_copy"]);
    }

    void hkFLAE_hknpMaterial_2_To_3(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        obj["userData"].assign(obj["userData_copy"]);
        obj["fractionOfClippedImpulseToApply"].assign(obj["fractionOfClippedImpulseToApply_copy"]);
        obj["restitution"].assign(obj["restitution_copy"]);
        obj["staticFriction"].assign(obj["staticFriction_copy"]);
        obj["dynamicFriction"].assign(obj["dynamicFriction_copy"]);
        obj["isShared"].assign(obj["isShared_copy"]);
        obj["disablingCollisionsBetweenCvxCvxDynamicObjectsDistance"].assign(obj["disablingCollisionsBetweenCvxCvxDynamicObjectsDistance_copy"]);
        obj["surfaceVelocity"].assign(obj["surfaceVelocity_copy"]);
        obj["softContactSeperationVelocity"].assign(obj["softContactSeperationVelocity_copy"]);
        obj["softContactDampFactor"].assign(obj["softContactDampFactor_copy"]);
        obj["softContactForceFactor"].assign(obj["softContactForceFactor_copy"]);
        obj["maxContactImpulse"].assign(obj["maxContactImpulse_copy"]);
        obj["massChangerHeavyObjectFactor"].assign(obj["massChangerHeavyObjectFactor_copy"]);
        obj["massChangerCategory"].assign(obj["massChangerCategory_copy"]);
        obj["triggerManifoldTolerance"].assign(obj["triggerManifoldTolerance_copy"]);
        obj["triggerType"].assign(obj["triggerType_copy"]);
        obj["weldingTolerance"].assign(obj["weldingTolerance_copy"]);
        obj["restitutionCombinePolicy"].assign(obj["restitutionCombinePolicy_copy"]);
        obj["frictionCombinePolicy"].assign(obj["frictionCombinePolicy_copy"]);
        obj["flags"].assign(obj["flags_copy"]);
        obj["isExclusive"].assign(obj["isExclusive_copy"]);
        obj["name"].assign(obj["name_copy"]);
    }

    static void hknpConstraintCinfo_4_to_5_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
    {
        const hkUint32 constraintGroupId = hkUint32(HK_INT32_MAX);
        obj["constraintGroupId"]["value"].assign(&constraintGroupId);
    }
}

void HK_CALL registerNewPhysicsPatches_2015_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2015_1/hknpPatches_2015_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
