// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Serialize/Version/hkVersionBundle.h>

// Registration function is at the end of the file

static void hkndDeformableShape_2_to_3_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::Var skinData = helper.newObject("hkndSkinnedPhysicsShape::SkinData");

    hkReflect::PointerVar(obj["skinData"]).setValue(skinData);

    // Copy vertex buffer
    skinData["vertexBuffer"].assign(obj["vertices"]);

    // Copy index buffer
    skinData["indexBuffer"].assign(obj["indexBuffer"]);

    // Copy bone indices
    skinData["boneIndices"].assign(obj["boneIndices"]);

    // Convert groups
    {
        hkReflect::ArrayVar srcGroups(obj["groups"]);
        hkReflect::ArrayVar dstSets(skinData["vertexSets"]);
        const int numGroups = srcGroups.getCount();

        dstSets.setArraySize(numGroups);
        int numBones = 0;
        for (int gi = 0; gi < numGroups; gi++)
        {
            hkReflect::Var srcGroup(srcGroups[gi]);
            hkReflect::Var dstSet(dstSets[gi]);

            // We need the values to work out numBones
            const int boneBufferStart = hkReflect::IntVar(srcGroup["boneBufferStart"]).getValue().convertTo<int>(); dstSet["bbOffset"].assign(&boneBufferStart);
            const int boneBufferLength = hkReflect::IntVar(srcGroup["boneBufferLength"]).getValue().convertTo<int>(); dstSet["numBones"].assign(&boneBufferLength);
            const int indexBufferStart = hkReflect::IntVar(srcGroup["indexBufferStart"]).getValue().convertTo<int>(); dstSet["ibOffset"].assign(&indexBufferStart);
            const int indexBufferLength = hkReflect::IntVar(srcGroup["indexBufferLength"]).getValue().convertTo<int>(); dstSet["numVertices"].assign(&indexBufferLength);
            numBones = hkMath::max2(numBones, boneBufferStart + boneBufferLength);
        }

        // Allocate the bone index buffer
        hkReflect::ArrayVar dstBoneIb(skinData["boneIndexBuffer"]);
        dstBoneIb.setArraySize(numBones);

        for (int bi = 0; bi < numBones; bi++)
        {
            hkReflect::IntVar(dstBoneIb[bi]).setValue(bi);
        }

        // Allocate the bones
        hkReflect::ArrayVar srcPose(obj["invBindPose"]);
        hkReflect::ArrayVar dstBones(skinData["bones"]);
        dstBones.setArraySize(numBones);
        HK_ASSERT_NO_MSG(0x40ef531c, numBones == srcPose.getCount());

        for (int bi = 0; bi < numBones; bi++)
        {
            hkReflect::Var dstBone = helper.newObject("hkndSkinnedPhysicsShape::Bone");
            hkReflect::PointerVar(dstBones[bi]).setValue(dstBone);

            // Get the inverse bind pose transform
            hkReflect::Var srcQtm(srcPose[bi]);
            hkQuaternion rot; hkReflect::Var(&rot).assign(srcQtm["rotation"]);
            hkVector4 trans; hkReflect::Var(&trans).assign(srcQtm["translation"]);
            hkQTransform invQtm;    invQtm.set(rot, trans);

            // Set the bind pose transform
            hkQTransform qtm;       qtm.setInverse(invQtm);
            hkReflect::Var dstQtm(dstBone["worldFromBone"]);
            dstQtm["rotation"].assign(&qtm.m_rotation);
            dstQtm["translation"].assign(&qtm.m_translation);
        }
    }
}

static void hkndDestructibleMeshBindingBoneBinding_0_to_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::PointerVar srcObjPointer(obj["drivingPieceIdentityOld"]);
    //hkReflect::ArrayVar(obj["drivingPieceIdentity"]["data"]).assign(hkReflect::ArrayVar(srcObjPointer.getValue()["uuid"]["data"]));
    // This doesn't work, because the types don't quite match
    hkReflect::ArrayVar dstArray(obj["drivingPieceIdentity"]["data"]);
    hkReflect::ArrayVar srcArray(srcObjPointer.getValue()["uuid"]["data"]);

    for (int i = 0; i < 4; i++)
    {
        const hkUint32 val = hkReflect::IntVar(srcArray[i]).getValue().convertTo<hkUint32>();
        dstArray[i].assign(&val);
    }
}

static void hkndFracturePiece_4_to_5_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    const hkUint32 materialId_old = hkUint32(hkReflect::IntVar(obj["materialId_old"]).getValue().convertTo<int>());
    obj["materialId"]["value"].assign(&materialId_old);

    const hkUint32 parentId_old = hkUint32(hkReflect::IntVar(obj["parentId_old"]).getValue().convertTo<int>());
    obj["parentId"]["value"].assign(&parentId_old);

    const hkUint32 firstChildId_old = hkUint32(hkReflect::IntVar(obj["firstChildId_old"]).getValue().convertTo<int>());
    obj["firstChildId"]["value"].assign(&firstChildId_old);

    const hkUint32 nextSiblingId_old = hkUint32(hkReflect::IntVar(obj["nextSiblingId_old"]).getValue().convertTo<int>());
    obj["nextSiblingId"]["value"].assign(&nextSiblingId_old);
}

static void hkndConnection_3_to_4_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::ArrayVar src(obj["piecesOld"]);
    hkReflect::ArrayVar dst(obj["pieces"]);
    const int n = src.getCount();

    dst.setArraySize(n);
    for (int k = n - 1; k >= 0; k--)
    {
        dst[k]["value"].assign(src[k]);
    }

}

static void hkFLAE_hkndMaterial_1_to_2(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    obj["userData"].assign(obj["userData_copy"]);
    obj["flags"].assign(obj["flags_copy"]);
    obj["yieldStrength"].assign(obj["yieldStrength_copy"]);
    obj["breakingStrength"].assign(obj["breakingStrength_copy"]);
    obj["elasticity"].assign(obj["elasticity_copy"]);
    obj["destructionRadius"].assign(obj["destructionRadius_copy"]);
    obj["density"].assign(obj["density_copy"]);
}

void HK_CALL registerNewDestructionPatches_2015_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2015_1/hkndPatches_2015_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
