// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Base/KeyCode.h>

static void hkaiStreamingSets_to_hkaiAnnotatedStreamingSets_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper, const char* oldName, const char* newName)
{
    hkReflect::ArrayVar streamingSets(obj[oldName]);
    hkReflect::ArrayVar annotatedStreamingSets(obj[newName]);

    annotatedStreamingSets.setArraySize(streamingSets.getCount());

    for (int i = 0; i < streamingSets.getCount(); i++)
    {
        hkReflect::Var streamingSet(streamingSets[i]);
        hkReflect::Var annotatedStreamingSet(annotatedStreamingSets[i]);

        hkReflect::IntVar(annotatedStreamingSet["side"]).setValue(0);
        hkReflect::PointerVar(annotatedStreamingSet["streamingSet"]).setValue(streamingSet);
    }
}

static void hkaiStreamingSet_NavMeshConnection_0_to_1_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    hkReflect::Var aFaceEdgeIndex(obj["aFaceEdgeIndex"]);
    aFaceEdgeIndex["faceIndex"].assign(obj["faceIndex"]);
    aFaceEdgeIndex["edgeIndex"].assign(obj["edgeIndex"]);
    hkReflect::Var bFaceEdgeIndex(obj["bFaceEdgeIndex"]);
    bFaceEdgeIndex["faceIndex"].assign(obj["oppositeFaceIndex"]);
    bFaceEdgeIndex["edgeIndex"].assign(obj["oppositeEdgeIndex"]);
}

static void hkaiStreamingSet_GraphConnection_3_to_4_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    obj["bEdgeCost"].assign(obj["aEdgeCost"]);
    obj["bEdgeData"].assign(obj["aEdgeData"]);
}

static void hkaiStreamingCollectionInstanceInfo_4_to_5_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x191e46ca, "Upgrading hkaiStreamingCollectionInstanceInfo from version 4 to 5 not implemented. Please reexport your data.");
}

static void hkaiNavMeshCutter_19_to_20_var(hkReflect::Var obj, hkSerialize::PatchFunctionHelper& helper)
{
    HK_ERROR(0x4a10f6a9, "Upgrading a hkaiNavMeshCutter from version 19 to 20 not implemented. Please reexport your data.");
}

void HK_CALL registerAiPatches_2015_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2015_1/hkaiPatches_2015_1.hxx>
#   include <Common/Base/Reflect/Version/hkReflectRegisterPatches.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
