// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace hkCompat
{
    extern void copyQsTransform(hkDataObject& obj, const char* oldName, const char* newName);
    extern void copyArrayOfQsTransforms(hkDataObject& obj, const char* oldName, const char* newName);
}

using namespace hkCompat;

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    void copyObjectMembers(hkDataObject srcObj, hkDataObject dstObj)
    {
        const hkDataClass objectClass = srcObj.getClass();
        hkArray<hkDataClass::MemberInfo> memberInfos;
        objectClass.getAllMemberInfos(memberInfos);

        for (int i = 0; i < memberInfos.getSize(); i++)
        {
            const char* memberName = memberInfos[i].m_name;
            dstObj[memberName] = srcObj[memberName];
        }
    }

    void hkpEntity_3_to_4(hkDataObject& obj)
    {
        copyObjectMembers(obj["motion_old"].asObject(), obj["motion"].asObject());
    }

    void hkpSerializedTrack1nInfo_sectors_0_to_1(hkDataObject& obj, const char*, const char*)
    {
        HK_ERROR(0x275405b2, "Versioning hkpSerializedTrack1nInfo not supported");
    }
}
void HK_CALL registerPhysicsPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkpPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
