// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Types/Uuid/hkUuid.h>

// Registration function is at the end of the file

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    static void copyArrayOfObjectMembers( hkDataObject& obj, const char* oldName, const char* newName )
    {
        hkDataArray srcArray = obj[oldName].asArray();
        hkDataArray dstArray = obj[newName].asArray();

        const int size = srcArray.getSize();
        if (size)
        {
            const hkDataClass objectClass = srcArray.getClass();
            dstArray.setSize( size );

            for (int j = 0; j < size; j++)
            {
                hkDataObject srcObj = srcArray[j].asObject();
                hkDataObject dstObj = dstArray[j].asObject();

                hkArray<hkDataClass::MemberInfo> memberInfos;
                objectClass.getAllMemberInfos( memberInfos );

                for (int i = 0; i < memberInfos.getSize(); i++)
                {
                    const char* memberName = memberInfos[i].m_name;
                    dstObj[memberName] = srcObj[memberName];
                }
            }
        }
    }
}

static void copyUuid(hkDataObject& srcUuid, hkDataObject& dstUuid)
{
    hkDataArray srcUuidData = srcUuid["data"].asArray();
    hkDataArray dstUuidData = dstUuid["data"].asArray();
    const int numUuidValues = srcUuidData.getSize();

    dstUuidData.setSize(numUuidValues);
    for (int k = numUuidValues - 1; k >= 0; k--)
    {
        const hkUint32 i    = srcUuidData[k].asInteger<hkUint32>();
        dstUuidData[k]      = i;
    }
}

static void hkndDebrisFracture_2_to_3(hkDataObject& obj)
{
    // Find the classes and create the new objects
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass emitterClass    (world->findClass("hkndDebrisFracture::EmissionSource"));
    hkDataObject emitter        = world->newObject(emitterClass);
    hkDataClass infoClass       (world->findClass("hkndDebrisFractureInfo::DefaultEmissionInfo"));
    hkDataObject emitterInfo    = world->newObject(infoClass);

    hkDataArray emitters = obj["emissionSources"].asArray();
    emitters.setSize(1);
    emitters[0] = emitter;

    hkDataArray infos = emitter["debrisCollections"].asArray();
    infos.setSize(1);
    infos[0] = emitterInfo;

    // Copy the data into the emitter info
    {
        const hkReal density    = obj["density"].asReal();
        emitterInfo["density"]  = density;

        hkDataObject srcUuid = obj["debrisTemplateUuid"].asObject();
        hkDataObject dstUuid = emitterInfo["debrisTemplateUuid"].asObject();
        copyUuid(srcUuid, dstUuid);
    }
}

static void upgradeTemplateInfo(hkDataObject& obj, const char* oldMemberName, const char* newMemberName)
{
    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDebrisFractureInfo::DefaultEmissionInfo"));
    hkDataObject dstObject      = world->newObject(ndClass);

    // Copy the data from the old one
    hkDataObject srcObject      = obj[oldMemberName].asObject();
    {
        const hkReal density = srcObject["density"].asReal();
        dstObject["density"] = density;

        hkDataObject srcUuid = srcObject["debrisTemplateUuid"].asObject();
        hkDataObject dstUuid = dstObject["debrisTemplateUuid"].asObject();
        copyUuid(srcUuid, dstUuid);
    }

    obj[newMemberName] = dstObject;
}

static void hkndDebrisFractureInfo_0_to_1(hkDataObject& obj)
{
    upgradeTemplateInfo(obj, "oldInfo0", "info0");
    upgradeTemplateInfo(obj, "oldInfo1", "info1");
    upgradeTemplateInfo(obj, "oldInfo2", "info2");
}

static void hkndDecorateFractureFaceRuntimeGlobalDecorationData_2_to_3(hkDataObject& obj)
{
    // Allocate providers
    hkDataArray srcUuids    = obj["providerUuids"].asArray();
    hkDataArray providers   = obj["providers"].asArray();
    const int numProviders  = srcUuids.getSize();
    providers.setSize(numProviders);

    // Find the provider class
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDecorateFractureFaceAction::DefaultDecorationsSet"));

    // Copy the data
    for (int k = numProviders - 1; k >= 0; k--)
    {
        hkDataObject srcUuid    = srcUuids[k].asObject();
        hkDataObject provider   = world->newObject(ndClass);
        hkDataObject dstUuid    = provider["decorationsTemplateUuid"].asObject();

        providers[k] = provider;

        // Copy the UUID
        copyUuid(srcUuid, dstUuid);
    }
}

static void hkndDecorateFractureFaceActionFractureFaceInfo_1_to_2(hkDataObject& obj)
{
    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDecorateFractureFaceAction::DefaultDecorationsSet"));
    hkDataObject provider       = world->newObject(ndClass);
    obj["decorationsSet"]       = provider;

    // Copy density
    const hkReal density = obj["oldDensity"].asReal();
    obj["density"] = density;

    // Copy UUID
    hkDataObject srcUuid = obj["decorationsUuid"].asObject();
    hkDataObject dstUuid = provider["decorationsTemplateUuid"].asObject();
    copyUuid(srcUuid, dstUuid);
}

static void hkndDecorateFractureFaceActionCornerDecorationInfo_1_to_2(hkDataObject& obj)
{
    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDecorateFractureFaceAction::DefaultDecorationsSet"));
    hkDataObject provider       = world->newObject(ndClass);
    obj["decorationsSet"]       = provider;

    // Copy density
    const hkReal density = obj["oldDensity"].asReal();
    obj["density"] = density;

    // Copy UUID
    hkDataObject srcUuid = obj["decorationsUuid"].asObject();
    hkDataObject dstUuid = provider["decorationsTemplateUuid"].asObject();
    copyUuid(srcUuid, dstUuid);
}

static void copyLinePlacementInfo(hkDataObject& dst, const hkDataObject& src)
{
    hkDataObject decoSet            = src["decorationsSet"].asObject();
    const hkReal density            = src["density"].asReal();
    const hkReal gap                = src["gap"].asReal();
    const hkReal spinAngle          = src["spinAngle"].asReal();
    const hkReal randomSpinAngle    = src["randomSpinAngle"].asReal();
    const bool allowRandomFlipX     = src["allowRandomFlipX"].asInt();
    const hkReal xShift             = src["xShift"].asReal();
    const hkReal xRandomShift       = src["xRandomShift"].asReal();

    dst["decorationsSet"]   = decoSet;
    dst["density"]          = density;
    dst["gap"]              = gap;
    dst["spinAngle"]        = spinAngle;
    dst["randomSpinAngle"]  = randomSpinAngle;
    dst["allowRandomFlipX"] = allowRandomFlipX;
    dst["xShift"]           = xShift;
    dst["xRandomShift"]     = xRandomShift;
}

static void copyCornerPlacementInfo(hkDataObject& dst, const hkDataObject& src)
{
    hkDataObject decoSet                = src["decorationsSet"].asObject();
    const hkReal density                = src["density"].asReal();
    const hkReal minimumDistance        = src["minimumDistance"].asReal();
    const hkReal maximumVerticalShift   = src["maximumVerticalShift"].asReal();

    dst["decorationsSet"]       = decoSet;
    dst["density"]              = density;
    dst["minimumDistance"]      = minimumDistance;
    dst["maximumVerticalShift"] = maximumVerticalShift;
}

static void hkndDecorateFractureFaceInfo_0_to_1(hkDataObject& obj)
{
    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDecorateFractureFaceAction::LinePlacementInfo"));

    {
        hkDataObject dstInfo    = world->newObject(ndClass);
        hkDataObject srcInfo    = obj["oldDecorations"].asObject();
        obj["decorations"]      = dstInfo;

        copyLinePlacementInfo(dstInfo, srcInfo);
        if ( obj["enableDecorations"].asInt() == 0 )
        {
            dstInfo["density"] = 0.0f;
        }
    }
}

static void hkndDecorateCornerInfo_0_to_1(hkDataObject& obj)
{
    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndClass         (world->findClass("hkndDecorateFractureFaceAction::CornerPlacementInfo"));

    {
        hkDataObject dstInfo    = world->newObject(ndClass);
        hkDataObject srcInfo    = obj["oldCornerTemplates"].asObject();
        obj["cornerTemplates"]  = dstInfo;

        copyCornerPlacementInfo(dstInfo, srcInfo);
        if ( obj["enableCornerDecorations"].asInt() == 0 )
        {
            dstInfo["density"] = 0.0f;
        }
    }
}

static void hkndDecorateFractureFaceAction_1_to_2(hkDataObject& obj)
{
    // Find the class
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass lpiClass        (world->findClass("hkndDecorateFractureFaceAction::LinePlacementInfo"));
    hkDataClass cpiClass        (world->findClass("hkndDecorateFractureFaceAction::CornerPlacementInfo"));

    {
        hkDataObject src = obj["oldTop"].asObject();
        hkDataObject dst = world->newObject(lpiClass);
        obj["top"] = dst;

        copyLinePlacementInfo(dst, src);
    }
    {
        hkDataObject src = obj["oldBottom"].asObject();
        hkDataObject dst = world->newObject(lpiClass);
        obj["bottom"] = dst;

        copyLinePlacementInfo(dst, src);
    }
    {
        hkDataObject src = obj["oldSide"].asObject();
        hkDataObject dst = world->newObject(lpiClass);
        obj["side"] = dst;

        copyLinePlacementInfo(dst, src);
    }
    {
        hkDataObject src = obj["oldFlat"].asObject();
        hkDataObject dst = world->newObject(lpiClass);
        obj["flat"] = dst;

        copyLinePlacementInfo(dst, src);
    }
    {
        hkDataObject src = obj["oldCorner"].asObject();
        hkDataObject dst = world->newObject(cpiClass);
        obj["corner"] = dst;

        copyCornerPlacementInfo(dst, src);
    }
}

static void hkndDecorateCornerInfoContainer_0_to_1(hkDataObject& obj)
{
    hkDataArray srcInfos = obj["infos_old"].asArray();
    hkDataArray dstInfos = obj["infos"].asArray();
    const int numInfos = srcInfos.getSize();
    dstInfos.setSize(numInfos);

    // Find the class and create the new object
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass cpiClass        (world->findClass("hkndDecorateFractureFaceAction::CornerPlacementInfo"));

    for (int k = numInfos - 1; k >= 0; k--)
    {
        hkDataObject srcInfo = srcInfos[k].asObject();
        hkDataObject dstInfo = world->newObject(cpiClass);
        dstInfos[k] = dstInfo;

        hkDataObject srcTemplates = srcInfo["cornerTemplates"].asObject();
        copyCornerPlacementInfo(dstInfo, srcTemplates);
        if ( srcInfo["enableCornerDecorations"].asInt() == 0 )
        {
            dstInfo["density"] = 0.0f;
        }
    }
}

static void hkndFracturePiece_3_to_4(hkDataObject& obj)
{
    const hkUint32 oldConnId = obj["firstConnectionId_old"].asInt();
    const hkUint32 newConnId = (oldConnId == 0xFFFF) ? hkUint32(-1) : oldConnId;

    hkDataObject newObj = obj["firstConnectionId"].asObject();
    newObj["value"] = newConnId;
}

static void hkndConnection_1_to_2(hkDataObject& obj)
{
    hkDataArray oldConns = obj["next_old"].asArray();
    hkDataArray newConns = obj["next"].asArray();

    for (int k = oldConns.getSize() - 1; k >= 0; k--)
    {
        const hkUint32 oldConnId = oldConns[k].asInt();
        const hkUint32 newConnId = (oldConnId == 0xFFFF) ? hkUint32(-1) : oldConnId;

        hkDataObject newConn = newConns[k].asObject();
        newConn["value"] = newConnId;
    }
}

static void hkndHierarchy_1_to_2(hkDataObject& obj)
{
    const hkUint32 oldConnId = obj["firstFreeConnectionId_old"].asInt();
    const hkUint32 newConnId = (oldConnId == 0xFFFF) ? hkUint32(-1) : oldConnId;

    hkDataObject newObj = obj["firstFreeConnectionId"].asObject();
    newObj["value"] = newConnId;
}

static void hkndBodyCinfo_1_to_2(hkDataObject& obj)
{
    const hkUint32 oldRbId  = obj["rigidBodyId_old"].asInt();
    hkDataObject newObj     = obj["rigidBodyId"].asObject();

    newObj["serialAndIndex"] = oldRbId;
}

static void hkndCompoundShape_0_to_1(hkDataObject& obj)
{
    const hkUint32 oldCompoundPieceId = obj["compoundPieceId_old"].asInt();
    hkDataObject newObj = obj["compoundPieceId"].asObject();
    newObj["value"] = oldCompoundPieceId;

    hkDataArray oldChildPieceIds    = obj["childPieceIds_old"].asArray();
    hkDataArray newChildPieceIds    = obj["childPieceIds"].asArray();
    const int numChildPieceIds      = oldChildPieceIds.getSize();
    newChildPieceIds.setSize(numChildPieceIds);

    for (int k = numChildPieceIds - 1; k >= 0; k--)
    {
        const hkUint32 v    = oldChildPieceIds[k].asInt();
        hkDataObject o      = newChildPieceIds[k].asObject();
        o["value"] = v;
    }
}

static void hkndDebugGraphics_0_to_1(hkDataObject& obj)
{
    // Find classes
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass lineClass       (world->findClass("hkndDebugGraphics::Line"));
    hkDataClass textClass       (world->findClass("hkndDebugGraphics::Text"));
    hkDataClass triClass        (world->findClass("hkndDebugGraphics::Triangle"));

    // Get old primitives
    hkDataArray srcLines    = obj["lines"].asArray();
    hkDataArray srcTexts    = obj["texts"].asArray();
    hkDataArray srcTris     = obj["tris"].asArray();
    const int numLines      = srcLines.getSize();
    const int numTexts      = srcTexts.getSize();
    const int numTris       = srcTris.getSize();

    // Allocate new ones
    hkDataArray dstObjects  = obj["primitives"].asArray();
    const int numObjects    = numLines + numTexts + numTris;
    dstObjects.setSize(numObjects);

    int dstIdx = 0;

    // Add lines
    for (int k = 0; k < numLines; k++)
    {
        hkDataObject src        = srcLines[k].asObject();
        hkDataObject dst        = world->newObject(lineClass);
        dstObjects[dstIdx++]    = dst;

        dst["start"]    = src["start"].asVector4();
        dst["end"]      = src["end"].asVector4();
        dst["color"]    = src["color"].asInt();
    }

    // Add texts
    for (int k = 0; k < numTexts; k++)
    {
        hkDataObject src        = srcTexts[k].asObject();
        hkDataObject dst        = world->newObject(textClass);
        dstObjects[dstIdx++]    = dst;

        dst["pos"]      = src["pos"].asVector4();
        dst["string"]   = src["string"].asString();
        dst["color"]    = src["color"].asInt();
    }

    // Add triangles
    for (int k = 0; k < numTris; k++)
    {
        hkDataObject src        = srcTris[k].asObject();
        hkDataObject dst        = world->newObject(triClass);
        dstObjects[dstIdx++]    = dst;

        dst["a"]        = src["a"].asVector4();
        dst["b"]        = src["b"].asVector4();
        dst["c"]        = src["c"].asVector4();
        dst["color"]    = src["color"].asInt();
    }
}

namespace
{
    void assignQTransformftoQTransform(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataObject::Array oldRotation = obj[oldName].asObject()["rotation"].asArray();
        hkDataObject::Array newRotation = obj[newName].asObject()["rotation"].asArray();
        hkDataObject::Array oldTranslation = obj[oldName].asObject()["translation"].asArray();
        hkDataObject::Array newTranslation = obj[newName].asObject()["translation"].asArray();

        newRotation[0] = oldRotation[0];
        newRotation[1] = oldRotation[1];
        newRotation[2] = oldRotation[2];
        newRotation[3] = oldRotation[3];

        newTranslation[0] = oldTranslation[0];
        newTranslation[1] = oldTranslation[1];
        newTranslation[2] = oldTranslation[2];
        newTranslation[3] = oldTranslation[3];
    }

    void assignArrayQTransformftoQTransform(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataObject::Array oldArray = obj[oldName].asArray();
        const int size = oldArray.getSize();
        if (size)
        {
            hkDataObject::Array newArray = obj[newName].asArray();
            newArray.setSize(size);
            for (int i = 0; i < size; i++)
            {
                hkDataObject::Array oldRotation = oldArray[i].asObject()["rotation"].asArray();
                hkDataObject::Array newRotation = newArray[i].asObject()["rotation"].asArray();
                hkDataObject::Array oldTranslation = oldArray[i].asObject()["translation"].asArray();
                hkDataObject::Array newTranslation = newArray[i].asObject()["translation"].asArray();

                newRotation[0] = oldRotation[0];
                newRotation[1] = oldRotation[1];
                newRotation[2] = oldRotation[2];
                newRotation[3] = oldRotation[3];

                newTranslation[0] = oldTranslation[0];
                newTranslation[1] = oldTranslation[1];
                newTranslation[2] = oldTranslation[2];
                newTranslation[3] = oldTranslation[3];
            }
        }
    }
}

namespace hkCompat
{
    void hkUint16_to_hkPackedVector3_Multiple(hkDataObject& obj, const char* oldName, const char* newName);
}

void HK_CALL registerNewDestructionPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkndPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
