// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file
namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    void assignQTransformftoQTransform(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataObject::Array oldRotation = obj[oldName].asObject()["rotation"].asArray();
        hkDataObject::Array newRotation = obj[newName].asObject()["rotation"].asArray();
        hkDataObject::Array oldTranslation = obj[oldName].asObject()["translation"].asArray();
        hkDataObject::Array newTranslation = obj[newName].asObject()["translation"].asArray();

        newRotation[0] = oldRotation[0];
        newRotation[1] = oldRotation[1];
        newRotation[2] = oldRotation[2];
        newRotation[3] = oldRotation[3];

        newTranslation[0] = oldTranslation[0];
        newTranslation[1] = oldTranslation[1];
        newTranslation[2] = oldTranslation[2];
        newTranslation[3] = oldTranslation[3];
    }

    void assignArrayQTransformftoQTransform(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataObject::Array oldArray = obj[oldName].asArray();
        const int size = oldArray.getSize();
        if (size)
        {
            hkDataObject::Array newArray = obj[newName].asArray();
            newArray.setSize(size);
            for (int i = 0; i < size; i++)
            {
                hkDataObject::Array oldRotation = oldArray[i].asObject()["rotation"].asArray();
                hkDataObject::Array newRotation = newArray[i].asObject()["rotation"].asArray();
                hkDataObject::Array oldTranslation = oldArray[i].asObject()["translation"].asArray();
                hkDataObject::Array newTranslation = newArray[i].asObject()["translation"].asArray();

                newRotation[0] = oldRotation[0];
                newRotation[1] = oldRotation[1];
                newRotation[2] = oldRotation[2];
                newRotation[3] = oldRotation[3];

                newTranslation[0] = oldTranslation[0];
                newTranslation[1] = oldTranslation[1];
                newTranslation[2] = oldTranslation[2];
                newTranslation[3] = oldTranslation[3];
            }
        }
    }

    void assignVec2ftoVec2(hkDataObject& obj, const char* oldName, const char* newName)
    {
        obj[newName].asArray()[0] = obj[oldName].asArray()[0].asReal();
        obj[newName].asArray()[1] = obj[oldName].asArray()[2].asReal();
    }
}

void HK_CALL registerDestructionPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkdPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
