// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    void copyObjectMembers( hkDataObject srcObj, hkDataObject dstObj )
    {
        const hkDataClass objectClass = srcObj.getClass();
        hkArray<hkDataClass::MemberInfo> memberInfos;
        objectClass.getAllMemberInfos( memberInfos );

        for (int i = 0; i < memberInfos.getSize(); i++)
        {
            const char* memberName = memberInfos[i].m_name;
            dstObj[memberName] = srcObj[memberName];
        }
    }
}

void hkcdStaticAabbTree_1_to_2(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    hkDataObject oldTree = obj["treePtr_old"].asObject();
    hkDataWorld world = obj.getWorld();
    hkDataClass newTreeClass = world.findClass("hkcdStaticAabbTree::Impl");
    hkDataObject newTree = world.newObject(newTreeClass);

    copyObjectMembers(oldTree, newTree);
    obj["treePtr"] = newTree;
}

void hkcdDynamicAabbTree_1_to_2(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;

    hkDataObject treePtrOld = obj["treePtr_old"].asObject();

    if (!treePtrOld.isNull())
    {
        hkDataObject oldTree = obj["treePtr_old"].asObject();
        hkDataWorld world = obj.getWorld();
        hkDataClass newTreeClass = world.findClass("hkcdDynamicAabbTree::Impl");
        hkDataObject newTree = world.newObject(newTreeClass);

        copyObjectMembers(oldTree, newTree);
        obj["treePtr"] = newTree;
    }
}

void hkcdPlanarSolid_0_to_1(hkDataObject& obj)
{
    obj["planes"] = obj["planes_old"].asObject();
}

void hkcdPlanarGeometry_0_to_1(hkDataObject& obj)
{
    obj["planes"] = obj["planes_old"].asObject();
}

void hkcdDynamicTreeCodecRawUint_0_to_new0(hkDataObject& obj)
{
    obj["aabb_new"] = obj["aabb"];
    obj["parent_new"] = obj["parent"];
    obj["children_new"] = obj["children"];
}

void hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis6_copyNodes(hkDataObject& obj)
{
    obj["newNodes"] = obj["nodes"];
}


void HK_CALL registerCollidePatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkcdPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
