// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace hkCompat
{
    extern void copyQsTransform(hkDataObject& obj, const char* oldName, const char* newName);
    extern void copyArrayOfQsTransforms(hkDataObject& obj, const char* oldName, const char* newName);
}

using namespace hkCompat;

static void hkbBehaviorReferenceGenerator_0_to_1( hkDataObject& obj )
{
    hkStringBuf behaviorFilenameNoExtension = obj["behaviorName"].asString();
    behaviorFilenameNoExtension.pathWithoutExtension();
    obj["behaviorName"] = behaviorFilenameNoExtension.cString();
}

static void hkbCharacterStringData_9_to_10( hkDataObject& obj )
{
    // The new format *only* specifies animation overrides in the character string data.
    hkDataArray nameData = obj["animationBundleNameData"].asArray();
    hkDataArray filenameData = obj["animationBundleFilenameData"].asArray();
    for ( int dataIt = nameData.getSize() - 1; dataIt >= 0; dataIt-- )
    {
        hkDataObject nameStringData = nameData[dataIt].asObject();

        hkBool32 removeAtDataIt = false;

        if ( nameStringData.isNull() )
        {
            HK_ASSERT( 0x22440734, false, "Corrupt character animation string data" );
            removeAtDataIt = true;
        }
        else
        {
            const hkBool32 isBundle = ( nameStringData["bundleName"].asString() != HK_NULL );

            hkDataObject filenameStringData;
            if ( dataIt < filenameData.getSize() )
            {
                filenameStringData = filenameData[dataIt].asObject();
            }

            // If we don't have *any* filename data or a non-bundle filename override during bundle loading, then cleanup everything.
            if ( filenameStringData.isNull() || ( isBundle && ( filenameStringData["bundleName"].asString() == HK_NULL ) ) )
            {
                removeAtDataIt = true;
            }
            // Otherwise, look for loose animation loading style.
            // If we had bundles, then they are necessarily part of the character definition.
            else if ( !isBundle )
            {
                // We are using the loose animation loading style, grab individual animation data
                hkDataArray assetNames = nameStringData["assetNames"].asArray();
                hkDataArray assetFilenames = filenameStringData["assetNames"].asArray();

                for ( int animIt = assetNames.getSize() - 1; animIt >= 0; animIt-- )
                {
                    const char* assetName = assetNames[dataIt].asString();

                    hkBool32 removeAtAnimIt = false;

                    if ( assetName == HK_NULL )
                    {
                        HK_ASSERT( 0x22440735, false, "Corrupt character animation string data" );
                        removeAtAnimIt = true;
                    }
                    else
                    {
                        const char* assetFilename = HK_NULL;
                        if ( animIt < assetFilenames.getSize() )
                        {
                            assetFilename = assetFilenames[dataIt].asString();
                        }

                        if ( assetFilename == HK_NULL )
                        {
                            removeAtAnimIt = true;
                        }
                    }

                    if ( removeAtAnimIt )
                    {
                        assetNames.removeAt( animIt );
                        if ( animIt < assetFilenames.getSize() )
                        {
                            assetFilenames.removeAt( animIt );
                        }
                    }
                }

                // No data left
                if ( assetNames.getSize() == 0 )
                {
                    removeAtDataIt = true;
                }
            }
        }

        if ( removeAtDataIt )
        {
            nameData.removeAt( dataIt );
            if ( dataIt < filenameData.getSize() )
            {
                filenameData.removeAt( dataIt );
            }
        }
    }
}

static void hkbClipGenerator_4_to_5( hkDataObject& obj )
{
    if ( const char* animationBundleName = obj["animationBundleName"].asString() )
    {
        hkStringBuf newAnimationName( obj["animationName"].asString() );
        hkStringBuf animationName( newAnimationName );
        newAnimationName.pathDirname();
        animationName.pathBasename();
        newAnimationName.appendJoin( animationBundleName, ":", animationName );

        obj["animationName"] = newAnimationName.cString();
    }
}

static void hkbCharacterData_10_to_11( hkDataObject& obj )
{
    hkDataObject mirroredSkeletonInfo = obj["mirroredSkeletonInfo"].asObject();
    hkDataObject footIkDriverInfo = obj["footIkDriverInfo"].asObject();
    hkDataObject handIkDriverInfo = obj["handIkDriverInfo"].asObject();
    hkDataObject aiControlDriverInfo = obj["aiControlDriverInfo"].asObject();

    int i = 1;
    hkDataArray propertySheets = obj["propertySheets"].asArray();
    if ( !mirroredSkeletonInfo.isNull() ) { propertySheets.setSize( i ); propertySheets[i - 1] = mirroredSkeletonInfo; i++; }
    if ( !footIkDriverInfo.isNull() ) { propertySheets.setSize( i ); propertySheets[i - 1] = footIkDriverInfo; i++; }
    if ( !handIkDriverInfo.isNull() ) { propertySheets.setSize( i ); propertySheets[i - 1] = handIkDriverInfo; i++; }
    if ( !aiControlDriverInfo.isNull() ) { propertySheets.setSize( i ); propertySheets[i - 1] = aiControlDriverInfo; i++; }
}

static void hkbLayer_1_to_2( hkDataObject& obj )
{
    hkDataObject blendingControlData = obj["blendingControlData"].asObject();
    blendingControlData["weight"] = obj["weight"].asReal();
    blendingControlData["fadeInDuration"] = obj["fadeInDuration"].asReal();
    blendingControlData["fadeOutDuration"] = obj["fadeOutDuration"].asReal();
    blendingControlData["onEventId"] = obj["onEventId"].asInt();
    blendingControlData["offEventId"] = obj["offEventId"].asInt();
    blendingControlData["onByDefault"] = obj["onByDefault"].asInt();
    blendingControlData["forceFullFadeDurations"] = obj["forceFullFadeDurations"].asInt();
}

static void hkbRigidBodySetup_0_to_1(hkDataObject& obj)
{

    // hkbRigidBodySetup used to house a single instance of hkbShapeSetup.
    //
    // It was replaced with an array of those in order to accommodate multiple
    // collision shape profiles.

    hkDataObject shapeSetupObj = obj["shapeSetup"].asObject();
    hkDataArray collisionShapeProfilesArr = obj["collisionShapeProfiles"].asArray();
    collisionShapeProfilesArr.setSize(1);
    collisionShapeProfilesArr[0] = shapeSetupObj;
}

void HK_CALL registerBehaviorPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkbPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
