// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace
{
    void copyQsTransformInternal( hkDataObject& dst, hkDataArray& src )
    {
        if (dst.getType().m_type->getSizeOf() == (src.m_elemType->getSizeOf() * src.m_size))
        {
            // We cheat a bit here but it's really just an array of floats
            hkString::memCpy(const_cast<void*>(dst.getImplementation()), src.m_data, dst.getType().m_type->getSizeOf());
        }
        else
        {
            {
                hkDataArray translation = dst["translation"].asArray();
                translation[0] = src[0];
                translation[1] = src[1];
                translation[2] = src[2];
                translation[3] = src[3];
            }
            {
                hkDataArray rotation = dst["rotation"].asArray();
                rotation[0] = src[4];
                rotation[1] = src[5];
                rotation[2] = src[6];
                rotation[3] = src[7];
            }
            {
                hkDataArray scale = dst["scale"].asArray();
                scale[0] = src[8];
                scale[1] = src[9];
                scale[2] = src[10];
                scale[3] = src[11];
            }
        }
    }

    void hkcdPlanarGeometryPrimitives_Plane_iEqn_0_to_1( hkDataObject& obj, const char* oldName, const char* newName )
    {
        hkDataArray srcArray = obj[oldName].asArray();
        hkDataArray dstArray = obj[newName].asObject()["vec"].asArray();
        dstArray[0] = srcArray[0];
        dstArray[1] = srcArray[1];
        dstArray[2] = srcArray[2];
        dstArray[3] = srcArray[3];
    }
}

namespace hkCompat
{
    void copyQsTransform(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataArray srcArray = obj[oldName].asArray();
        hkDataObject dstObject = obj[newName].asObject();
        copyQsTransformInternal(dstObject, srcArray);
    }

    void copyArrayOfQsTransforms(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataArray srcArray = obj[oldName].asArray();
        hkDataArray dstArray = obj[newName].asArray();

        const int size = srcArray.getSize();
        if (size)
        {
            dstArray.setSize(size);

            if (srcArray.m_elemType->getSizeOf() == dstArray.m_elemType->getSizeOf())
            {
                // We cheat a bit here but it's really just an array of floats
                hkString::memCpy(dstArray.m_data, srcArray.m_data, dstArray.m_stride * size);
            }
            else
            {
                for (int j = 0; j < size; j++)
                {
                    hkDataArray src = srcArray[j].asArray();
                    hkDataObject dst = dstArray[j].asObject();
                    copyQsTransformInternal(dst, src);
                }
            }
        }
    }

    void hkUint16_to_hkPackedVector3(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataArray aold = obj[oldName].asArray();
        hkDataArray anew = obj[newName].asObject()["values"].asArray();
        anew[0] = aold[0];
        anew[1] = aold[1];
        anew[2] = aold[2];
        anew[3] = aold[3];
    }

    void hkUint16_to_hkPackedVector3_Multiple(hkDataObject& obj, const char* oldName, const char* newName)
    {
        hkDataArray aold = obj[oldName].asArray();
        hkDataArray anew = obj[newName].asArray();
        for(int i = 0; i < anew.getSize(); ++i)
        {
            hkDataArray vnew = anew[i].asObject()["values"].asArray();
            vnew[0] = aold[i * 4 + 0];
            vnew[1] = aold[i * 4 + 1];
            vnew[2] = aold[i * 4 + 2];
            vnew[3] = aold[i * 4 + 3];
        }
    }
}

using namespace hkCompat;

void HK_CALL registerCommonPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hkPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
