// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : COMMON
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>


static void hclSimulateOperator_3_to_4(hkDataObject& simOpOptionsObj)
{
    // Add default sim-op config entry to hclSimulateOperator's m_simOpConfigs array
    hkDataArray simOpConfigsArray = simOpOptionsObj["simulateOpConfigs"].asArray();
    simOpConfigsArray.setSize(1);
    hkDataObject simOpConfigObj = simOpConfigsArray[0].asObject();

    // Copy over options from hclSimOperator
    simOpConfigObj["name"] = "Default Config";
    simOpConfigObj["subSteps"] = simOpOptionsObj["subSteps"];
    simOpConfigObj["numberOfSolveIterations"] = simOpOptionsObj["numberOfSolveIterations"];
    simOpConfigObj["constraintExecution"] = simOpOptionsObj["constraintExecution"];
    simOpConfigObj["adaptConstraintStiffness"] = simOpOptionsObj["adaptConstraintStiffness"];
    simOpConfigObj["useAllInstanceCollidables"] = true;
}

static void hclSimulateSetupObject_3_to_4(hkDataObject& simOpOptionsObj)
{
    // Add default sim-op config entry to hclSimulateOperator's m_simOpConfigs array
    hkDataArray simOpConfigsArray = simOpOptionsObj["simulateConfigs"].asArray();
    simOpConfigsArray.setSize(1);
    hkDataObject simOpConfigOptionsObj = simOpConfigsArray[0].asObject();

    // Copy over options from hclSimulateSetupObject
    simOpConfigOptionsObj["name"] = "Default Config";
    simOpConfigOptionsObj["numberOfSubsteps"] = simOpOptionsObj["numberOfSubsteps"];
    simOpConfigOptionsObj["numberOfSolveIterations"] = simOpOptionsObj["numberOfSolveIterations"];
    simOpConfigOptionsObj["constraintSetExecutionOrder"] = simOpOptionsObj["constraintSetExecutionOrder"];
    simOpConfigOptionsObj["explicitConstraintOrder"] = simOpOptionsObj["explicitConstraintOrder"];
    simOpConfigOptionsObj["adaptConstraintStiffness"] = simOpOptionsObj["adaptConstraintStiffness"];
    simOpConfigOptionsObj["useAllCollidables"] = true;
}

static void hclSimClothData_12_to_13(hkDataObject& simClothDataObj)
{
    hkDataObject simulationInfoObj = simClothDataObj["simulationInfo"].asObject();

    simClothDataObj["pinchDetectionEnabled"] = simulationInfoObj["pinchDetectionEnabled"];
    simClothDataObj["landscapeCollisionEnabled"] = simulationInfoObj["landscapeCollisionEnabled"];

    hkDataObject landscapeCollisionDataObj = simClothDataObj["landscapeCollisionData"].asObject();
    landscapeCollisionDataObj["collisionTolerance"] = simulationInfoObj["collisionTolerance"];
}

static void hclClothData_2_to_3(hkDataObject& clothDataObj)
{
    hkDataArray operatorsArray = clothDataObj["operators"].asArray();

    int numOps = operatorsArray.getSize();

    for( int opIdx = 0; opIdx < numOps; ++opIdx )
    {
        hkDataObject clothOperator = operatorsArray[opIdx].asObject();
        clothOperator["operatorID"] = opIdx;
    }
}

static void hclSimClothSetupObject_5_to_6(hkDataObject& simClothSetupObj)
{
    hkDataObject vcpSelection = simClothSetupObj["virtualCollisionPoints"].asObject();
    vcpSelection["type"] = 1; // Note that this relies on hclVertexSelectionInput::VERTEX_SELECTION_NONE being equal to 1!

    hkDataObject vcpLandscapeSelection = simClothSetupObj["landscapeVirtualCollisionPoints"].asObject();
    vcpLandscapeSelection["type"] = 1; // Note that this relies on hclVertexSelectionInput::VERTEX_SELECTION_NONE being equal to 1!
}

namespace hkCompat
{
    void hkUint16_to_hkPackedVector3_Multiple(hkDataObject& obj, const char* oldName, const char* newName);
}

// Registration function is at the end of the file

void HK_CALL registerClothPatches_2014_2_5(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2_5/hclPatches_2014_2_5.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
