// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>


static HK_INLINE int hknpBodyUid_to_hknpBodyId( hkDataObject::Value uid )
{
    // old hknpBodyUid = 64 bits: { int m_serial, int m_index };
    // new hknpBodyId = 32 bits: { int m_serial : 8, int m_index : 24 }
    const hkInt64 oldUid = uid.asInt64();
    return int( ((oldUid >> 8) & 0xff000000) | (oldUid & 0x00ffffff) );
}

static void hknpConstraint_1_to_2(hkDataObject& obj)
{
    HK_WARN_ONCE(0xbca59c15, "Versioning of hknpConstraint::m_bodyUid[A|B] is not yet implemented" );
}

static void hknpBody_2_to_3(hkDataObject& obj)
{
    //HK_WARN_ONCE(0x7c259ce5, "Patching of hknpBody::m_timAngle is not yet implemented" );
}

static void hknpConstraint_2_to_3(hkDataObject& obj)
{
    obj["bodyIdA"] = hknpBodyUid_to_hknpBodyId(obj["bodyUidA"]);
    obj["bodyIdB"] = hknpBodyUid_to_hknpBodyId(obj["bodyUidB"]);
}

static void hknpShape_2_to_3(hkDataObject& obj)
{
    // Remove the 2 PlayStation(R)3 flags (1<<9, 1<<10), and shift the proceeding ones down
    const int oldFlags = obj["flags"].asInt();
    const int mask = 0x1ff;
    obj["flags"] = (oldFlags & mask) | ((oldFlags>>2) & ~mask);
}

static void hknpConvexPolytopeShape_3_to_4(hkDataObject& obj)
{
    int numFaces = obj["faces"].asArray().getSize();
    for(int f = 0; f < numFaces; f++)
    {
        hkDataObject face = obj["faces"].asArray()[f].asObject();
        face["minHalfAngle"] = hkMath::clamp(face["minHalfAngle"].asInt(), 0, 0x7f);
    }
}

static void hknpHeightFieldShape_2_to_3(hkDataObject& obj)
{
    // Bump up the number of shape key bits (HNP-1187)
    obj["numShapeKeyBits"] = obj["numShapeKeyBits"].asInt() + 1;
}

void HK_CALL registerNewPhysicsPatches_2014_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2/hknpPatches_2014_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
