// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

static void hkndGeometryTriangle_0_to_1(hkDataObject& obj)
{
    const hkInt64 srcMtl    = obj["materialId"].asInt64();
    hkDataObject dstMtl     = obj["material"].asObject();
    dstMtl["val"] = srcMtl;
}

static void hkndGeometry_1_to_2(hkDataObject& obj)
{
    // Add a LOD
    hkDataArray lods = obj["lods"].asArray();
    lods.setSize(1);
    hkDataObject lod = lods[0].asObject();

    // Copy vertices
{
        hkDataArray srcVerts    = obj["vertices"].asArray();
        hkDataArray dstVerts    = lod["vertices"].asArray();
        const int numVerts      = srcVerts.getSize();
        dstVerts.setSize(numVerts);

        for (int vi = numVerts - 1; vi >= 0; vi--)
        {
            const hkVector4f vtx = srcVerts[vi].asVector4f();
            dstVerts[vi] = vtx;
        }
    }

    // Copy triangles
    {
        hkDataArray srcTris = obj["triangles"].asArray();
        hkDataArray dstTris = lod["triangles"].asArray();
        const int numTris   = srcTris.getSize();
        dstTris.setSize(numTris);

        for (int ti = numTris - 1; ti >= 0; ti--)
    {
            hkDataObject srcTri = srcTris[ti].asObject();
            hkDataObject dstTri = dstTris[ti].asObject();

            const int idxA = srcTri["a"].asInt();   dstTri["a"] = idxA;
            const int idxB = srcTri["b"].asInt();   dstTri["b"] = idxB;
            const int idxC = srcTri["c"].asInt();   dstTri["c"] = idxC;

            hkDataObject srcMtl = srcTri["material"].asObject();
            hkDataObject dstMtl = dstTri["material"].asObject();
            const hkInt64 mtl   = srcMtl["val"].asInt64();
            dstMtl["val"]       = mtl;
        }
    }
}

static void hkndFracturePiece_1_to_2(hkDataObject& obj)
{
    const int DF_PHYSICS_OPERAND    = 402;
    const int DF_GRAPHICS_OPERAND   = 403;

    // Find the class
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass ndCsgClass      (world->findClass("hkndPlanarCsgOperand"));

    // See if we have any operands to upgrade
    hkDataObject props      = obj["properties"].asObject();
    hkDataArray propEntries = props["entries"].asArray();

    for (int ei = propEntries.getSize() - 1; ei >= 0; ei--)
    {
        hkDataObject propEntry  = propEntries[ei].asObject();
        const int propKey       = propEntry["key"].asInt();

        if ( (propKey == DF_PHYSICS_OPERAND) || (propKey == DF_GRAPHICS_OPERAND) )
        {
            // We need to create a new object and add this as its LOD
            hkDataObject srcOperand = propEntry["object"].asObject();
            hkDataObject dstOperand = world->newObject(ndCsgClass);
            hkDataArray dstLods     = dstOperand["lods"].asArray();

            dstLods.setSize(1);
            dstLods[0] = srcOperand;
            propEntry["object"] = dstOperand;
        }
        }
    }

static void copyDecalMaps(hkDataArray& dst, hkDataArray& src, const hkDataWorld* world)
    {
    // Find the class & allocate output
    hkDataClass ndClass (world->findClass("hkndDecalMapActionDecalMap"));
    const int numDecals = src.getSize();
    dst.setSize(numDecals);

    for (int k = numDecals - 1; k >= 0; k--)
        {
        hkDataObject srcObj = src[k].asObject();
        hkDataObject dstObj = world->newObject(ndClass);
        dst[k] = dstObj;

        // Copy object data
        const int texW      = srcObj["textureW"].asInt();   dstObj["textureW"]  = texW;
        const int texH      = srcObj["textureH"].asInt();   dstObj["textureH"]  = texH;
        const int uvIdx     = srcObj["uvChannel"].asInt();  dstObj["uvChannel"] = uvIdx;
        const int leafId    = srcObj["leafId"].asInt();     dstObj["leafId"]    = leafId;
        const int type      = srcObj["type"].asInt();       dstObj["type"]      = type;

        hkDataArray srcBytes    = srcObj["data"].asArray();
        hkDataArray dstBytes    = dstObj["data"].asArray();
        const int numBytes      = srcBytes.getSize();
        dstBytes.setSize(numBytes);

        for (int bi = numBytes - 1; bi >= 0; bi--)
        {
            dstBytes[bi] = srcBytes[bi].asInt();
        }
        }
    }

static void hkndDecalMapActionDecalMapData_1_to_2(hkDataObject& obj)
{
    // Get the world
    const hkDataWorld* world = obj.getClass().getWorld();

    // Get the arrays
    hkDataArray dstDecals = obj["refDecals"].asArray();
    hkDataArray dstDecors = obj["refDecors"].asArray();
    hkDataArray srcDecals = obj["decals"].asArray();
    hkDataArray srcDecors = obj["decors"].asArray();

    copyDecalMaps(dstDecals, srcDecals, world);
    copyDecalMaps(dstDecors, srcDecors, world);
}

void HK_CALL registerNewDestructionPatches_2014_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2/hkndPatches_2014_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
