// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkndIntegrationUtilBoneInfo_0_to_1(hkDataObject& obj)
{
    const int oldBoneId     = obj["nextBoneId"].asInt();
    hkDataObject newBoneId  = obj["newNextBoneId"].asObject();
    newBoneId["meshIndex"]      = 0;
    newBoneId["instanceIndex"]  = 0;
    newBoneId["boneIndex"]      = oldBoneId;
}

static void hkndIntegrationUtilMeshInfo_0_to_1(hkDataObject& obj)
{
    // Add a mesh
    hkDataArray meshes = obj["meshes"].asArray();
    meshes.setSize(1);

    // Copy the bone infos
    hkDataObject newMesh    = meshes[0].asObject();
    hkDataArray oldBones    = obj["boneInfos"].asArray();
    hkDataArray newBones    = newMesh["boneInfos"].asArray();
    const int numBones      = oldBones.getSize();
    newMesh["numBones"]     = numBones;
    newBones.setSize(numBones);

    for (int k = numBones - 1; k >= 0; k--)
    {
        hkDataObject oldBone    = oldBones[k].asObject();
        hkDataObject newBone    = newBones[k].asObject();
        const int pieceId       = oldBone["pieceId"].asInt();           newBone["pieceId"]      = pieceId;
        const int bodyId        = oldBone["assetBodyId"].asInt();       newBone["assetBodyId"]  = bodyId;

        hkDataObject oldBoneId  = oldBone["nextBoneId"].asObject();
        hkDataObject newBoneId  = newBone["nextBoneId"].asObject();
        const int meshIdx       = oldBoneId["meshIndex"].asInt();       newBoneId["meshIndex"]      = meshIdx;
        const int instanceIdx   = oldBoneId["instanceIndex"].asInt();   newBoneId["instanceIndex"]  = instanceIdx;
        const int boneIdx       = oldBoneId["boneIndex"].asInt();       newBoneId["boneIndex"]      = boneIdx;
    }
}

void HK_CALL registerNdIntegrationPatches_2014_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_2/hkndIntegrationPatches_2014_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
