// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace Enums
{
    // Copy of hknpBody::SpuFlags from 2014.1
    struct Body_SpuFlags_Old
    {
        enum
        {
            FORCE_NARROW_PHASE_PPU  = 1<<0,
        };
    };

    // Copy of hknpCollisionFlags from 2014.2
    struct CollisionFlags_New
    {
        enum
        {
            FORCE_NARROW_PHASE_PPU  = 1<<28,
        };
    };

    // Copy of hknpMotionPropertiesId from 2014.2
    enum
    {
        MOTION_PROPERTIES_ID_INVALID = 0xFFFF,
    };
}

namespace
{
    // Copy of hknpBodyUid from 2014.2
    struct hknpBodyUid_New
    {
        // Note: sizeof(hknpBodyId) == sizeof(hkUint32) in 2014.2
#if HK_ENDIAN_BIG   // PPC, ARM
        hkUint32 m_id;
        hkUint32 m_serial;
#else               // INTEL
        hkUint32 m_serial;
        hkUint32 m_id;
#endif
    };

} // anonymous namespace.

static void hknpCharacterRigidBodyCinfo_2_to_3(hkDataObject& obj)
{
    obj["activationMode"] = obj["additionFlags"].asInt();
}

static void hknpBody_1_to_2(hkDataObject& obj)
{
    int spuFlags = obj["spuFlags"].asInt();
    if( spuFlags & Enums::Body_SpuFlags_Old::FORCE_NARROW_PHASE_PPU )
    {
        int flags = obj["flags"].asInt();
        obj["flags"] = flags | Enums::CollisionFlags_New::FORCE_NARROW_PHASE_PPU;
    }
}

static void hknpBodyCinfo_2_to_3(hkDataObject& obj)
{
    int spuFlags = obj["spuFlags"].asInt();
    if( spuFlags & Enums::Body_SpuFlags_Old::FORCE_NARROW_PHASE_PPU )
    {
        int flags = obj["flags"].asInt();
        obj["flags"] = flags | Enums::CollisionFlags_New::FORCE_NARROW_PHASE_PPU;
    }
}

static void hknpBodyCinfo_3_to_4(hkDataObject& obj)
{
    obj["motionPropertiesId"] = Enums::MOTION_PROPERTIES_ID_INVALID;
}

static void hknpConstraint_0_to_1(hkDataObject& obj)
{
    const int initialSerialNo = 1; // This is the value of the initial serial number in 2014.2
    const int bodyIdA = obj["bodyIdA_old"].asInt();
    const int bodyIdB = obj["bodyIdB_old"].asInt();

    hknpBodyUid_New bodyUidA;
    bodyUidA.m_serial = initialSerialNo;
    bodyUidA.m_id = bodyIdA;

    hknpBodyUid_New bodyUidB;
    bodyUidB.m_serial = initialSerialNo;
    bodyUidB.m_id = bodyIdB;

    HK_COMPILE_TIME_ASSERT( sizeof(hknpBodyUid_New) == sizeof(hkInt64) );
    obj["bodyUidA"] = *(hkInt64*)&bodyUidA;
    obj["bodyUidb"] = *(hkInt64*)&bodyUidB;
}

static void hknpConvexPolytopeShape_2_to_3(hkDataObject& obj)
{
    // Remove the padding planes, which are no longer necessary.
    int numFaces = obj["faces"].asArray().getSize();
    obj["planes"].asArray().setSize(numFaces);
}

void HK_CALL registerNewPhysicsPatches_2014_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_1/hknpPatches_2014_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
