// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>


static void hkndGeometry_0_to_1(hkDataObject& obj)
{
    // Build a map from old mat to new material
    hkDataArray triSources  = obj["triSources"].asArray();
    hkDataObject lastTriSourceObj = triSources[triSources.getSize() - 1].asObject();
    const hkUint32 matIdMax = lastTriSourceObj["startMaterialId"].asInt() + lastTriSourceObj["numMaterials"].asInt();

    // Create the mapping table
    hkArray<hkInt64> oldMatIdToNewMatId;
    {
        oldMatIdToNewMatId.setSize(matIdMax);
        hkUint32 oldMatId = 0;
        for (int source = 0 ; source < triSources.getSize() ; source++)
        {
            const hkUint32 numSourceMats = triSources[source].asObject()["numMaterials"].asInt();
            hkUint64 newMatBase = (hkUint64(source) << 32);
            for (hkUint32 localId = 0 ; localId < numSourceMats ; localId++, oldMatId++)
            {
                oldMatIdToNewMatId[oldMatId] = newMatBase | hkUint64(localId);
            }
        }
    }

    // Apply remap
    hkDataArray tris = obj["triangles"].asArray();
    for (int t = 0 ; t < tris.getSize() ; t++)
    {
        const hkUint32 oldMatId = tris[t].asObject()["materialId"].asInt();
        const hkInt64 newMatId  = ( oldMatId > 0x0FFFFFFF ) ? 0x00ffffff00000000LL : oldMatIdToNewMatId[oldMatId];
        tris[t].asObject()["materialId"] = newMatId;
    }
}

static void hkndDestructionSystemData_2_to_3(hkDataObject& obj)
{
    // Create the triangle source
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass triSrcLibClass(world->findClass("hkndTriangleSourceManger"));
    hkDataObject triSrcLib      = world->newObject(triSrcLibClass);

    // Set it in as the system's material library
    obj["triSourceManager"] = triSrcLib;
}

static void upgradeId_16bit_to_32bit(hkDataObject& obj, const char* memberName)
{
    const int oldId = obj[memberName].asInt();
    const int newId = (oldId == 0xFFFF) ? -1 : oldId;
    obj[memberName] = newId;
}

static void hkndDynamicFractureContext_1_to_2(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "bodyId");
}

static void hkndDynamicFractureContextDataBlock_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "worldBrokenBodyId");
}

static void hkndInfoDataBlock_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "bodyId");
}

static void hkndCutOutFracture_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "cutoutShapesProviderId");
}

static void hkndDecalMapAction_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "decorationBodyId");
}

static void hkndDestructionSystemDataBodyClone_1_to_2(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "breakableBodyId");
}

static void hkndControllerProcessorDataBlock_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "bodyId");
}

static void hkndDecorateFractureFaceAction_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "controlShapesProviderId");
}

static void hkndActionDataBlock_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "bodyId");
}

static void hkndVoronoiFracture_0_to_1(hkDataObject& obj)
{
    upgradeId_16bit_to_32bit(obj, "voronoiSitesProviderId");
}

// Registration function is at the end of the file

void HK_CALL registerNewDestructionPatches_2014_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_1/hkndPatches_2014_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
