// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>

// Registration function is at the end of the file

static void hkaiDefaultAstarEdgeFilter_2_to_3( hkDataObject& obj )
{
    hkLocalArray<hkUint32> allEnabled(32);
    allEnabled.setSizeUnchecked(32, 0xffffffffu);
    obj["faceMaskLookupTable"].asArray().setAll(allEnabled.begin(), 32);
}

static void hkaiCharacter_29_to_30(hkDataObject& obj)
{
    // Need to set default value here, instead of in reflection data,
    // otherwise spurious mismatch will be flagged by patch verification
    obj["currentNavVolumeCell"] = hkInt64(-1);
}

static void hkaiNavMeshCutterMeshInfo_0_to_1(hkDataObject& obj)
{
    obj["faceMapping"] = obj["magic"];
}

void HK_CALL registerAiPatches_2014_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2014_1/hkaiPatches_2014_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
