// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hknpScaledConvexShapeBase_1_to_2(hkDataObject& obj)
{
    obj["coreShape"] = obj["childShape"];
    obj["coreShapeSize"] = obj["childShapeSize"];
}

static void hknpGroupCollisionFilter_0_to_1(hkDataObject& obj)
{
    hkDataArray crtVals = obj["collisionLookupTable"].asArray();
    hkDataArray newVals = obj["newCollisionLookupTable"].asArray();

    for (int k = crtVals.getSize() - 1; k >= 0; k--)
    {
        // Signed / unsigned problems here
        const hkUint32 crtVal = crtVals[k].asInteger<hkUint32>();
        hkInt32 newVal;
        if (crtVal > 0x80000000)
        {
            newVal = hkInt32(crtVal & 0x7fffffff) - 0x80000000;
        }
        else
        {
            newVal = hkInt32(crtVal & 0x7fffffff);
        }
        newVals[k] = newVal;
    }
}

static void hknpCharacterRigidBodyCinfo_1_to_2(hkDataObject& obj)
{
    int additionFlagsVersion1 = obj["old_additionFlags"].asInt();
    // Do not add the body. Overrides all other flags.
    if (additionFlagsVersion1 & 1) // additionFlagsVersion1 & DO_NOT_ADD_BODY.
    {
        obj["additionMode"] = 0;
    }
    else
    {
        bool undefinedAdditionFlags = true;
        // Add the body immediately instead of waiting until the next step.
        if (additionFlagsVersion1 & 2) // additionFlagsVersion1 & ADD_BODY_NOW.
        {
            undefinedAdditionFlags = false;
            obj["additionMode"] = 1;
        }
        // Add the body as inactive, if possible.
        if (additionFlagsVersion1 & 4) // additionFlagsVersion1 & START_DEACTIVATED
        {
            undefinedAdditionFlags = false;
            obj["additionFlags"] = 1;
        }
        // The default behavior is to add bodies as active at the start of the next step.
        if (undefinedAdditionFlags)
        {
            obj["additionMode"] = 2;    // add in next step.
            obj["additionFlags"] = 0;   // add as active.
        }
    }
}

static void hknpGroupCollisionFilter_1_to_2(hkDataObject& obj)
{
    obj["nextFreeSystemGroup"] = obj["old_nextFreeSystemGroup"].asInt();

    hkDataArray crtVals = obj["old_collisionLookupTable"].asArray();
    hkDataArray newVals = obj["collisionLookupTable"].asArray();

    const int crtSize = crtVals.getSize();
    const int newSize = newVals.getSize();
    const int minSize = (crtSize < newSize) ? crtSize : newSize;
    for (int k = minSize - 1; k >= 0; k--)
    {
        const int crtVal = crtVals[k].asInt();
        newVals[k] = crtVal;
    }
}

static void hknpTriangleShape_0_to_1(hkDataObject& obj)
{
    // m_indices was initialized wrongly pre-2013.3, with 4 elements instead of 8
    hkDataArray indices = obj["indices"].asArray();
    if( indices.getSize() < 8 )
    {
        indices.setSize(8);
        indices[0] = 0;
        indices[1] = 1;
        indices[2] = 2;
        indices[3] = 3;
        indices[4] = 2;
        indices[5] = 1;
        indices[6] = 0;
        indices[7] = 3;
    }
}

void HK_CALL registerNewPhysicsPatches_2013_3(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_3/hknpPatches_2013_3.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
