// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

extern void upgradeReflectedQTransform(hkDataObject& obj, const char* newMemberName, const char* oldMemberName);
extern void upgradeReflectedQTransformArray(hkDataObject& obj, const char* newMemberName, const char* oldMemberName);

namespace hkd_2013_3
{
    enum hkdAction_FilterPipelinePriority
    {
        PRIORITY_DEFAULT                    = 100,
        PRIORITY_REMOVE_WEAK_CONNECTIONS    =  60,
        PRIORITY_FLATTEN_HIERARCHY          =  55,
        PRIORITY_GLUE_FIXED_PIECES          =  50, // BETA
        PRIORITY_MESH_SIMPLIFIER            =  30,
        PRIORITY_SHARE_VERTICES             =  20,
        PRIORITY_CONVEX_DECOMPOSITION       =  10,
        PRIORITY_SPLITBYPHYSICSISLANDS      =   8,
        PRIORITY_CONVEX_HULL                =   7,
        PRIORITY_CREATE_DECAL_MAP           =   6,
        PRIORITY_DECORATE_FRACTURE_FACE     =   5,
    };
}

static void hkdRemoveWeakConnectionsAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_REMOVE_WEAK_CONNECTIONS;
}

static void hkdConvexDecompositionAction_3_to_4(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_CONVEX_DECOMPOSITION;
}

static void hkdSplitByPhysicsIslandsAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_SPLITBYPHYSICSISLANDS;
}

static void hkdGlueFixedPiecesAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_GLUE_FIXED_PIECES;
}

static void hkdDecorateFractureFaceAction_8_to_9(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_DECORATE_FRACTURE_FACE;
}

static void hkdMeshSimplifierAction_6_to_7(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_MESH_SIMPLIFIER;
}

static void hkdFlattenHierarchyAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_FLATTEN_HIERARCHY;
}

static void hkdDecalMapAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_CREATE_DECAL_MAP;
}

static void hkdShareVerticesAction_0_to_1(hkDataObject& obj)
{
    obj["priority"] = hkd_2013_3::PRIORITY_SHARE_VERTICES;
}

static void hkdDecorateFractureFaceActionGlobalDecorationData_3_to_4(hkDataObject& obj)
{
    hkDataArray src = obj["rawTransformsOld"].asArray();
    hkDataArray dst = obj["rawTransforms"].asArray();
    const int size  = src.getSize();

    dst.setSize(size);
    for (int k = size - 1; k >= 0; k--)
    {
        const float f   = float(src[k].asReal());
        const unsigned int i    = *reinterpret_cast<const unsigned int*>(&f);

        dst[k] = i;
    }
}

static void hkdDeformableBreakableShapeBoneInfo_1_to_2(hkDataObject& obj)
{
    upgradeReflectedQTransform(obj, "modelSpaceBindPoseTransform", "modelSpaceBindPoseTransformOld");
}

static void hkdShapeInstanceInfo_4_to_5(hkDataObject& obj)
{
    upgradeReflectedQTransform(obj, "transform", "transformOld");
}

static void hkdDeformableBreakableShapePhysicsSkinInstance_2_to_3(hkDataObject& obj)
{
    upgradeReflectedQTransformArray(obj, "modelSpaceBoneTransforms", "modelSpaceBoneTransformsOld");
}

static void hkdDeformableBreakableBodyMemento_1_to_2(hkDataObject& obj)
{
    upgradeReflectedQTransformArray(obj, "transforms", "transformsOld");
}

void HK_CALL registerDestructionPatches_2013_3(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_3/hkdPatches_2013_3.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
