// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

extern void upgradeReflectedQTransform(hkDataObject& obj, const char* newMemberName, const char* oldMemberName);
extern void upgradeReflectedQTransformArray(hkDataObject& obj, const char* newMemberName, const char* oldMemberName);

static void convertUp(hkDataObject& obj)
{

    //
    // hkPackedUnitVector::unpack, as of 2013.3
    //

//  hkIntVector zero; zero.setZero();
//  hkIntVector iv16; iv16.loadNotAligned<(NUM_ELEMS+1)/2>((const hkUint32*)m_vec);
//  hkIntVector iv32; iv32.setCombineHead16To32( iv16, zero );
//  hkIntVector packedOffset; packedOffset.load<4>(hkPackedUnitVector_m_offset);
//  iv32.setAddU32( iv32, packedOffset);
//  hkVector4f v; iv32.convertS32ToF32( v );
//  vecOut->setMul( hkVector4f::getConstant<HK_QUADREAL_UNPACK16_UNIT_VEC>(), v );

    hkVector4f vUp; vUp.setZero();

    hkDataArray packed = obj["upOld"].asArray();
    for (int i=0; i<3; ++i)
    {
        hkUint32 packedComponent = ((hkUint32) packed[i].asInt()) << 16;
        hkUint32 offset = 0x80000000;
        packedComponent += offset;
        hkFloat32 floatVal = hkFloat32((hkInt32)packedComponent);

        // from hkMath.cpp
#define P16 30000.0
#define P31 (P16 * 0x10000)
        floatVal *= (1.0f / P31); // HK_QUADREAL_UNPACK16_UNIT_VEC

        vUp(i) = floatVal;
    }

    obj["up"] = vUp;
}

static void hkaiNavVolumePathSearchParameters_5_to_6( hkDataObject& obj )
{
    convertUp( obj );
}

static void hkaiNavMeshPathSearchParameters_10_to_11( hkDataObject& obj )
{
    convertUp( obj );
}

static void convertVolumesToCarvers( hkDataObject& obj )
{
    // Convert each hkaiVolume in the old array to an hkaiCarver for the new array.
    const hkDataWorld* world    = obj.getClass().getWorld();
    hkDataClass carverClass     (world->findClass("hkaiCarver"));

    hkDataArray volumes = obj["carversOld"].asArray();
    hkDataArray carvers = obj["carvers"].asArray();

    const int numCarvers = volumes.getSize();
    carvers.setSize( numCarvers );

    // Pseudo-code
    //  foreach volume in volumeArray
    //      carver = new hkaiCarver(volume)
    //      carverArray[i] = carver

    for (int i=0; i<numCarvers; i++)
    {
        hkDataObject volume = volumes[i].asObject();
        hkDataObject carver = world->newObject(carverClass);
        carver["volume"] = volume;
        carvers[i] = carver;
    }
}

static void hkaiNavMeshSimplificationSnapshot_0_to_1( hkDataObject& obj )
{
    convertVolumesToCarvers(obj);
}

static void hkaiNavMeshGenerationSettings_26_to_27( hkDataObject& obj )
{
    convertVolumesToCarvers(obj);
}

static void hkaiNavVolumeGenerationSettings_10_to_11( hkDataObject& obj )
{
    convertVolumesToCarvers(obj);
}

static void hkaiSilhouetteGenerator_2_to_3( hkDataObject& obj )
{
    // "User" type enum got moved from 3 to 5.
    const int oldUserEnum = 3;
    const int newUserEnum = 5;
    const int oldObjType = obj["type"].asInt();
    if( oldObjType == oldUserEnum )
    {
        obj["type"] = newUserEnum;
    }
}

static void hkaiSilhouetteGenerator_3_to_4(hkDataObject& obj)
{
    upgradeReflectedQTransform(obj, "transform", "transformOld");
}

static void hkaiConvexSilhouetteSet_1_to_2(hkDataObject& obj)
{
    upgradeReflectedQTransform(obj, "cachedTransform", "cachedTransformOld");
}

static void hkaiSilhouetteGeneratorSectionContext_0_to_1(hkDataObject& obj)
{
    upgradeReflectedQTransform(obj, "lastRelativeTransform", "lastRelativeTransformOld");
}

void HK_CALL registerAiPatches_2013_3(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_3/hkaiPatches_2013_3.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
