// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

void upgradeReflectedQTransformArray(hkDataObject& obj, const char* newMemberName, const char* oldMemberName)
{
    hkDataArray src = obj[oldMemberName].asArray();
    hkDataArray dst = obj[newMemberName].asArray();
    const int n     = src.getSize();

    dst.setSize(n);
    for (int k = n - 1; k >= 0; k--)
    {
        hkDataObject sq = src[k].asObject();
        hkDataObject dq = dst[k].asObject();

        dq["translation"]   = sq["translation"].asVector4();
        dq["rotation"]      = sq["rotation"].asVector4();
    }
}

void upgradeReflectedQTransform(hkDataObject& obj, const char* newMemberName, const char* oldMemberName)
{
    hkDataObject sq = obj[oldMemberName].asObject();
    hkDataObject dq = obj[newMemberName].asObject();

    dq["translation"]   = sq["translation"].asVector4();
    dq["rotation"]      = sq["rotation"].asVector4();
}

static void hkxVertexBufferVertexData_1_to_2(hkDataObject& obj)
{
    {
        hkDataArray src = obj["floatDataOld"].asArray();
        hkDataArray dst = obj["floatData"].asArray();
        const int size  = src.getSize();

        dst.setSize(size);
        for (int k = size - 1; k >= 0; k--)
        {
            const float f   = float(src[k].asReal());
            const hkUint32 i        = *reinterpret_cast<const hkUint32*>(&f);
            dst[k] = i;
        }
    }

    {
        hkDataArray src = obj["vectorDataOld"].asArray();
        hkDataArray dst = obj["vectorData"].asArray();
        const int size  = src.getSize();

        dst.setSize(size);
        for (int k = size - 1; k >= 0; k--)
        {
            const float f   = float(src[k].asReal());
            const hkUint32 i = *reinterpret_cast<const hkUint32*>(&f);
            dst[k] = i;
        }
    }
}

void HK_CALL registerCommonPatches_2013_3(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_3/hkPatches_2013_3.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
