// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>


static hkDataObject newObject(const hkDataWorld* world, const char* className)
{
    hkDataClass dataClass = world->findClass(className);
    HK_ASSERT_NO_MSG(0x112dbb3b, !dataClass.isNull());
    return world->newObject(dataClass);
}

static void copyObjectMembers(hkDataObject srcObj, hkDataObject dstObj)
{
    const hkDataClass objectClass = srcObj.getClass();
    hkArray<hkDataClass::MemberInfo> memberInfos;
    objectClass.getAllMemberInfos(memberInfos);

    for (int i = 0; i < memberInfos.getSize(); i++)
    {
        const char* memberName = memberInfos[i].m_name;
        dstObj[memberName] = srcObj[memberName];
    }
}

static void hknpCompressedMeshShape_3_to_4(hkDataObject& obj)
{
    const hkDataWorld* world = obj.getClass().getWorld();

    // Change embedded mesh tree to ptr to wrapped mesh tree
    {
        obj["data"] = newObject(world, "hknpCompressedMeshShapeData");
        hkDataObject oldMeshTree = obj["data_old"].asObject();
        hkDataObject newMeshTree = obj["data"].asObject()["meshTree"].asObject();
        copyObjectMembers( oldMeshTree, newMeshTree );
    }

    // Change ptr to optional extended data to ptr to wrapped simd tree
    if( obj["extendedData_old"].isSet() && !obj["extendedData_old"].asObject().isNull() )
    {
        hkDataObject oldSimdTree = obj["extendedData_old"].asObject();
        hkDataObject newSimdTree = obj["data"].asObject()["simdTree"].asObject();
        copyObjectMembers( oldSimdTree, newSimdTree );
    }
}

static void hknpStaticCompoundShape_0_to_1(hkDataObject& obj)
{
    const hkDataWorld* world = obj.getClass().getWorld();

    // Change embedded tree to ptr to wrapped tree
    {
        obj["boundingVolumeData"] = newObject(world, "hknpStaticCompoundShapeData");
        hkDataObject oldAabbTree = obj["tree"].asObject();
        hkDataObject newAabbTree = obj["boundingVolumeData"].asObject()["aabbTree"].asObject();
        copyObjectMembers( oldAabbTree, newAabbTree );
    }
}

static void hknpDynamicCompoundShape_0_to_1(hkDataObject& obj)
{
    const hkDataWorld* world = obj.getClass().getWorld();

    // Change embedded tree to ptr to wrapped tree
    {
        obj["boundingVolumeData"] = newObject(world, "hknpDynamicCompoundShapeData");
        hkDataObject oldAabbTree = obj["tree"].asObject();
        hkDataObject newAabbTree = obj["boundingVolumeData"].asObject()["aabbTree"].asObject();
        copyObjectMembers( oldAabbTree, newAabbTree );
    }
}

static void hknpMaterial_0_to_1(hkDataObject& obj)
{
    // Added m_triggerType::TRIGGER_TYPE_BROAD_PHASE
    int triggerType = obj["triggerType"].asInt();
    if( triggerType > 0 )
    {
        obj["triggerType"] = triggerType + 1;
    }
}

static void hknpShape_1_to_2(hkDataObject& obj)
{
    // Added m_dispatchType::NONE
    int dispatchType = obj["dispatchType"].asInt();
    obj["dispatchType"] = dispatchType + 1;
}

static void hknpShapeInstance_0_to_1(hkDataObject& obj)
{
    hkDataArray oldPadding = obj["padding"].asArray();
    hkDataArray newPadding = obj["paddingNew"].asArray();
    const int numOld    = oldPadding.getSize();
    const int numNew    = newPadding.getSize();
    const int numShared = hkMath::min2(numOld, numNew);

    for (int k = 0; k < numShared; k++)
    {
        newPadding[k] = oldPadding[k].asInt();
    }
}

void HK_CALL registerNewPhysicsPatches_2013_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_2/hknpPatches_2013_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
