// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Types/Uuid/hkUuid.h>
#include <Common/Base/Math/Vector/hkPackedVector3.h>

// Registration function is at the end of the file

static void hkndConnection_0_to_1(hkDataObject& obj)
{
    // Initialize the packed vector 3 with the input values
    hkDataArray oldInertiaValues = obj["inertia"].asArray();
    hkPackedVector3 v3;
    for (int i = 0 ; i < 4 ; i++)
    {
        v3.m_values[i] = hkUint16(oldInertiaValues[i].asInt());
    }

    // Unpack it
    hkVector4f unpackedV;
    v3.unpack(unpackedV);

    // Store the result, real values
    obj["inertiaXx"]    = unpackedV.getComponent<0>().getReal();
    obj["inertiaYy"]    = unpackedV.getComponent<1>().getReal();

    // Init new fields
    obj["userData"]     = 0;
}

static void hkndFracturePiece_0_to_1(hkDataObject& obj)
{
    // Get child
    const int childId = obj["firstChildId"].asInt();
    int lodMask = 0;
    if ( childId == 0xFFFF )
    {
        // This is a leaf node, enable all lods!
        lodMask = 0xFF;
    }
    obj["lodMask"] = lodMask;
}

static void hkndHierarchy_0_to_1(hkDataObject& obj)
{
    obj["numLods"] = 1;
}

namespace NewDestruction_2013_2_Enums
{
    enum hkndProperties
    {
        DECORATION_DATA         = 104,
        DYNAMIC_FRACTURE        = 200,
        DEBRIS_FRACTURE_INFO    = 201,
    };
}

extern void HK_CALL assignUuid_2013_2(hkDataObject& uuidObj, const hkUuid& uuidVal);
extern void HK_CALL extractUuid_2013_2(hkUuid& dstUuidVal, hkDataObject& srcUuidObj);

static void HK_CALL convertBodyReferenceToUuid(hkDataArray& bodyCinfos, hkDataObject& dstObj, const char* bodyIdMemberName, const char* uuidMemberName)
{
    const int refBodyId = dstObj[bodyIdMemberName].asInt();

    if ( (refBodyId >= 0) && (refBodyId < bodyCinfos.getSize()) )
    {
        hkDataObject refBody = bodyCinfos[refBodyId].asObject();
        hkDataObject srcUuid = refBody["uuid"].asObject();
        hkDataObject dstUuid = dstObj[uuidMemberName].asObject();

        // Copy Uuids
        hkDataArray srcNodes = srcUuid["data"].asArray();
        hkDataArray dstNodes = dstUuid["data"].asArray();
        for (int k = srcNodes.getSize() - 1; k >= 0; k--)
        {
            dstNodes[k] = srcNodes[k].asInteger<hkUint32>();
        }
    }
}

static hkResult HK_CALL findBodyUuid(hkDataArray& bodyCinfos, hkDataObject& soughtHierarchy, hkUuid& dstUuid)
{
    const int numBodies = bodyCinfos.getSize();
    for (int bi = 0; bi < numBodies; bi++)
    {
        // Get body and its hierarchy instance
        hkDataObject cInfo  = bodyCinfos[bi].asObject();
        hkDataObject hInst  = cInfo["hInstance"].asObject();
        if ( hInst.isNull() )
        {
            continue;
        }

        // Get hierarchy
        hkDataObject hierarchy = hInst["hierarchy"].asObject();
        if ( hierarchy == soughtHierarchy )
        {
            // Found hierarchy, return body UUID!
            hkDataObject srcUuid = cInfo["uuid"].asObject();
            extractUuid_2013_2(dstUuid, srcUuid);
            return HK_SUCCESS;
        }
    }

    // Did not find it!
    return HK_FAILURE;
}

static void HK_CALL upgradeGlobalDecorationData(hkDataObject& globalData, hkDataArray& bodyCinfos)
{
    hkDataArray decoTemplates   = globalData["templates"].asArray();
    const int numDecoTemplates  = decoTemplates.getSize();

    hkArray<hkUuid> uniqueUuids;

    // Locate the provider UUID for each decoration template
    for (int di = 0; di < numDecoTemplates; di++)
    {
        hkDataObject decoTemplate   = decoTemplates[di].asObject();         // hkndDecorateFractureFaceRuntime::DecorationId
        hkDataObject decoHierarchy  = decoTemplate["hierarchy"].asObject(); // hkndHierarchy

        // Locate the UUID of the deco hierarchy
        hkUuid uuid = hkUuid::getNil();
        findBodyUuid(bodyCinfos, decoHierarchy, uuid);

        // Add provider
        int providerIdx = uniqueUuids.indexOf(uuid);
        if ( providerIdx < 0 )
        {
            providerIdx = uniqueUuids.getSize();
            uniqueUuids.pushBack(uuid);
        }

        // Store provider Id in the decoration template
        decoTemplate["providerId"] = providerIdx;
    }

    // Store all uuids
    const int numUuids  = uniqueUuids.getSize();
    hkDataArray uuids   = globalData["providerUuids"].asArray();
    uuids.setSize(numUuids);

    for (int i = 0; i < numUuids; i++)
    {
        hkDataObject uuid = uuids[i].asObject();
        assignUuid_2013_2(uuid, uniqueUuids[i]);
    }
}

static void hkndDestructionSystemData_0_to_1(hkDataObject& obj)
{
    // Upgrade to hkndMaterialLibrary
    {
        // Create a material library
        const hkDataWorld* world    = obj.getClass().getWorld();
        hkDataClass mtlLibClass     (world->findClass("hkndMaterialLibrary"));
        hkDataObject mtlLib         = world->newObject(mtlLibClass);

        // Get the materials in the newly created lib
        hkDataObject dstStorage = mtlLib["materials"].asObject();
        hkDataArray dstMtls     = dstStorage["elements"].asArray();
        dstStorage["firstFree"] = -1;

        // Populate the material library with all materials in the source list
        const hkDataArray srcMtls = obj["materials"].asArray();
        const int numMtls = srcMtls.getSize();
        dstMtls.setSize(numMtls);
        for (int mi = 0; mi < numMtls; mi++)
        {
            // COM-4154
            //dstMtls[mi].asObject()["pod"] = srcMtls[mi].asObject();
            dstMtls[mi].asObject()["density"] = srcMtls[mi].asObject()["density"];
            dstMtls[mi].asObject()["destructionRadius"] = srcMtls[mi].asObject()["destructionRadius"];
            dstMtls[mi].asObject()["breakingStrength"] = srcMtls[mi].asObject()["breakingStrength"];
            dstMtls[mi].asObject()["yieldStrength"] = srcMtls[mi].asObject()["yieldStrength"];
            dstMtls[mi].asObject()["flags"] = srcMtls[mi].asObject()["flags"];
            dstMtls[mi].asObject()["userData"] = srcMtls[mi].asObject()["userData"];
        }

        // Set the material library on each hierarchy in the system
        hkDataArray bodyCinfos = obj["bodyCinfos"].asArray();
        const int numBodies = bodyCinfos.getSize();
        for (int bi = 0; bi < numBodies; bi++)
        {
            hkDataObject cInfo  = bodyCinfos[bi].asObject();
            hkDataObject hInst  = cInfo["hInstance"].asObject();
            if ( !hInst.isNull() )
            {
                hkDataObject fCol   = hInst["hierarchy"].asObject();
                fCol["mtlLibrary"]  = mtlLib;
            }
        }

        // Set it in as the system's material library
        obj["mtlLibrary"] = mtlLib;
    }

    // Upgrade hkndDebrisFracture and hkndDecorateFractureFaceRuntime references to hkUuids
    {
        // Search for hkndDebrisFractures
        hkDataArray bodyCinfos  = obj["bodyCinfos"].asArray();
        const int numBodies     = bodyCinfos.getSize();
        for (int bi = 0; bi < numBodies; bi++)
        {
            // Get body and its hierarchy instance
            hkDataObject cInfo  = bodyCinfos[bi].asObject();
            hkDataObject hInst  = cInfo["hInstance"].asObject();
            if ( hInst.isNull() )
            {
                continue;
            }

            // Get hierarchy
            hkDataObject hierarchy      = hInst["hierarchy"].asObject();
            hkDataArray fracturePieces  = hierarchy["fracturePieces"].asArray();
            const int numFracturePieces = fracturePieces.getSize();
            bool foundGlobalDecoData    = false;

            // Iterate over all fracture pieces
            for (int pieceIdx = 0; pieceIdx < numFracturePieces; pieceIdx++)
            {
                // Get piece and its properties
                hkDataObject piece      = fracturePieces[pieceIdx].asObject();
                hkDataObject propsObj   = piece["properties"].asObject();
                hkDataArray propsArray  = propsObj["entries"].asArray();
                const int numProps      = propsArray.getSize();

                // Iterave over all properties and search for dynamic fractures
                for (int propIdx = 0; propIdx < numProps; propIdx++)
                {
                    hkDataObject propEntry  = propsArray[propIdx].asObject();
                    const int propId        = propEntry["key"].asInt();

                    // Upgrade hkndDebrisFracture references
                    if ( propId == NewDestruction_2013_2_Enums::DYNAMIC_FRACTURE )
                    {
                        // We found a dynamic fracture
                        hkDataObject dynFractureCtx = propEntry["object"].asObject();
                        hkDataObject dynFracture    = dynFractureCtx["fracture"].asObject();

                        // Upgrade the hkndDebrisFracture::m_debrisTemplateProviderId
                        convertBodyReferenceToUuid(bodyCinfos, dynFracture, "debrisTemplateProviderId", "debrisTemplateUuid");

                        // Upgrade the hkndDebrisFracture::m_controlShapesProviderId
                        convertBodyReferenceToUuid(bodyCinfos, dynFracture, "controlShapesProviderId", "controlShapesUuid");
                    }

                    // Upgrade hkndDecorateFractureFaceRuntime::ShapeDecorationInfo references
                    if ( !foundGlobalDecoData && (propId == NewDestruction_2013_2_Enums::DECORATION_DATA) )
                    {
                        // Get its global data
                        foundGlobalDecoData = true;
                        hkDataObject decoInfo   = propEntry["object"].asObject();       // hkndDecorateFractureFaceRuntime::ShapeDecorationInfo
                        hkDataObject decoData   = decoInfo["sharedData"].asObject();    // hkndDecorateFractureFaceRuntime::GlobalDecorationData

                        upgradeGlobalDecorationData(decoData, bodyCinfos);
                    }

                    // Upgrade hkndDebrisFractureInfo references
                    if ( propId == NewDestruction_2013_2_Enums::DEBRIS_FRACTURE_INFO )
                    {
                        // We found a hkndDebrisFractureInfo
                        hkDataObject debrisInfos    = propEntry["object"].asObject();
                        hkDataObject dInfo0         = debrisInfos["info0"].asObject();
                        hkDataObject dInfo1         = debrisInfos["info1"].asObject();
                        hkDataObject dInfo2         = debrisInfos["info2"].asObject();

                        convertBodyReferenceToUuid(bodyCinfos, dInfo0, "debrisTemplateProviderId", "debrisTemplateUuid");
                        convertBodyReferenceToUuid(bodyCinfos, dInfo1, "debrisTemplateProviderId", "debrisTemplateUuid");
                        convertBodyReferenceToUuid(bodyCinfos, dInfo2, "debrisTemplateProviderId", "debrisTemplateUuid");
                    }
                }
            }
        }
    }
}

static void hkndBodyCinfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["uuid"].asObject();
    hkUuid uuidVal;         uuidVal.setRandom();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkndDebrisFractureInfoTemplateInfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["debrisTemplateUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkndDebrisFracture_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObjA   = obj["debrisTemplateUuid"].asObject();
    hkDataObject uuidObjB   = obj["controlShapesUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObjA, uuidVal);
    assignUuid_2013_2(uuidObjB, uuidVal);
}

static void hkndDecorateFractureFaceActionCornerDecorationInfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["decorationsUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkndDecorateFractureFaceActionFractureFaceInfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["decorationsUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkndGeometryTriangleSource_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["uuid"].asObject();
    hkUuid uuidVal;         uuidVal.setRandom();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkndFracturePiece_1_to_2(hkDataObject& obj)
{
    const int mtlId = obj["materialId"].asInt();

    // Propagate sign bit
    obj["materialId"] = hkUint32((mtlId << 16) >> 16);
}

void HK_CALL registerNewDestructionPatches_2013_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_2/hkndPatches_2013_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
