// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Types/Uuid/hkUuid.h>

// Registration function is at the end of the file

static void hkdShape_4_to_5(hkDataObject& obj)
{
    obj["yieldStrength"] = obj["strength"];
}

extern void HK_CALL assignUuid_2013_2(hkDataObject& uuidObj, const hkUuid& uuidVal);

static void hkdBody_4_to_5(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["uuid"].asObject();
    hkUuid uuidVal;         uuidVal.setRandom();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkdDebrisFractureInfoTemplateInfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["templateDebrisUuid"].asObject();
    const hkUuid& uuidVal   = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkdDebrisFracture_3_to_4(hkDataObject& obj)
{
    hkDataObject uuidObjA   = obj["templateDebrisUuid"].asObject();
    hkDataObject uuidObjB   = obj["controlShapesUuid"].asObject();
    const hkUuid& uuidVal   = hkUuid::getNil();

    assignUuid_2013_2(uuidObjA, uuidVal);
    assignUuid_2013_2(uuidObjB, uuidVal);
}

static void hkdDecorateFractureFaceActionCornerDecorationInfo_0_to_1(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["decorationsUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}

static void hkdDecorateFractureFaceActionFractureFaceInfo_3_to_4(hkDataObject& obj)
{
    hkDataObject uuidObj    = obj["decorationsUuid"].asObject();
    hkUuid uuidVal          = hkUuid::getNil();

    assignUuid_2013_2(uuidObj, uuidVal);
}


void HK_CALL registerDestructionPatches_2013_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_2/hkdPatches_2013_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
