// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>


// Registration function is at the end of the file
static void hkbCharacter_3_to_4(hkDataObject& obj)
{
    // Set these to be invalid, we will set them in the finishing constructor to standard capabilities
    obj["capabilities"] = -1;
    obj["effectiveCapabilities"] = -1;
}

static void hkbStateMachine_4_to_5(hkDataObject& obj)
{
    if ( obj["startStateChooser"].isSet() )
    {
        // Get deprecated chooser object
        hkDataObject oldStartStateChooser = obj["startStateChooser"].asObject();

        if ( !oldStartStateChooser.isNull() )
        {
            // Create a wrapper
            const hkDataWorld* world = obj.getClass().getWorld();
            hkDataClass wrapperDataClass( world->findClass( "hkbStateChooserWrapper" ) );
            hkDataObject newChooserWrapper = world->newObject( wrapperDataClass );
            newChooserWrapper["wrappedChooser"] = oldStartStateChooser;

            // Assign the wrapper to our selector
            obj["startStateIdSelector"] = newChooserWrapper;
        }
    }
}


void HK_CALL registerBehaviorPatches_2013_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_2/hkbPatches_2013_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
