// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Types/Uuid/hkUuid.h>


void HK_CALL assignUuid_2013_2(hkDataObject& uuidObj, const hkUuid& srcUuid)
{
    // Copy the Uuid members
    hkDataArray dstData = uuidObj["data"].asArray();

    dstData[0] = (unsigned int)srcUuid.getData<0>();
    dstData[1] = (unsigned int)srcUuid.getData<1>();
    dstData[2] = (unsigned int)srcUuid.getData<2>();
    dstData[3] = (unsigned int)srcUuid.getData<3>();
}

void HK_CALL extractUuid_2013_2(hkUuid& dstUuid, hkDataObject& srcUuidObj)
{
    // Copy the Uuid members
    hkDataArray srcData = srcUuidObj["data"].asArray();

    // Copy Uuids
    dstUuid.setData<0>(srcData[0].asInteger<hkUint32>());
    dstUuid.setData<1>(srcData[1].asInteger<hkUint32>());
    dstUuid.setData<2>(srcData[2].asInteger<hkUint32>());
    dstUuid.setData<3>(srcData[3].asInteger<hkUint32>());
}

static void HK_CALL hkAabbHalf_0_to_1(hkDataObject& obj)
{
    const hkDataArray& oldData = obj["data_old"].asArray();
    const hkDataArray& oldExtra = obj["extras"].asArray();
    hkDataArray newData = obj["data"].asArray();
    newData.setSize(8);

    for (int i=0; i<6; ++i) newData[i] = oldData[i].asInt();
    newData[6] = oldExtra[0].asInt();
    newData[7] = oldExtra[1].asInt();
}

static void HK_CALL hkUuid_0_to_1(hkDataObject& obj)
{
}


void HK_CALL registerCommonPatches_2013_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_2/hkPatches_2013_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
