// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace
{
    void upgradeBitField_2013_1(hkDataObject& dstBitField, hkDataObject& srcBitField)
    {
        // Copy number of bits
        hkDataObject dstStorage = dstBitField["storage"].asObject();
        const int numBits       = srcBitField["numBits"].asInt();
        dstStorage["numBits"]   = numBits;

        // Copy bits array
        hkDataArray srcBits = srcBitField["words"].asArray();
        hkDataArray dstBits = dstStorage["words"].asArray();
        const int size      = srcBits.getSize();
        dstBits.setSize(size);

        for (int k = size - 1; k >= 0; k--)
        {
            dstBits[k] = srcBits[k].asInt();
        }
    }
}

static void hkndBreakableBodySnapshot_0_to_1(hkDataObject& obj)
{
    {
        hkDataObject srcBitField = obj["old_enabledPieces"].asObject();
        hkDataObject dstBitField = obj["enabledPieces"].asObject();
        upgradeBitField_2013_1(dstBitField, srcBitField);
    }
    {
        hkDataObject srcBitField = obj["old_enabledConnections"].asObject();
        hkDataObject dstBitField = obj["enabledConnections"].asObject();
        upgradeBitField_2013_1(dstBitField, srcBitField);
    }
}


void HK_CALL registerNewDestructionPatches_2013_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_1/hkndPatches_2013_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
