// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>


static void setBufferSizes(hkDataObject& bufferSizes, int openSetSize, int searchStateSize)
{
    bufferSizes["maxOpenSetSizeBytes"] = openSetSize;
    bufferSizes["maxSearchStateSizeBytes"] = searchStateSize;
}

static void hkaiNavMeshPathSearchParameters_9_to_10(hkDataObject& obj)
{
    int maxOpenSetSizeBytes = obj["maxOpenSetSizeBytes"].asInt();
    int maxSearchStateSizeBytes = obj["maxSearchStateSizeBytes"].asInt();
    hkDataObject bufferSizes = obj["bufferSizes"].asObject();
    setBufferSizes(bufferSizes, maxOpenSetSizeBytes, maxSearchStateSizeBytes);

    int maxHierarchyOpenSetSizeBytes = obj["maxHierarchyOpenSetSizeBytes"].asInt();
    int maxHierarchySearchStateSizeBytes = obj["maxHierarchySearchStateSizeBytes"].asInt();
    hkDataObject hierarchyBufferSizes = obj["hierarchyBufferSizes"].asObject();
    setBufferSizes(hierarchyBufferSizes, maxHierarchyOpenSetSizeBytes, maxHierarchySearchStateSizeBytes);
}

static void hkaiNavVolumePathSearchParameters_3_to_4(hkDataObject& obj)
{
    int maxOpenSetSizeBytes = obj["maxOpenSetSizeBytes"].asInt();
    int maxSearchStateSizeBytes = obj["maxSearchStateSizeBytes"].asInt();
    hkDataObject bufferSizes = obj["bufferSizes"].asObject();
    setBufferSizes(bufferSizes, maxOpenSetSizeBytes, maxSearchStateSizeBytes);
}

static void hkaiGraphPathSearchParameters_1_to_2(hkDataObject& obj)
{
    int maxOpenSetSizeBytes = obj["maxOpenSetSizeBytes"].asInt();
    int maxSearchStateSizeBytes = obj["maxSearchStateSizeBytes"].asInt();
    hkDataObject bufferSizes = obj["bufferSizes"].asObject();
    setBufferSizes(bufferSizes, maxOpenSetSizeBytes, maxSearchStateSizeBytes);
}
static void hkaiStreamingSetGraphConnection_2_to_3(hkDataObject& obj)
{
    obj["edgeCost"] = -1.0f;
}


void HK_CALL registerAiPatches_2013_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2013_1/hkaiPatches_2013_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
