// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkpDeformableLinConstraintAtom_0_to_1(hkDataObject& obj)
{
    hkSymmetricMatrix3 yieldStrength = obj["yieldStrength"].asSymmetricMatrix3();
    obj["yieldStrengthDiag"].setVec(&yieldStrength.m_diag(0), 4);
    obj["yieldStrengthOffDiag"].setVec(&yieldStrength.m_offDiag(0), 4);

    hkSymmetricMatrix3 ultimateStrength = obj["ultimateStrength"].asSymmetricMatrix3();
    obj["ultimateStrengthDiag"].setVec(&ultimateStrength.m_diag(0), 4);
    obj["ultimateStrengthOffDiag"].setVec(&ultimateStrength.m_offDiag(0), 4);
}

static void hkpDeformableAngConstraintAtom_0_to_1(hkDataObject& obj)
{
    hkSymmetricMatrix3 yieldStrength = obj["yieldStrength"].asSymmetricMatrix3();
    obj["yieldStrengthDiag"].setVec(&yieldStrength.m_diag(0), 4);
    obj["yieldStrengthOffDiag"].setVec(&yieldStrength.m_offDiag(0), 4);

    hkSymmetricMatrix3 ultimateStrength = obj["ultimateStrength"].asSymmetricMatrix3();
    obj["ultimateStrengthDiag"].setVec(&ultimateStrength.m_diag(0), 4);
    obj["ultimateStrengthOffDiag"].setVec(&ultimateStrength.m_offDiag(0), 4);
}

static void hkpConvexVerticesShape_4_to_5(hkDataObject& obj)
{
    hkDataArray src = obj["rotatedVertices_old"].asArray(); // array of hkFourTransposedPoints
    hkDataArray dst = obj["rotatedVertices"].asArray();     // array of 12*float

    const int size = src.getSize();
    dst.setSize(12*size);
    for (int i = 0; i < size; i++)
    {
        hkDataObject src_obj = src[i].asObject(); // one hkFourTransposedPoints
        hkDataArray src_i = src_obj["vertices"].asArray();

        {
            const hkVector4f vec = src_i[0].asVector4f();
            dst[i*12  ] = float(vec(0));
            dst[i*12+1] = float(vec(1));
            dst[i*12+2] = float(vec(2));
            dst[i*12+3] = float(vec(3));
        }
        {
            const hkVector4f vec = src_i[1].asVector4f();
            dst[i*12+4] = float(vec(0));
            dst[i*12+5] = float(vec(1));
            dst[i*12+6] = float(vec(2));
            dst[i*12+7] = float(vec(3));
        }
        {
            const hkVector4f vec = src_i[2].asVector4f();
            dst[i*12+8] = float(vec(0));
            dst[i*12+9] = float(vec(1));
            dst[i*12+10] = float(vec(2));
            dst[i*12+11] = float(vec(3));
        }
    }
}

static void hkpConvexVerticesShape_5_to_6(hkDataObject& obj)
{
    hkDataArray src = obj["rotatedVertices_old"].asArray(); // array of 12*float
    hkDataArray dst = obj["rotatedVertices"].asArray();     // array of hkMatrix3

    const int size = src.getSize()/12;
    dst.setSize(size);
    for (int i = 0; i < size; i++)
    {
        hkMatrix3f dst_obj;
        hkVector4f vec;
        {
            vec.set(src[i*12+0].asReal(), src[i*12+1].asReal(), src[i*12+2].asReal(), src[i*12+3].asReal());
            dst_obj.setColumn<0>(vec);
        }
        {
            vec.set(src[i*12+4].asReal(), src[i*12+5].asReal(), src[i*12+6].asReal(), src[i*12+7].asReal());
            dst_obj.setColumn<1>(vec);
        }
        {
            vec.set(src[i*12+8].asReal(), src[i*12+9].asReal(), src[i*12+10].asReal(), src[i*12+11].asReal());
            dst_obj.setColumn<2>(vec);
        }
        dst[i] = dst_obj; // one hkMatrix3
    }
}


void HK_CALL registerPhysicsPatches_2012_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2012_2/hkpPatches_2012_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
