// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// (New) Physics specific product patches.
// This file is #included by hknpPatches.cpp

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRagdollKeyFrameHierarchyUtilityControlData", 0)
        HK_PATCH_MEMBER_ADDED_REAL("hierarchyGain", 0.170000f)
        HK_PATCH_MEMBER_ADDED_REAL("velocityDamping", 0.000000f)
        HK_PATCH_MEMBER_ADDED_REAL("accelerationGain", 1.000000f)
        HK_PATCH_MEMBER_ADDED_REAL("velocityGain", 0.600000f)
        HK_PATCH_MEMBER_ADDED_REAL("positionGain", 0.050000f)
        HK_PATCH_MEMBER_ADDED_REAL("positionMaxLinearVelocity", 1.400000f)
        HK_PATCH_MEMBER_ADDED_REAL("positionMaxAngularVelocity", 1.800000f)
        HK_PATCH_MEMBER_ADDED_REAL("snapGain", 0.100000f)
        HK_PATCH_MEMBER_ADDED_REAL("snapMaxLinearVelocity", 0.300000f)
        HK_PATCH_MEMBER_ADDED_REAL("snapMaxAngularVelocity", 0.300000f)
        HK_PATCH_MEMBER_ADDED_REAL("snapMaxLinearDistance", 0.030000f)
        HK_PATCH_MEMBER_ADDED_REAL("snapMaxAngularDistance", 0.100000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRagdollData", 0)
        HK_PATCH_PARENT_SET(HK_NULL, "hknpPhysicsSystemData")
        HK_PATCH_MEMBER_ADDED("skeleton", TYPE_OBJECT, "hkaSkeleton", 0)
        HK_PATCH_MEMBER_ADDED("boneToBodyMap", TYPE_ARRAY_INT, HK_NULL, 0)
        HK_PATCH_DEPENDS("hkBaseObject", 0)
        HK_PATCH_DEPENDS("hknpPhysicsSystemData", 0)
        HK_PATCH_DEPENDS("hkReferencedObject", 0)
        HK_PATCH_DEPENDS("hkaSkeleton", 5)
HK_PATCH_END()

//----------------------------------------------------------------------------------------------------------------------
// If using Physics and not Physics 2012, we need initial patches for the shared classes which would otherwise
// have full patch history provided by Physics 2012. Destruction needs all physics patches, so no need to re-register
// them if Destruction is defined.
//----------------------------------------------------------------------------------------------------------------------

#if !defined(HK_FEATURE_PRODUCT_PHYSICS_2012)

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkp2dAngConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("freeRotationAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpVehicleFrictionStatus", 0)
    HK_PATCH_MEMBER_ADDED("axis", TYPE_TUPLE_STRUCT, "hkpVehicleFrictionStatusAxisStatus", 2)
    HK_PATCH_DEPENDS("hkpVehicleFrictionStatusAxisStatus", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpHingeConstraintDataAtoms", 1)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("2dAng", TYPE_STRUCT, "hkp2dAngConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ballSocket", TYPE_STRUCT, "hkpBallSocketConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpBallSocketConstraintAtom", 5)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPointToPlaneConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin", TYPE_STRUCT, "hkpLinConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpBridgeConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("constraintData", TYPE_OBJECT, "hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpHingeConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpHingeConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpHingeConstraintDataAtoms", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPointToPlaneConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpPointToPlaneConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpPointToPlaneConstraintDataAtoms", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpStiffSpringConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpStiffSpringConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpStiffSpringConstraintDataAtoms", 1)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED_INT("userData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("transformA", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("transformB", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPulleyConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("translations", TYPE_STRUCT, "hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("pulley", TYPE_STRUCT, "hkpPulleyConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpPulleyConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpAngMotorConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motorAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("targetAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motor", TYPE_OBJECT, "hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRotationalConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpRotationalConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpRotationalConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPulleyConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpPulleyConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpPulleyConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpBallSocketConstraintAtom", 5)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED_BYTE("solvingMethod", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("bodiesToNotify", 0)
    HK_PATCH_MEMBER_ADDED("velocityStabilizationFactor", TYPE_STRUCT, "hkUFloat8", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("enableLinearImpulseLimit", 0)
    HK_PATCH_MEMBER_ADDED_REAL("breachImpulse", 340282001837565600000000000000000000000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("inertiaStabilizationFactor", 0.000000f)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkUFloat8", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRagdollLimitsDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("rotations", TYPE_STRUCT, "hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("twistLimit", TYPE_STRUCT, "hkpTwistLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("coneLimit", TYPE_STRUCT, "hkpConeLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("planesLimit", TYPE_STRUCT, "hkpConeLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConeLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpTwistLimitConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpDeformableFixedConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpDeformableFixedConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpDeformableFixedConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpBallAndSocketConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpBallAndSocketConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpBallAndSocketConstraintDataAtoms", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("rotationA", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rotationB", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpAngConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("firstConstrainedAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numConstrainedAxes", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("translationA", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("translationB", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpBridgeAtoms", 0)
    HK_PATCH_MEMBER_ADDED("bridgeAtom", TYPE_STRUCT, "hkpBridgeConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpBridgeConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpSpringDamperConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpLimitedForceConstraintMotor")
    HK_PATCH_MEMBER_ADDED("springConstant", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("springDamping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpLimitedForceConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpHingeLimitsDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("rotations", TYPE_STRUCT, "hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("angLimit", TYPE_STRUCT, "hkpAngLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("2dAng", TYPE_STRUCT, "hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalRotationsConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRackAndPinionConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("rackAndPinion", TYPE_STRUCT, "hkpRackAndPinionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpRackAndPinionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpAngLimitConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("limitAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("angularLimitsTauFactor", 1.000000f)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLimitedHingeConstraintDataAtoms", 1)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("angMotor", TYPE_STRUCT, "hkpAngMotorConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("angFriction", TYPE_STRUCT, "hkpAngFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("angLimit", TYPE_STRUCT, "hkpAngLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("2dAng", TYPE_STRUCT, "hkp2dAngConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ballSocket", TYPE_STRUCT, "hkpBallSocketConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkpAngFrictionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngMotorConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpBallSocketConstraintAtom", 5)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpVehicleFrictionStatusAxisStatus", 0)
    HK_PATCH_MEMBER_ADDED("forward_slip_velocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("side_slip_velocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("skid_energy_density", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("side_force", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("delayed_forward_impulse", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sideRhs", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("forwardRhs", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("relativeSideForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("relativeForwardForce", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("axisIndex", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinearParametricCurve", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpParametricCurve")
    HK_PATCH_MEMBER_ADDED("smoothingFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("closedLoop", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dirNotParallelToTangentAlongWholePath", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("points", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("distance", TYPE_ARRAY_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpParametricCurve", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRackAndPinionConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("pinionRadiusOrScrewPitch", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isScrew", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToInitialAngleOffset", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToPrevAngle", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToRevolutionCounter", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpAngFrictionConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstFrictionAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numFrictionAxes", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxFrictionTorque", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPositionConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpLimitedForceConstraintMotor")
    HK_PATCH_MEMBER_ADDED("tau", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("damping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("proportionalRecoveryVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("constantRecoveryVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpLimitedForceConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpParametricCurve", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpDeformableFixedConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin", TYPE_STRUCT, "hkpDeformableLinConstraintAtom", 1)
    HK_PATCH_MEMBER_ADDED("ang", TYPE_STRUCT, "hkpDeformableAngConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkpDeformableLinConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpDeformableAngConstraintAtom", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkp3dAngConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRagdollMotorConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("target_bRca", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motors", TYPE_TUPLE_OBJECT, "hkpConstraintMotor", 3)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpStiffSpringConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("length", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxLength", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpCogWheelConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpCogWheelConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpCogWheelConstraintDataAtoms", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpStiffSpringConstraintDataAtoms", 1)
    HK_PATCH_MEMBER_ADDED("pivots", TYPE_STRUCT, "hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("spring", TYPE_STRUCT, "hkpStiffSpringConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpStiffSpringConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinSoftConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("axisIndex", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("tau", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("damping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPulleyConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("fixedPivotAinWorld", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("fixedPivotBinWorld", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ropeLength", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("leverageOnBodyB", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpWheelConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpWheelConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("initialAxleInB", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("initialSteeringAxisInB", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpWheelConstraintDataAtoms", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinMotorConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motorAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("targetPosition", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motor", TYPE_OBJECT, "hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpOverwritePivotConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("copyToPivotBFromPivotA", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPrismaticConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("motor", TYPE_STRUCT, "hkpLinMotorConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("friction", TYPE_STRUCT, "hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ang", TYPE_STRUCT, "hkpAngConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin0", TYPE_STRUCT, "hkpLinConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin1", TYPE_STRUCT, "hkpLinConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("linLimit", TYPE_STRUCT, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinMotorConstraintAtom", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRotationalConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("rotations", TYPE_STRUCT, "hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ang", TYPE_STRUCT, "hkpAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalRotationsConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpFixedConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpFixedConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpFixedConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpConeLimitConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("twistAxisInA", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("refAxisInB", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("angleMeasurementMode", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("memOffsetToAngleOffset", 1)
    HK_PATCH_MEMBER_ADDED("minAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("angularLimitsTauFactor", 1.000000f)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLimitedForceConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintMotor")
    HK_PATCH_MEMBER_ADDED("minForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLimitedHingeConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpLimitedHingeConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpLimitedHingeConstraintDataAtoms", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPointToPathConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpBridgeAtoms", 0)
    HK_PATCH_MEMBER_ADDED("path", TYPE_OBJECT, "hkpParametricCurve", 0)
    HK_PATCH_MEMBER_ADDED("maxFrictionForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("angularConstrainedDOF", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("transform_OS_KS", TYPE_TUPLE_VEC_16, HK_NULL, 2)
    HK_PATCH_DEPENDS("hkpParametricCurve", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpBridgeAtoms", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpSetupStabilizationAtom", 2)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED_BYTE("enabled", 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxLinImpulse", 340282001837565600000000000000000000000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxAngImpulse", 340282001837565600000000000000000000000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxAngle", 18446726481523507000.000000f)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpCallbackConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpLimitedForceConstraintMotor")
    HK_PATCH_MEMBER_ADDED("callbackType", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("userData0", 0)
    HK_PATCH_MEMBER_ADDED_INT("userData1", 0)
    HK_PATCH_MEMBER_ADDED_INT("userData2", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpLimitedForceConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("frictionAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxFrictionForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpFixedConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("ballSocket", TYPE_STRUCT, "hkpBallSocketConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ang", TYPE_STRUCT, "hkp3dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkp3dAngConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpBallSocketConstraintAtom", 5)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("axisIndex", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("min", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("max", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRagdollLimitsData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpRagdollLimitsDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpRagdollLimitsDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpDeformableAngConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED_VEC_4("offset", 0.000000f,0.000000f,0.000000f,1.000000f)
    HK_PATCH_MEMBER_ADDED("yieldStrengthDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("yieldStrengthOffDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ultimateStrengthDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ultimateStrengthOffDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpBallAndSocketConstraintDataAtoms", 1)
    HK_PATCH_MEMBER_ADDED("pivots", TYPE_STRUCT, "hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("ballSocket", TYPE_STRUCT, "hkpBallSocketConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkpSetLocalTranslationsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpBallSocketConstraintAtom", 5)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpVelocityConstraintMotor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpLimitedForceConstraintMotor")
    HK_PATCH_MEMBER_ADDED("tau", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("velocityTarget", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("useVelocityTargetFromConstraintTargets", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpLimitedForceConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkpConstraintMotor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpVehicleFrictionDescription", 0)
    HK_PATCH_MEMBER_ADDED("wheelDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisMassInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("axleDescr", TYPE_TUPLE_STRUCT, "hkpVehicleFrictionDescriptionAxisDescription", 2)
    HK_PATCH_DEPENDS("hkpVehicleFrictionDescriptionAxisDescription", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpPrismaticConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpPrismaticConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpPrismaticConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpCogWheelConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("cogWheels", TYPE_STRUCT, "hkpCogWheelConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpCogWheelConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpVehicleFrictionDescriptionAxisDescription", 0)
    HK_PATCH_MEMBER_ADDED("frictionCircleYtab", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("xStep", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("xStart", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelSurfaceInertia", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelSurfaceInertiaInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelChassisMassRatio", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelRadiusInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelDownForceFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelDownForceSumFactor", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRagdollConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpRagdollConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpRagdollConstraintDataAtoms", 1)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRagdollConstraintDataAtoms", 1)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("setupStabilization", TYPE_STRUCT, "hkpSetupStabilizationAtom", 0)
    HK_PATCH_MEMBER_ADDED("ragdollMotors", TYPE_STRUCT, "hkpRagdollMotorConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("angFriction", TYPE_STRUCT, "hkpAngFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("twistLimit", TYPE_STRUCT, "hkpTwistLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("coneLimit", TYPE_STRUCT, "hkpConeLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("planesLimit", TYPE_STRUCT, "hkpConeLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ballSocket", TYPE_STRUCT, "hkpBallSocketConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetupStabilizationAtom", 2)
    HK_PATCH_DEPENDS("hkpAngFrictionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConeLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpRagdollMotorConstraintAtom", 1)
    HK_PATCH_DEPENDS("hkpBallSocketConstraintAtom", 5)
    HK_PATCH_DEPENDS("hkpTwistLimitConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpTwistLimitConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("isEnabled", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("twistAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("refAxis", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("angularLimitsTauFactor", 1.000000f)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpCogWheelConstraintAtom", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED("cogWheelRadiusA", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("cogWheelRadiusB", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isScrew", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToInitialAngleOffset", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToPrevAngle", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("memOffsetToRevolutionCounter", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpDeformableLinConstraintAtom", 1)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintAtom")
    HK_PATCH_MEMBER_ADDED_VEC_4("offset", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED("yieldStrengthDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("yieldStrengthOffDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ultimateStrengthDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ultimateStrengthOffDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpHingeLimitsData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpHingeLimitsDataAtoms", 0)
    HK_PATCH_DEPENDS("hkpHingeLimitsDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRackAndPinionConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpRackAndPinionConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkpRackAndPinionConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpWheelConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("suspensionBase", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin0Limit", TYPE_STRUCT, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin0Soft", TYPE_STRUCT, "hkpLinSoftConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin1", TYPE_STRUCT, "hkpLinConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("lin2", TYPE_STRUCT, "hkpLinConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("steeringBase", TYPE_STRUCT, "hkpSetLocalRotationsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("2dAng", TYPE_STRUCT, "hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkp2dAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinSoftConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalRotationsConstraintAtom", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinearClearanceConstraintData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkpConstraintData")
    HK_PATCH_MEMBER_ADDED("atoms", TYPE_STRUCT, "hkpLinearClearanceConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkpLinearClearanceConstraintDataAtoms", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpLinearClearanceConstraintDataAtoms", 0)
    HK_PATCH_MEMBER_ADDED("transforms", TYPE_STRUCT, "hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("motor", TYPE_STRUCT, "hkpLinMotorConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("friction0", TYPE_STRUCT, "hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("friction1", TYPE_STRUCT, "hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("friction2", TYPE_STRUCT, "hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("ang", TYPE_STRUCT, "hkpAngConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("linLimit0", TYPE_STRUCT, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("linLimit1", TYPE_STRUCT, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_MEMBER_ADDED("linLimit2", TYPE_STRUCT, "hkpLinLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinLimitConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpSetLocalTransformsConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinFrictionConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpAngConstraintAtom", 0)
    HK_PATCH_DEPENDS("hkpLinMotorConstraintAtom", 1)
HK_PATCH_END()

#endif  // !HK_FEATURE_PRODUCT_PHYSICS_2012


//----------------------------------------------------------------------------------------------------------------------
// Below are the Physics only classes.
//----------------------------------------------------------------------------------------------------------------------

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleVelocityDamper", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCapsuleShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpConvexPolytopeShape")
    HK_PATCH_MEMBER_ADDED("a", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("b", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpConvexShape", 0)
    HK_PATCH_DEPENDS("hknpConvexPolytopeShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleFrictionStatusAxisStatus", 0)
    HK_PATCH_MEMBER_ADDED("forward_slip_velocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("side_slip_velocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("skid_energy_density", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("side_force", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("delayed_forward_impulse", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sideRhs", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("forwardRhs", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("relativeSideForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("relativeForwardForce", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultBrakeWheelBrakingProperties", 0)
    HK_PATCH_MEMBER_ADDED("maxBreakingTorque", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minPedalInputToBlock", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isConnectedToHandbrake", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBinaryAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpAction")
    HK_PATCH_MEMBER_ADDED("bodyA", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("bodyB", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpAction", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpPairCollisionFilterMapPairFilterKeyOverrideType", 0)
    HK_PATCH_MEMBER_ADDED("numElems", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("hashMod", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultVelocityDamper", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleVelocityDamper")
    HK_PATCH_MEMBER_ADDED("normalSpinDamping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("collisionSpinDamping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("collisionThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpVehicleVelocityDamper", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpTyremarkPoint", 0)
    HK_PATCH_MEMBER_ADDED("pointLeft", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pointRight", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDynamicCompoundShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompoundShape")
    HK_PATCH_MEMBER_ADDED("tree", TYPE_STRUCT, "hknpDynamicCompoundShapeTree", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDefaultDynamicStoragehkcdDynamicTreeCodec32", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDynamicStorage0hkcdDynamicTreeAnisotropicMetrichkcdDynamicTreeCodec32", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeTreehkcdDynamicTreeDynamicStorage16", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeAnisotropicMetric", 0)
    HK_PATCH_DEPENDS("hknpCompoundShape", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDefaultTree32Storage", 0)
    HK_PATCH_DEPENDS("hknpDynamicCompoundShapeTree", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDynamicStorage16", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleFrictionDescriptionAxisDescription", 0)
    HK_PATCH_MEMBER_ADDED("frictionCircleYtab", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("xStep", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("xStart", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelSurfaceInertia", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelSurfaceInertiaInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelChassisMassRatio", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelRadiusInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelDownForceFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelDownForceSumFactor", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDriverInputStatus", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultAerodynamics", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleAerodynamics")
    HK_PATCH_MEMBER_ADDED("airDensity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("frontalArea", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dragCoefficient", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("liftCoefficient", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("extraGravityws", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleAerodynamics", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultBrake", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleBrake")
    HK_PATCH_MEMBER_ADDED("wheelBrakingProperties", TYPE_ARRAY_STRUCT, "hknpVehicleDefaultBrakeWheelBrakingProperties", 0)
    HK_PATCH_MEMBER_ADDED("wheelsMinTimeToBlock", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpVehicleDefaultBrakeWheelBrakingProperties", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleBrake", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedMeshShapeTreeDataRunData", 0)
    HK_PATCH_MEMBER_ADDED("data", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCollisionFilter", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSphereShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpConvexShape")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpConvexShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMinMaxQuadTreeMinMaxLevel", 0)
    HK_PATCH_MEMBER_ADDED("minMaxData", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("xRes", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("zRes", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpPhysicsSystemData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("materials", TYPE_ARRAY_STRUCT, "hknpMaterial", 0)
    HK_PATCH_MEMBER_ADDED("motionProperties", TYPE_ARRAY_STRUCT, "hknpMotionProperties", 0)
    HK_PATCH_MEMBER_ADDED("motionCinfos", TYPE_ARRAY_STRUCT, "hknpMotionCinfo", 0)
    HK_PATCH_MEMBER_ADDED("bodyCinfos", TYPE_ARRAY_STRUCT, "hknpBodyCinfo", 0)
    HK_PATCH_MEMBER_ADDED("constraintCinfos", TYPE_ARRAY_STRUCT, "hknpConstraintCinfo", 0)
    HK_PATCH_MEMBER_ADDED("referencedObjects", TYPE_ARRAY_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpMotionCinfo", 0)
    HK_PATCH_DEPENDS("hknpConstraintCinfo", 0)
    HK_PATCH_DEPENDS("hknpBodyCinfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpMaterial", 0)
    HK_PATCH_DEPENDS("hknpMotionProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dispatchType", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("convexRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("properties", TYPE_OBJECT, "hkRefCountedProperties", 0)
    HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numShapeKeyBits", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkRefCountedProperties", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleRayCastWheelCollide", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleWheelCollide")
    HK_PATCH_MEMBER_ADDED("wheelCollisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleWheelCollide", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDriverInput", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleSuspension", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("wheelParams", TYPE_ARRAY_STRUCT, "hknpVehicleSuspensionSuspensionWheelParameters", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleSuspensionSuspensionWheelParameters", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpScaledConvexShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpScaledConvexShapeBase")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpScaledConvexShapeBase", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpPairCollisionFilter", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCollisionFilter")
    HK_PATCH_MEMBER_ADDED("childFilter", TYPE_OBJECT, "hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleFrictionStatus", 0)
    HK_PATCH_MEMBER_ADDED("axis", TYPE_TUPLE_STRUCT, "hknpVehicleFrictionStatusAxisStatus", 2)
    HK_PATCH_DEPENDS("hknpVehicleFrictionStatusAxisStatus", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStaticCompoundShapeTree", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdStaticTreeDefaultTreeStorage6")
    HK_PATCH_DEPENDS("hkcdStaticTreeDefaultTreeStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis6", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleTransmission", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedMeshShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompositeShape")
    HK_PATCH_MEMBER_ADDED("internals", TYPE_STRUCT, "hknpCompressedMeshShapeTree", 0)
    HK_PATCH_MEMBER_ADDED("quadIsFlat", TYPE_STRUCT, "hkBitField", 0)
    HK_PATCH_MEMBER_ADDED("trianglesWithDuplicatedEdges", TYPE_STRUCT, "hkBitField", 0)
    HK_PATCH_DEPENDS("hkBitField", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hknpCompressedMeshShapeTree", 0)
    HK_PATCH_DEPENDS("hkcdStaticMeshTreeBase", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkcdStaticMeshTreehkcdStaticMeshTreeCommonConfigunsignedintunsignedlonglong1121hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis5", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpPhysicsSceneDataSystemInstance", 0)
    HK_PATCH_MEMBER_ADDED("systemData", TYPE_OBJECT, "hknpPhysicsSystemData", 0)
    HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpPhysicsSystemData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpUnaryAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpAction")
    HK_PATCH_MEMBER_ADDED("body", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpAction", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDriverInputAnalogStatus", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleDriverInputStatus")
    HK_PATCH_MEMBER_ADDED("positionX", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("positionY", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("handbrakeButtonPressed", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("reverseButtonPressed", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleDriverInputStatus", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBody", 0)
    HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_MEMBER_ADDED("collisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motionId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("broadPhaseId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("nextAttachedBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("radiusOfComCenteredBoundingSphere", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxTimDistance", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("timAngle", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shapeSizeDiv16", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("indexIntoActiveListOrDeactivatedIslandId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motionToBodyRotation", TYPE_TUPLE_INT, HK_NULL, 4)
    HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb16", 0)
    HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("qualityId", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxContactDistance", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkAabb16", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSpringAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpBinaryAction")
    HK_PATCH_MEMBER_ADDED("lastForce", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("positionAinA", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("positionBinB", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("restLength", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("strength", 1000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("damping", 0.100000f)
    HK_PATCH_MEMBER_ADDED_BYTE("onCompression", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("onExtension", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpAction", 0)
    HK_PATCH_DEPENDS("hknpBinaryAction", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShapeInstance", 0)
    HK_PATCH_MEMBER_ADDED("transform", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("scale", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_MEMBER_ADDED("shapeTag", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("padding", TYPE_TUPLE_BYTE, HK_NULL, 32)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkcdStaticMeshTreehkcdStaticMeshTreeCommonConfigunsignedintunsignedlonglong1121hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdStaticMeshTreeBase")
    HK_PATCH_MEMBER_ADDED("packedVertices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sharedVertices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("primitiveDataRuns", TYPE_ARRAY_STRUCT, "hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_DEPENDS("hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_DEPENDS("hkcdStaticMeshTreeBasePrimitiveDataRunBasehknpCompressedMeshShapeTreeDataRunData", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis5", 0)
    HK_PATCH_DEPENDS("hkcdStaticMeshTreeBase", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShapeTagCodec", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultSteering", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleSteering")
    HK_PATCH_MEMBER_ADDED("maxSteeringAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxSpeedFullSteeringAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("doesWheelSteer", TYPE_ARRAY_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleSteering", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpWorldSnapshot", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("worldCinfo", TYPE_STRUCT, "hknpWorldCinfo", 0)
    HK_PATCH_MEMBER_ADDED("bodies", TYPE_ARRAY_STRUCT, "hknpBody", 0)
    HK_PATCH_MEMBER_ADDED("motions", TYPE_ARRAY_STRUCT, "hknpMotion", 0)
    HK_PATCH_MEMBER_ADDED("constraints", TYPE_ARRAY_STRUCT, "hknpConstraintCinfo", 0)
    HK_PATCH_MEMBER_ADDED("bodyNames", TYPE_ARRAY_CSTRING, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpWorldCinfo", 0)
    HK_PATCH_DEPENDS("hknpConstraintCinfo", 0)
    HK_PATCH_DEPENDS("hknpBody", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpMotion", 0)
    HK_PATCH_DEPENDS("hknpMaterial", 0)
    HK_PATCH_DEPENDS("hknpMotionProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintCinfo", 0)
    HK_PATCH_MEMBER_ADDED("constraintData", TYPE_OBJECT, "hkpConstraintData", 0)
    HK_PATCH_MEMBER_ADDED("bodyA", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("bodyB", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpConstraintData", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCentrifugalForceAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpUnaryAction")
    HK_PATCH_DEPENDS("hknpUnaryAction", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpAction", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedMeshShapeTree", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdStaticMeshTreehkcdStaticMeshTreeCommonConfigunsignedintunsignedlonglong1121hknpCompressedMeshShapeTreeDataRun")
    HK_PATCH_DEPENDS("hkcdStaticMeshTreehkcdStaticMeshTreeCommonConfigunsignedintunsignedlonglong1121hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage5", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis5", 0)
    HK_PATCH_DEPENDS("hkcdStaticMeshTreeBase", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionProperties", 0)
    HK_PATCH_MEMBER_ADDED("isExclusive", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("linearDamping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("angularDamping", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("gravityFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("solverStabilizationVelocityThreshold", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("solverStabilizationVelocityReduction", 0.000000f)
    HK_PATCH_MEMBER_ADDED("maxDistSqrd", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxRotSqrd", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("invBlockSize", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pathingUpperThreshold", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pathingLowerThreshold", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numDeactivationFrequencyPasses", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("deactivationVelocityScaleSquare", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minimumPathingVelocityScaleSquare", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("spikingVelocityScaleThresholdSquared", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minimumSpikingVelocityScaleSquared", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxLinearSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxAngularSpeed", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("gravity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numWheels", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisOrientation", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torqueRollFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torquePitchFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torqueYawFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("extraTorqueFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxVelocityForPositionalFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisUnitInertiaYaw", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisUnitInertiaRoll", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisUnitInertiaPitch", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("frictionEqualizer", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("normalClippingAngleCos", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxFrictionSolverMassRatio", 30.000000f)
    HK_PATCH_MEMBER_ADDED("wheelParams", TYPE_ARRAY_STRUCT, "hknpVehicleDataWheelComponentParams", 0)
    HK_PATCH_MEMBER_ADDED("numWheelsPerAxle", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("frictionDescription", TYPE_STRUCT, "hkpVehicleFrictionDescription", 0)
    HK_PATCH_MEMBER_ADDED("chassisFrictionInertiaInvDiag", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("alreadyInitialised", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpVehicleFrictionDescription", 0)
    HK_PATCH_DEPENDS("hknpVehicleDataWheelComponentParams", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConvexShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpShape")
    HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultAnalogDriverInput", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleDriverInput")
    HK_PATCH_MEMBER_ADDED("slopeChangePointX", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("initialSlope", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("deadZone", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("autoReverse", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleDriverInput", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultSuspensionWheelSpringSuspensionParameters", 0)
    HK_PATCH_MEMBER_ADDED("strength", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dampingCompression", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dampingRelaxation", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultEngine", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleEngine")
    HK_PATCH_MEMBER_ADDED("minRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("optRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxTorque", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torqueFactorAtMinRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torqueFactorAtMaxRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("resistanceFactorAtMinRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("resistanceFactorAtOptRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("resistanceFactorAtMaxRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("clutchSlipRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleEngine", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleSuspensionSuspensionWheelParameters", 0)
    HK_PATCH_MEMBER_ADDED("hardpointChassisSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("directionChassisSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("length", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSparseCompactMapunsignedshort", 0)
    HK_PATCH_MEMBER_ADDED("secondaryKeyMask", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sencondaryKeyBits", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("primaryKeyToIndex", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("valueAndSecondaryKeys", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultTransmission", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleTransmission")
    HK_PATCH_MEMBER_ADDED("downshiftRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("upshiftRPM", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("primaryTransmissionRatio", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("clutchDelayTime", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("reverseGearRatio", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("gearsRatio", TYPE_ARRAY_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelsTorqueRatio", TYPE_ARRAY_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleTransmission", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShapeType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleBrake", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRefWorldCinfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("info", TYPE_STRUCT, "hknpWorldCinfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpWorldCinfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotion", 0)
    HK_PATCH_MEMBER_ADDED("orientation", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("integrationFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxRotationToPreventTunneling", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxLinearAccelerationDistancePerStep", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("linearVelocityCage", TYPE_TUPLE_REAL, HK_NULL, 3)
    HK_PATCH_MEMBER_ADDED("motionPropertiesId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("cellIndex", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("linearVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("angularVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("previousStepLinearVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("previousStepAngularVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("positionAndDensity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("inverseInertia", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstAttachedBodyId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDynamicCompoundShapeTree", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdDynamicTreeDefaultTree32Storage")
    HK_PATCH_DEPENDS("hkcdDynamicTreeDefaultDynamicStoragehkcdDynamicTreeCodec32", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeTreehkcdDynamicTreeDynamicStorage16", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDefaultTree32Storage", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeAnisotropicMetric", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDynamicStorage16", 0)
    HK_PATCH_DEPENDS("hkcdDynamicTreeDynamicStorage0hkcdDynamicTreeAnisotropicMetrichkcdDynamicTreeCodec32", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCollisionDispatchType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpScaledConvexShapeBase", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpShape")
    HK_PATCH_MEMBER_ADDED("childShape", TYPE_OBJECT, "hknpConvexShape", 0)
    HK_PATCH_MEMBER_ADDED("scale", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("translation", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpConvexShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionCinfo", 0)
    HK_PATCH_MEMBER_ADDED("motionPropertiesId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("enableDeactivation", 1)
    HK_PATCH_MEMBER_ADDED_REAL("maxLinearAccelerationDistancePerStep", 18446726481523507000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxRotationToPreventTunneling", 18446726481523507000.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("centerOfMassWorld", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("orientation", 0.000000f,0.000000f,0.000000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("linearVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("angularVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("inverseMass", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("densityFactor", 1.000000f)
    HK_PATCH_MEMBER_ADDED("inverseInertiaLocal", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterial", 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isExclusive", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("frictionCombinePolicy", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("restitutionCombinePolicy", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("weldingTolerance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triggerVolumeType", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triggerVolumeTolerance", TYPE_STRUCT, "hkUFloat8", 0)
    HK_PATCH_MEMBER_ADDED("massChangerCategory", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("massChangerHeavyObjectFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxContactImpulse", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("softContactForceFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("softContactDampFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("softContactSeperationVelocity", TYPE_STRUCT, "hkUFloat8", 0)
    HK_PATCH_MEMBER_ADDED("surfaceVelocity", TYPE_OBJECT, "hknpSurfaceVelocity", 0)
    HK_PATCH_MEMBER_ADDED("disablingCollisionsBetweenCvxCvxDynamicObjectsDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isShared", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("dynamicFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("staticFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("restitution", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("fractionOfClippedImpulseToApply", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpSurfaceVelocity", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkUFloat8", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDefaultSuspension", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpVehicleSuspension")
    HK_PATCH_MEMBER_ADDED("wheelSpringParams", TYPE_ARRAY_STRUCT, "hknpVehicleDefaultSuspensionWheelSpringSuspensionParameters", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleSuspension", 0)
    HK_PATCH_DEPENDS("hknpVehicleDefaultSuspensionWheelSpringSuspensionParameters", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkcdStaticMeshTreeBasePrimitiveDataRunBasehknpCompressedMeshShapeTreeDataRunData", 0)
    HK_PATCH_MEMBER_ADDED("value", TYPE_STRUCT, "hknpCompressedMeshShapeTreeDataRunData", 0)
    HK_PATCH_MEMBER_ADDED("index", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("count", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpCompressedMeshShapeTreeDataRunData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkFreeListArrayhknpShapeInstancehkHandleshort32767hknpShapeInstanceIdDiscriminant8hknpShapeInstance", 0)
    HK_PATCH_MEMBER_ADDED("elements", TYPE_ARRAY_STRUCT, "hknpShapeInstance", 0)
    HK_PATCH_MEMBER_ADDED("firstFree", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpShapeInstance", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleEngine", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyCinfo", 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_MEMBER_ADDED("reservedBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motionId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 0)
    HK_PATCH_MEMBER_ADDED_REAL("collisionLookAheadDistance", 0.000000f)
    HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("orientation", 0.000000f,0.000000f,0.000000f,1.000000f)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("qualityId", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("flags", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterialPalette", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("entries", TYPE_ARRAY_STRUCT, "hknpMaterialDescriptor", 0)
    HK_PATCH_DEPENDS("hknpMaterialDescriptor", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpTyremarksWheel", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("currentPosition", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numPoints", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("tyremarkPoints", TYPE_ARRAY_STRUCT, "hknpTyremarkPoint", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpTyremarkPoint", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpTyremarksInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("minTyremarkEnergy", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxTyremarkEnergy", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("tyremarksWheel", TYPE_ARRAY_OBJECT, "hknpTyremarksWheel", 0)
    HK_PATCH_DEPENDS("hknpTyremarksWheel", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStaticCompoundShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompoundShape")
    HK_PATCH_MEMBER_ADDED("tree", TYPE_STRUCT, "hknpStaticCompoundShapeTree", 0)
    HK_PATCH_DEPENDS("hknpStaticCompoundShapeTree", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDefaultTreeStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hknpCompoundShape", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis6", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompoundShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompositeShape")
    HK_PATCH_MEMBER_ADDED("instances", TYPE_STRUCT, "hkFreeListArrayhknpShapeInstancehkHandleshort32767hknpShapeInstanceIdDiscriminant8hknpShapeInstance", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hkFreeListArrayhknpShapeInstancehkHandleshort32767hknpShapeInstanceIdDiscriminant8hknpShapeInstance", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompositeShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpShape")
    HK_PATCH_MEMBER_ADDED("edgeWeldingMap", TYPE_STRUCT, "hknpSparseCompactMapunsignedshort", 0)
    HK_PATCH_MEMBER_ADDED("shapeTagCodecInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpSparseCompactMapunsignedshort", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hknpMaterialPalette", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleInstanceWheelInfo", 0)
    HK_PATCH_MEMBER_ADDED("contactPoint", TYPE_STRUCT, "hkContactPoint", 0)
    HK_PATCH_MEMBER_ADDED("contactFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("contactShapeKey", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("hardPointWs", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rayEndPointWs", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("currentSuspensionLength", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("suspensionDirectionWs", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("spinAxisChassisSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("spinAxisWs", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("steeringOrientationChassisSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("spinVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("noSlipIdealSpinVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("spinAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("skidEnergyDensity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sideForce", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("forwardSlipVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("sideSlipVelocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkContactPoint", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleSteering", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpWorldCinfo", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("gravity", 0.000000f,-9.810000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("simulationType", 1)
    HK_PATCH_MEMBER_ADDED_INT("numSplitterCells", 16)
    HK_PATCH_MEMBER_ADDED_BYTE("enableDeactivation", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("leavingBroadPhaseBehavior", 2)
    HK_PATCH_MEMBER_ADDED_REAL("solverTau", 0.600000f)
    HK_PATCH_MEMBER_ADDED_REAL("solverDamp", 1.000000f)
    HK_PATCH_MEMBER_ADDED_INT("solverIterations", 4)
    HK_PATCH_MEMBER_ADDED_INT("solverMicrosteps", 1)
    HK_PATCH_MEMBER_ADDED_REAL("defaultSolverTimestep", 0.033333f)
    HK_PATCH_MEMBER_ADDED_BYTE("enableSolverDynamicScheduling", 0)
    HK_PATCH_MEMBER_ADDED_REAL("relativeCollisionAccuracy", 0.050000f)
    HK_PATCH_MEMBER_ADDED_INT("largeIslandSize", 100)
    HK_PATCH_MEMBER_ADDED_BYTE("mergeEventsBeforeDispatch", 1)
    HK_PATCH_MEMBER_ADDED_INT("bodyBufferCapacity", 4096)
    HK_PATCH_MEMBER_ADDED_INT("motionBufferCapacity", 4096)
    HK_PATCH_MEMBER_ADDED_POINTER("materialLibrary", "hknpMaterialLibrary", 0)
    HK_PATCH_MEMBER_ADDED_POINTER("motionPropertiesLibrary", "hknpMotionPropertiesLibrary", 0)
    HK_PATCH_MEMBER_ADDED_POINTER("qualityLibrary", "hknpBodyQualityLibrary", 0)
    HK_PATCH_MEMBER_ADDED("broadPhaseAabb", TYPE_STRUCT, "hkAabb", 0)
    HK_PATCH_MEMBER_ADDED_INT("maxNumBroadPhasePairs", 131072)
    HK_PATCH_MEMBER_ADDED_POINTER("broadPhaseConfig", "hknpBroadPhaseConfig", 0)
    HK_PATCH_MEMBER_ADDED_REAL("collisionTolerance", 0.050000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxApproachSpeedForHighQualitySolver", 1.000000f)
    HK_PATCH_MEMBER_ADDED("solverSpinCount", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("processActionsSingleThreaded", 1)
    HK_PATCH_MEMBER_ADDED_REAL("unitScale", 1.000000f)
    HK_PATCH_DEPENDS("hknpBody", 0)
    HK_PATCH_DEPENDS("hknpMotion", 0)
    HK_PATCH_DEPENDS("hknpBroadPhaseConfig", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpBodyQualityLibrary", 0)
    HK_PATCH_DEPENDS("hkAabb", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpMotionPropertiesLibrary", 0)
    HK_PATCH_DEPENDS("hknpMaterialLibrary", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleInstance", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpUnaryAction")
    HK_PATCH_MEMBER_ADDED("data", TYPE_OBJECT, "hknpVehicleData", 0)
    HK_PATCH_MEMBER_ADDED("driverInput", TYPE_OBJECT, "hknpVehicleDriverInput", 0)
    HK_PATCH_MEMBER_ADDED("steering", TYPE_OBJECT, "hknpVehicleSteering", 0)
    HK_PATCH_MEMBER_ADDED("engine", TYPE_OBJECT, "hknpVehicleEngine", 0)
    HK_PATCH_MEMBER_ADDED("transmission", TYPE_OBJECT, "hknpVehicleTransmission", 0)
    HK_PATCH_MEMBER_ADDED("brake", TYPE_OBJECT, "hknpVehicleBrake", 0)
    HK_PATCH_MEMBER_ADDED("suspension", TYPE_OBJECT, "hknpVehicleSuspension", 0)
    HK_PATCH_MEMBER_ADDED("aerodynamics", TYPE_OBJECT, "hknpVehicleAerodynamics", 0)
    HK_PATCH_MEMBER_ADDED("wheelCollide", TYPE_OBJECT, "hknpVehicleWheelCollide", 0)
    HK_PATCH_MEMBER_ADDED("tyreMarks", TYPE_OBJECT, "hknpTyremarksInfo", 0)
    HK_PATCH_MEMBER_ADDED("velocityDamper", TYPE_OBJECT, "hknpVehicleVelocityDamper", 0)
    HK_PATCH_MEMBER_ADDED("wheelsInfo", TYPE_ARRAY_STRUCT, "hknpVehicleInstanceWheelInfo", 0)
    HK_PATCH_MEMBER_ADDED("frictionStatus", TYPE_STRUCT, "hkpVehicleFrictionStatus", 0)
    HK_PATCH_MEMBER_ADDED("deviceStatus", TYPE_OBJECT, "hknpVehicleDriverInputStatus", 0)
    HK_PATCH_MEMBER_ADDED("isFixed", TYPE_ARRAY_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelsTimeSinceMaxPedalInput", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("tryingToReverse", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("torque", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rpm", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("mainSteeringAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("mainSteeringAngleAssumingNoReduction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("wheelsSteeringAngle", TYPE_ARRAY_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isReversing", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("currentGear", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("delayed", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("clutchDelayCountdown", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpUnaryAction", 0)
    HK_PATCH_DEPENDS("hknpVehicleBrake", 0)
    HK_PATCH_DEPENDS("hknpVehicleEngine", 0)
    HK_PATCH_DEPENDS("hkpVehicleFrictionStatus", 0)
    HK_PATCH_DEPENDS("hknpVehicleVelocityDamper", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpTyremarksInfo", 0)
    HK_PATCH_DEPENDS("hknpAction", 0)
    HK_PATCH_DEPENDS("hknpVehicleDriverInput", 0)
    HK_PATCH_DEPENDS("hknpVehicleSuspension", 0)
    HK_PATCH_DEPENDS("hknpVehicleWheelCollide", 0)
    HK_PATCH_DEPENDS("hknpVehicleTransmission", 0)
    HK_PATCH_DEPENDS("hknpVehicleInstanceWheelInfo", 0)
    HK_PATCH_DEPENDS("hknpVehicleDriverInputStatus", 0)
    HK_PATCH_DEPENDS("hknpVehicleData", 0)
    HK_PATCH_DEPENDS("hknpVehicleSteering", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpVehicleAerodynamics", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterialDescriptor", 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("material", TYPE_OBJECT, "hknpRefMaterial", 0)
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpRefMaterial", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConstraintCollisionFilter", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpPairCollisionFilter")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hknpPairCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedMeshShapeTreeDataRun", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdStaticMeshTreeBasePrimitiveDataRunBasehknpCompressedMeshShapeTreeDataRunData")
    HK_PATCH_DEPENDS("hkcdStaticMeshTreeBasePrimitiveDataRunBasehknpCompressedMeshShapeTreeDataRunData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleDataWheelComponentParams", 0)
    HK_PATCH_MEMBER_ADDED("radius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("mass", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("width", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("friction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("viscosityFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxFriction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("slipAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("forceFeedbackMultiplier", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxContactBodyAcceleration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("axle", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleWheelCollide", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("alreadyUsed", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleAerodynamics", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpRefMaterial", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("material", TYPE_STRUCT, "hknpMaterial", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpMaterial", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConvexPolytopeShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpConvexShape")
    HK_PATCH_MEMBER_ADDED("planes", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("indices", TYPE_ARRAY_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("faces", TYPE_ARRAY_STRUCT, "hknpConvexPolytopeShapeFace", 0)
    HK_PATCH_DEPENDS("hknpConvexPolytopeShapeFace", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpConvexShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpVehicleFrictionDescription", 0)
    HK_PATCH_MEMBER_ADDED("wheelDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("chassisMassInv", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("axleDescr", TYPE_TUPLE_STRUCT, "hknpVehicleFrictionDescriptionAxisDescription", 2)
    HK_PATCH_DEPENDS("hknpVehicleFrictionDescriptionAxisDescription", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpSurfaceVelocity", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpPhysicsSceneData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("systemInstances", TYPE_ARRAY_STRUCT, "hknpPhysicsSceneDataSystemInstance", 0)
    HK_PATCH_MEMBER_ADDED("worldCinfo", TYPE_OBJECT, "hknpRefWorldCinfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpPhysicsSceneDataSystemInstance", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpRefWorldCinfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkFreeListArrayhknpMotionPropertieshknpMotionPropertiesId8hknpMotionPropertiesFreeListArrayOperations", 0)
    HK_PATCH_MEMBER_ADDED("elements", TYPE_ARRAY_STRUCT, "hknpMotionProperties", 0)
    HK_PATCH_MEMBER_ADDED("firstFree", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpMotionProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkFreeListArrayhknpMaterialhknpMaterialId8hknpMaterialFreeListArrayOperations", 0)
    HK_PATCH_MEMBER_ADDED("elements", TYPE_ARRAY_STRUCT, "hknpMaterial", 0)
    HK_PATCH_MEMBER_ADDED("firstFree", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpMaterial", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDefaultBroadPhaseConfig", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpBroadPhaseConfig")
    HK_PATCH_MEMBER_ADDED("layers", TYPE_TUPLE_STRUCT, "hknpBroadPhaseConfigLayer", 4)
    HK_PATCH_DEPENDS("hknpBroadPhaseConfig", 0)
    HK_PATCH_DEPENDS("hknpBroadPhaseConfigLayer", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExternMeshShapeTree", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkcdStaticTreeDefaultTreeStorage6")
    HK_PATCH_DEPENDS("hkcdStaticTreeDefaultTreeStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis6", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpConvexPolytopeShapeFace", 0)
    HK_PATCH_MEMBER_ADDED("minHalfAngle", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numIndices", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDisableCollisionFilter", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCollisionFilter")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyQuality", 0)
    HK_PATCH_MEMBER_ADDED("priority", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("supportedFlags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("requestedFlags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("liveJacobianDistanceThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("liveJacobianAngleThreshold", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpLinearSurfaceVelocity", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpSurfaceVelocity")
    HK_PATCH_MEMBER_ADDED("space", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("projectMethod", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxVelocityScale", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("velocityMeasurePlane", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("velocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpSurfaceVelocity", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpGroupCollisionFilter", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCollisionFilter")
    HK_PATCH_MEMBER_ADDED("nextFreeSystemGroup", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("collisionLookupTable", TYPE_TUPLE_INT, HK_NULL, 32)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDestructionShapeProperties", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("worldFromShape", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isHierarchicalCompound", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("hasDestructionShapes", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMinMaxQuadTree", 0)
    HK_PATCH_MEMBER_ADDED("coarseTreeData", TYPE_ARRAY_STRUCT, "hknpMinMaxQuadTreeMinMaxLevel", 0)
    HK_PATCH_MEMBER_ADDED("offset", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("multiplier", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("invMultiplier", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpMinMaxQuadTreeMinMaxLevel", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedHeightFieldShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpHeightFieldShape")
    HK_PATCH_MEMBER_ADDED("storage", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shapeTags", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triangleFlip", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("offset", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("scale", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpHeightFieldShape", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpHeightFieldShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompositeShape")
    HK_PATCH_MEMBER_ADDED("aabb", TYPE_STRUCT, "hkAabb", 0)
    HK_PATCH_MEMBER_ADDED("floatToIntScale", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("intToFloatScale", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("intSizeX", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("intSizeZ", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numBitsX", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numBitsZ", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minMaxTree", TYPE_STRUCT, "hknpMinMaxQuadTree", 0)
    HK_PATCH_MEMBER_ADDED("minMaxTreeCoarseness", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("smooth", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkAabb", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
    HK_PATCH_DEPENDS("hknpMinMaxQuadTree", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyQualityLibrary", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("qualities", TYPE_TUPLE_STRUCT, "hknpBodyQuality", 32)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpBodyQuality", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCircularSurfaceVelocity", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpSurfaceVelocity")
    HK_PATCH_MEMBER_ADDED("velocityIsLocalSpace", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pivot", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("angularVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpSurfaceVelocity", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBroadPhaseConfigLayer", 0)
    HK_PATCH_MEMBER_ADDED("collideWithLayerMask", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isVolatile", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpWorkLoad", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaterialLibrary", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("entries", TYPE_STRUCT, "hkFreeListArrayhknpMaterialhknpMaterialId8hknpMaterialFreeListArrayOperations", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkFreeListArrayhknpMaterialhknpMaterialId8hknpMaterialFreeListArrayOperations", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBroadPhaseConfig", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCharacterRigidBodyCinfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("collisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("orientation", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("mass", 100.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("dynamicFriction", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("staticFriction", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("weldingTolerance", 0.100000f)
    HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxSlope", 1.047198f)
    HK_PATCH_MEMBER_ADDED_REAL("maxForce", 1000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxSpeedForSimplexSolver", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("supportDistance", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("hardSupportDistance", 0.000000f)
    HK_PATCH_MEMBER_ADDED("reservedBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBodyReference", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("id", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShapeMassProperties", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("compressedMassProperties", TYPE_STRUCT, "hkCompressedMassProperties", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkCompressedMassProperties", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMotionPropertiesLibrary", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("entries", TYPE_STRUCT, "hkFreeListArrayhknpMotionPropertieshknpMotionPropertiesId8hknpMotionPropertiesFreeListArrayOperations", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkFreeListArrayhknpMotionPropertieshknpMotionPropertiesId8hknpMotionPropertiesFreeListArrayOperations", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCharacterProxyCinfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("orientation", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("velocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("dynamicFriction", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("staticFriction", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("keepContactTolerance", 0.100000f)
    HK_PATCH_MEMBER_ADDED("up", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_MEMBER_ADDED("collisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("keepDistance", 0.050000f)
    HK_PATCH_MEMBER_ADDED_REAL("contactAngleSensitivity", 10.000000f)
    HK_PATCH_MEMBER_ADDED_INT("userPlanes", 4)
    HK_PATCH_MEMBER_ADDED_REAL("maxCharacterSpeedForSolver", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("characterStrength", 79000001377644491000000000000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("characterMass", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxSlope", 1.570796f)
    HK_PATCH_MEMBER_ADDED_REAL("penetrationRecoverySpeed", 1.000000f)
    HK_PATCH_MEMBER_ADDED_INT("maxCastIterations", 10)
    HK_PATCH_MEMBER_ADDED_BYTE("refreshManifoldInCheckSupport", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("presenceInWorld", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExternMeshShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCompositeShape")
    HK_PATCH_MEMBER_ADDED("mesh", TYPE_OBJECT, "hknpExternMeshShapeMesh", 0)
    HK_PATCH_MEMBER_ADDED("tree", TYPE_OBJECT, "hknpExternMeshShapeTree", 0)
    HK_PATCH_MEMBER_ADDED("numIndexKeyBits", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("ownTree", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDefaultTreeStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeDynamicStoragehkcdStaticTreeCodec3Axis6", 0)
    HK_PATCH_DEPENDS("hknpExternMeshShapeTree", 0)
    HK_PATCH_DEPENDS("hkcdStaticTreeTreehkcdStaticTreeDynamicStorage6", 0)
    HK_PATCH_DEPENDS("hknpExternMeshShapeMesh", 0)
    HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpExternMeshShapeMesh", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpMotion", 0, "hknpMotion", 1)
        HK_PATCH_MEMBER_REMOVED("positionAndDensity", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("centerOfMassAndMassFactor", TYPE_VEC_4, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED("isValid", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpMotionCinfo", 0, "hknpMotionCinfo", 1)
        HK_PATCH_MEMBER_REMOVED("densityFactor", TYPE_REAL, HK_NULL, 0)
        HK_PATCH_MEMBER_ADDED_REAL("massFactor", 1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCompoundShape", 0, "hknpCompoundShape", 1)
    HK_PATCH_MEMBER_ADDED("isMutable", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpShape", 0, "hknpShape", 1)
    HK_PATCH_MEMBER_RENAMED("flags", "old_flags")
    HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_FUNCTION(hknpShape_0_to_1)
    HK_PATCH_MEMBER_REMOVED("old_flags", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCharacterRigidBodyCinfo", 0, "hknpCharacterRigidBodyCinfo", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("additionFlags", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpPhysicsSceneData", 0, "hknpPhysicsSceneData", 1)
    HK_PATCH_DEPENDS("hknpPhysicsSceneDataSystemInstance", 0)
    HK_PATCH_MEMBER_ADDED("systemDatas", TYPE_ARRAY_OBJECT, "hknpPhysicsSystemData", 0)
    HK_PATCH_FUNCTION(hknpPhysicsSceneData_0_to_1)
    HK_PATCH_MEMBER_REMOVED("systemInstances", TYPE_ARRAY_STRUCT, "hknpPhysicsSceneDataSystemInstance", 0)
    HK_PATCH_DEPENDS("hknpPhysicsSystemData", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpPhysicsSceneDataSystemInstance", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_DEPENDS("hknpPhysicsSceneData", 1)
    HK_PATCH_MEMBER_REMOVED("systemData", TYPE_OBJECT, "hknpPhysicsSystemData", 0)
    HK_PATCH_MEMBER_REMOVED("transform", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_DEPENDS("hknpPhysicsSystemData", 1)
HK_PATCH_END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
