// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// NewPhysics specific product patches.
// This file is #included by hkndPatches.cpp

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShapeInstance", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndShape")
    HK_PATCH_MEMBER_ADDED("physicsShape", TYPE_OBJECT, "hknpShape", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFracturePiece", 0)
    HK_PATCH_MEMBER_ADDED("properties", TYPE_STRUCT, "hkRefCountedProperties", 0)
    HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hkndShape", 0)
    HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("parentId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstChildId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("nextSiblingId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstConnectionId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkRefCountedProperties", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndMaterial", 0)
    HK_PATCH_MEMBER_ADDED("density", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("destructionRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("elasticity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("breakingStrength", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("yieldStrength", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndConnection", 0)
    HK_PATCH_MEMBER_ADDED("pivot", TYPE_TUPLE_INT, HK_NULL, 8)
    HK_PATCH_MEMBER_ADDED("orientation", TYPE_TUPLE_INT, HK_NULL, 8)
    HK_PATCH_MEMBER_ADDED("angElasticity", TYPE_TUPLE_INT, HK_NULL, 8)
    HK_PATCH_MEMBER_ADDED("elasticitySpace", TYPE_TUPLE_INT, HK_NULL, 8)
    HK_PATCH_MEMBER_ADDED("data", TYPE_TUPLE_STRUCT, "hkFloat16", 4)
    HK_PATCH_MEMBER_ADDED("inertia", TYPE_TUPLE_INT, HK_NULL, 4)
    HK_PATCH_MEMBER_ADDED("pieces", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_ADDED("next", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkFloat16", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndHierarchy", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("fracturePieces", TYPE_ARRAY_STRUCT, "hkndFracturePiece", 0)
    HK_PATCH_MEMBER_ADDED("connections", TYPE_ARRAY_STRUCT, "hkndConnection", 0)
    HK_PATCH_MEMBER_ADDED("firstFreePieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("firstFreeConnectionId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isBaked", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracturePiece", 0)
    HK_PATCH_DEPENDS("hkndConnection", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndHierarchyInstance", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("hierarchyFromPieceTransforms", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
    HK_PATCH_MEMBER_ADDED("hierarchy", TYPE_OBJECT, "hkndHierarchy", 0)
    HK_PATCH_MEMBER_ADDED("isBaked", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndHierarchy", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndBodyCinfo", 0)
    HK_PATCH_MEMBER_ADDED("hInstance", TYPE_OBJECT, "hkndHierarchyInstance", 0)
    HK_PATCH_MEMBER_ADDED("controller", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rigidBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkndHierarchyInstance", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndGeometryTriangle", 0)
    HK_PATCH_MEMBER_ADDED("a", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("b", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("c", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndRemoveDebrisAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_REAL("removeInSeconds", 10.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("removeOnTimeout", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDestructionSystemData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("physicsData", TYPE_OBJECT, "hknpPhysicsSceneData", 0)
    HK_PATCH_MEMBER_ADDED("bodyCinfos", TYPE_ARRAY_STRUCT, "hkndBodyCinfo", 0)
    HK_PATCH_MEMBER_ADDED("bodyClones", TYPE_ARRAY_STRUCT, "hkndDestructionSystemDataBodyClone", 0)
    HK_PATCH_MEMBER_ADDED("materials", TYPE_ARRAY_STRUCT, "hkndMaterial", 0)
    HK_PATCH_MEMBER_ADDED("rbMaterials", TYPE_ARRAY_STRUCT, "hknpMaterial", 0)
    HK_PATCH_MEMBER_ADDED("rbMotionProperties", TYPE_ARRAY_STRUCT, "hknpMotionProperties", 0)
    HK_PATCH_DEPENDS("hknpMaterial", 0)
    HK_PATCH_DEPENDS("hknpMotionProperties", 0)
    HK_PATCH_DEPENDS("hkndMaterial", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpPhysicsSceneData", 0)
    HK_PATCH_DEPENDS("hkndBodyCinfo", 0)
    HK_PATCH_DEPENDS("hkndDestructionSystemDataBodyClone", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebrisFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("debrisTemplateProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("maxNumPieces", 100)
    HK_PATCH_MEMBER_ADDED_BYTE("insertType", 2)
    HK_PATCH_MEMBER_ADDED("controlShapesProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("positionSource", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("generationType", 1)
    HK_PATCH_MEMBER_ADDED_REAL("gap", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecalMapActionDecalMap", 0)
    HK_PATCH_MEMBER_ADDED("textureW", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("textureH", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("leafId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("type", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("data", TYPE_ARRAY_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingUnit")
    HK_PATCH_MEMBER_ADDED_REAL("rootToLeafRatio", 1000000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("minimumSize", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxDistanceForConnection", 0.100000f)
    HK_PATCH_MEMBER_ADDED_BYTE("refitPhysicsShapes", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("flattenHierarchy", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("allowOpenMeshes", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndInfoDataBlock", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingDataBlock")
    HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingDataBlock", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShapeType", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebugGraphics", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("texts", TYPE_ARRAY_STRUCT, "hkndDebugGraphicsText", 0)
    HK_PATCH_MEMBER_ADDED("lines", TYPE_ARRAY_STRUCT, "hkndDebugGraphicsLine", 0)
    HK_PATCH_MEMBER_ADDED("tris", TYPE_ARRAY_STRUCT, "hkndDebugGraphicsTriangle", 0)
    HK_PATCH_DEPENDS("hkndDebugGraphicsText", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndDebugGraphicsLine", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDebugGraphicsTriangle", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntimeShapeDecorationInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("connectionDecorations", TYPE_ARRAY_STRUCT, "hkndDecorateFractureFaceRuntimeConnectionDecorationInfo", 0)
    HK_PATCH_MEMBER_ADDED("sharedData", TYPE_OBJECT, "hkndDecorateFractureFaceRuntimeGlobalDecorationData", 0)
    HK_PATCH_MEMBER_ADDED("decoratedPieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceRuntimeGlobalDecorationData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceRuntimeConnectionDecorationInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSplittingPlane", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("properties", TYPE_STRUCT, "hkRefCountedProperties", 0)
    HK_PATCH_DEPENDS("hkRefCountedProperties", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebrisFractureInfoTemplateInfo", 0)
    HK_PATCH_MEMBER_ADDED("debrisTemplateProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDestructionSystemDataBodyClone", 0)
    HK_PATCH_MEMBER_ADDED("breakableBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rigidBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
HK_PATCH_END()



HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShapeFlag", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFractureDataBlock", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingDataBlock")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingDataBlock", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndAssetProcessingEnvironment", 0)
    HK_PATCH_MEMBER_ADDED("destructionData", TYPE_OBJECT, "hkndDestructionSystemData", 0)
    HK_PATCH_MEMBER_ADDED("fractureEngine", TYPE_OBJECT, "hkndFractureEngine", 0)
    HK_PATCH_MEMBER_ADDED("sceneAabb", TYPE_STRUCT, "hkAabb", 0)
    HK_PATCH_MEMBER_ADDED("maxDistanceForConnection", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minConnectionArea", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("modelFilePath", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkndDestructionSystemData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkAabb", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndFractureEngine", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDestructionDemoConfig", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED_BYTE("useData", 1)
    HK_PATCH_MEMBER_ADDED_VEC_4("initialCharacterPosition", 0.000000f,1.000000f,10.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("initialCharacterDirection", 0.000000f,0.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("lightSourcePosition", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("lightSourceDirection", 0.000000f,-3.000000f,-1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("lightSourceColor", 1.000000f,1.000000f,1.000000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("lightFillColor", 0.300000f,0.300000f,0.300000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("lightRimColor", 0.200000f,0.200000f,0.200000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("ambientLightColor", 0.100000f,0.100000f,0.100000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_INT("maxNumTimeoutDebrisPieces", 1000000)
    HK_PATCH_MEMBER_ADDED_INT("minNumTimeoutDebrisPieces", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("clearColor", 0.530000f,0.550000f,0.610000f,1.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("enableSSAO", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("enableBloom", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("keepSkinningData", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("enableHwSkinning", 0)
    HK_PATCH_MEMBER_ADDED_REAL("fogDensity", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("addFloor", 0)
    HK_PATCH_MEMBER_ADDED_CSTRING("skyBoxName", HK_NULL)
    HK_PATCH_MEMBER_ADDED_BYTE("createSharedVertexBuffer", 1)
    HK_PATCH_MEMBER_ADDED_REAL("simplyfierPercentToRemove", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("enableInstancing", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndMeshSimplifierAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_INT("maxNumberOfTriangles", 1000)
    HK_PATCH_MEMBER_ADDED_REAL("preferChildSimplification", 0.000000f)
    HK_PATCH_MEMBER_ADDED_INT("minNumberOfTrianglesPerShape", 4)
    HK_PATCH_MEMBER_ADDED_BYTE("allowRemovingShapes", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("allowNonManifoldGeom", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("avoidGaps", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("allowRootShapeSimplification", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("enableCoplanarMerge", 1)
    HK_PATCH_MEMBER_ADDED_REAL("maxCoplanarError", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("defaultTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("positionTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("angularTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("normalsTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("texCoordsTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_REAL("colorTolerance", 0.000001f)
    HK_PATCH_MEMBER_ADDED_BYTE("preserveBoundaries", 1)
    HK_PATCH_MEMBER_ADDED_REAL("boundaryTolerance", 0.000010f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExplosionRuntimeShockWave", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateCornerInfoContainer", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("infos", TYPE_ARRAY_OBJECT, "hkndDecorateCornerInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndInfo", 0)
    HK_PATCH_DEPENDS("hkndDecorateCornerInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndGlueFixedPiecesAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_REAL("allowedVolumeIncrease", 0.050000f)
    HK_PATCH_MEMBER_ADDED_REAL("minEdgeLength", 0.005000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndPieFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitCentralAxis", 0.000000f,1.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitCenter", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_INT("numParts", 8)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateCornerInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndInfo")
    HK_PATCH_MEMBER_ADDED_BYTE("enableCornerDecorations", 1)
    HK_PATCH_MEMBER_ADDED("cornerTemplates", TYPE_STRUCT, "hkndDecorateFractureFaceActionCornerDecorationInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceActionCornerDecorationInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSplitByPhysicsIslandsMethod", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSplitInHalfFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("numChildren", 4)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntimeDecorationId", 0)
    HK_PATCH_MEMBER_ADDED("hierarchy", TYPE_OBJECT, "hkndHierarchy", 0)
    HK_PATCH_MEMBER_ADDED("pieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndHierarchy", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDynamicFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("fracture", TYPE_OBJECT, "hkndFracture", 0)
    HK_PATCH_MEMBER_ADDED("destructionData", TYPE_OBJECT, "hkndDestructionSystemData", 0)
    HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("fractureEngine", TYPE_OBJECT, "hkndFractureEngine", 0)
    HK_PATCH_DEPENDS("hkndFractureEngine", 0)
    HK_PATCH_DEPENDS("hkndDestructionSystemData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndGeometry", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("triangles", TYPE_ARRAY_STRUCT, "hkndGeometryTriangle", 0)
    HK_PATCH_MEMBER_ADDED("triSources", TYPE_ARRAY_STRUCT, "hkndGeometryTriangleSource", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndGeometryTriangle", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndGeometryTriangleSource", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingUnit")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSliceFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("splittingPlaneNormal", 0.000000f,1.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("numSubparts", 2.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("snap", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndMeshOptimizerInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndInfo")
    HK_PATCH_MEMBER_ADDED_BYTE("optimizationType", 1)
    HK_PATCH_MEMBER_ADDED_INT("numBonesPerSection", 70)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebugGraphicsTriangle", 0)
    HK_PATCH_MEMBER_ADDED("a", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("b", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("c", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("color", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecalMapActionDecalMapData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("decals", TYPE_ARRAY_STRUCT, "hkndDecalMapActionDecalMap", 0)
    HK_PATCH_MEMBER_ADDED("decors", TYPE_ARRAY_STRUCT, "hkndDecalMapActionDecalMap", 0)
    HK_PATCH_MEMBER_ADDED("decorInfo", TYPE_ARRAY_STRUCT, "hkndDecalMapActionDecorMapInfo", 0)
    HK_PATCH_MEMBER_ADDED("hDecorInstance", TYPE_OBJECT, "hkndHierarchyInstance", 0)
    HK_PATCH_MEMBER_ADDED("bodyFromDecoration", TYPE_STRUCT, "hkQTransform", 0)
    HK_PATCH_MEMBER_ADDED("decorMapBaseIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkndHierarchyInstance", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndDecalMapActionDecorMapInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDecalMapActionDecalMap", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndWoodFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED_INT("randomSeed", 187)
    HK_PATCH_MEMBER_ADDED("boardData", TYPE_STRUCT, "hkndWoodFractureSplittingData", 0)
    HK_PATCH_MEMBER_ADDED("splinterData", TYPE_STRUCT, "hkndWoodFractureSplittingData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndWoodFractureSplittingData", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndRandomSplitFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("splitLargestVolumesFirst", 1)
    HK_PATCH_MEMBER_ADDED_INT("numObjectsOnLevel1", 2)
    HK_PATCH_MEMBER_ADDED_INT("numObjectsOnLevel2", 0)
    HK_PATCH_MEMBER_ADDED_INT("numObjectsOnLevel3", 0)
    HK_PATCH_MEMBER_ADDED_INT("numObjectsOnLevel4", 0)
    HK_PATCH_MEMBER_ADDED_INT("randomSeed1", 123)
    HK_PATCH_MEMBER_ADDED_INT("randomSeed2", 456)
    HK_PATCH_MEMBER_ADDED_INT("randomSeed3", 789)
    HK_PATCH_MEMBER_ADDED_INT("randomSeed4", 101112)
    HK_PATCH_MEMBER_ADDED_REAL("randomRange", 1.000000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecalMapActionDecorMapInfo", 0)
    HK_PATCH_MEMBER_ADDED("intersectingMaps", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebugGraphicsLine", 0)
    HK_PATCH_MEMBER_ADDED("start", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("end", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("color", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebrisFractureInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndInfo")
    HK_PATCH_MEMBER_ADDED("info0", TYPE_STRUCT, "hkndDebrisFractureInfoTemplateInfo", 0)
    HK_PATCH_MEMBER_ADDED("info1", TYPE_STRUCT, "hkndDebrisFractureInfoTemplateInfo", 0)
    HK_PATCH_MEMBER_ADDED("info2", TYPE_STRUCT, "hkndDebrisFractureInfoTemplateInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDebrisFractureInfoTemplateInfo", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndActionDataBlock", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingDataBlock")
    HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingDataBlock", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExplosionForceAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_VEC_4("explosionCenter", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("velocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("expandingVelocity", 20.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("virtMass", 1000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("angularImpulseFactor", 0.200000f)
    HK_PATCH_MEMBER_ADDED_BYTE("explosionCenterSpace", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingUnit")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExactFractureEngine", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFractureEngine")
    HK_PATCH_MEMBER_ADDED("coordinateConversionAabb", TYPE_STRUCT, "hkAabb", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkAabb", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndFractureEngine", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndInfo")
    HK_PATCH_MEMBER_ADDED_BYTE("enableDecorations", 1)
    HK_PATCH_MEMBER_ADDED_INT("priority", 1)
    HK_PATCH_MEMBER_ADDED("decorations", TYPE_STRUCT, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndInfo", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceActionCornerDecorationInfo", 0)
    HK_PATCH_MEMBER_ADDED("decorationsProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("minimumDistance", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maximumVerticalShift", 0.000010f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShareVerticesAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_INT("maxNumVerticesPerBuffer", 65535)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndVoronoiFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("copyDataFromSites", 1)
    HK_PATCH_MEMBER_ADDED("voronoiSitesProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("numSitesToGenerate", 0)
    HK_PATCH_MEMBER_ADDED_INT("numIterations", 0)
    HK_PATCH_MEMBER_ADDED_INT("seed", 180673)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFractureEngine", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("minShapeVolumeAfterSplit", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minShapeThicknessAfterSplit", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minDistForSplitByPhysicsShape", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("minConnectionArea", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndGeometryTriangleSource", 0)
    HK_PATCH_MEMBER_ADDED("geometryFromSource", TYPE_VEC_16, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("name", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("startMaterialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numMaterials", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("isInverted", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_BYTE("decorateWhat", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("decorationPivot", 1)
    HK_PATCH_MEMBER_ADDED_VEC_4("upDir", 0.000000f,1.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("alignDecorations", 0)
    HK_PATCH_MEMBER_ADDED("controlShapesProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("minFractureLength", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("linearTolerance", 0.000100f)
    HK_PATCH_MEMBER_ADDED_REAL("angularTolerance", 0.000100f)
    HK_PATCH_MEMBER_ADDED_BYTE("decorationsStorage", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("keepFixedDecorations", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("protrusionTest", 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxProtrusion", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("fixupDistance", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("equalizeGaps", 1)
    HK_PATCH_MEMBER_ADDED_REAL("vertGridDist", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("vertGridOffset", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("horGridDist", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("horGridOffset", 0.000000f)
    HK_PATCH_MEMBER_ADDED("top", TYPE_STRUCT, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_MEMBER_ADDED("bottom", TYPE_STRUCT, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_MEMBER_ADDED("side", TYPE_STRUCT, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_MEMBER_ADDED("flat", TYPE_STRUCT, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_MEMBER_ADDED("corner", TYPE_STRUCT, "hkndDecorateFractureFaceActionCornerDecorationInfo", 0)
    HK_PATCH_MEMBER_ADDED_INT("numCornerDecorationAttempts", -1)
    HK_PATCH_MEMBER_ADDED_REAL("borderOverlap", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("forceBorderOnEdges", 0)
    HK_PATCH_MEMBER_ADDED_REAL("maxAngleBetweenEdges", 6.283185f)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceActionCornerDecorationInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSplitByPhysicsIslandsAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_BYTE("splitMethod", 0)
    HK_PATCH_MEMBER_ADDED_REAL("distanceForConnection", 0.050000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceActionFractureFaceInfo", 0)
    HK_PATCH_MEMBER_ADDED("decorationsProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("density", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("gap", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("spinAngle", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("randomSpinAngle", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("allowRandomFlipX", 0)
    HK_PATCH_MEMBER_ADDED_REAL("xShift", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("xRandomShift", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntimeConnectionDecorationInfo", 0)
    HK_PATCH_MEMBER_ADDED("otherShapeId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("startIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("numDecorations", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExplosionRuntime", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndAssetProcessingDataBlock", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndBodyTimeoutRuntime", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDebugGraphicsText", 0)
    HK_PATCH_MEMBER_ADDED("pos", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("string", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("color", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExplosionRuntimeExplosion", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndExplosionRuntimeExplosionCinfo")
    HK_PATCH_MEMBER_ADDED("time", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkndExplosionRuntimeExplosionCinfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndRemoveWeakConnectionsAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_REAL("minRelativeArea", 0.100000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecomposeFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("shiftToSmallerCrossSection", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("clipZoneWidth", 0.300000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFlattenHierarchyAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndCutOutFracture", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndFracture")
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("setFrameShapeFixed", 1)
    HK_PATCH_MEMBER_ADDED_REAL("minPhysicsThickness", 0.010000f)
    HK_PATCH_MEMBER_ADDED_REAL("minimumOverlap", 0.050000f)
    HK_PATCH_MEMBER_ADDED_REAL("expandShape", 0.001000f)
    HK_PATCH_MEMBER_ADDED("cutoutShapesProviderId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("copyDataFromCutouts", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("splitType", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndFracture", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndAssetProcessingUnit", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntimeGlobalDecorationData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("templates", TYPE_ARRAY_STRUCT, "hkndDecorateFractureFaceRuntimeDecorationId", 0)
    HK_PATCH_MEMBER_ADDED("boundingBoxes", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rawTransforms", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
    HK_PATCH_MEMBER_ADDED("halfTransforms", TYPE_ARRAY_STRUCT, "hkFloat16Transform", 0)
    HK_PATCH_MEMBER_ADDED("compressedPlacements", TYPE_ARRAY_STRUCT, "hkndDecorateFractureFaceRuntimeCompressedDecorationPlacement", 0)
    HK_PATCH_MEMBER_ADDED("indexBuffer", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("graphicsRanges", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_BYTE("compressionType", 0)
    HK_PATCH_DEPENDS("hkFloat16Transform", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceRuntimeCompressedDecorationPlacement", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDecorateFractureFaceRuntimeDecorationId", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndShockWaveAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED("center", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_REAL("initialRadius", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxRadius", 100.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("thickness", 10.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("triggerType", 0)
    HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 0)
    HK_PATCH_MEMBER_ADDED_REAL("expandingVelocity", 30.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("damageMultiplier", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("virtualMass", 100000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("appliedVelocity", 100.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("forceFallOff", 1.400000f)
    HK_PATCH_MEMBER_ADDED_REAL("relCounterForce", 0.500000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntimeCompressedDecorationPlacement", 0)
    HK_PATCH_MEMBER_ADDED("boundingBoxIdx", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("pos", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rot", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndExplosionRuntimeExplosionCinfo", 0)
    HK_PATCH_MEMBER_ADDED("position", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("velocity", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("virtMass", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("maxRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("lifetime", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndConvexDecompositionAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_REAL("tolerance", 0.010000f)
    HK_PATCH_MEMBER_ADDED_BYTE("method", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("reduce", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("refine", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("self", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("recurse", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("hollow", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("splitMethod", 0)
    HK_PATCH_MEMBER_ADDED_REAL("minVolume", 0.000010f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecalMapAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_INT("xResolution", 64)
    HK_PATCH_MEMBER_ADDED_INT("yResolution", 64)
    HK_PATCH_MEMBER_ADDED_INT("uvChannel", 0)
    HK_PATCH_MEMBER_ADDED_REAL("extraRadius", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("softRadius", 1.000000f)
    HK_PATCH_MEMBER_ADDED("decorationBodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED_INT("xResolutionDecoration", 64)
    HK_PATCH_MEMBER_ADDED_INT("yResolutionDecoration", 64)
    HK_PATCH_MEMBER_ADDED_INT("uvChannelDecoration", 0)
    HK_PATCH_MEMBER_ADDED_REAL("extraRadiusDecoration", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("softRadiusDecoration", 1.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("enableDebugBitmapGeneration", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndWoodFractureSplittingData", 0)
    HK_PATCH_MEMBER_ADDED("splitPlaneGeometry", TYPE_OBJECT, "hkndSplittingPlane", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("splitGeometryScale", 1.000000f,1.000000f,1.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("splittingAxis", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("rotateSplitGeom", 0)
    HK_PATCH_MEMBER_ADDED_REAL("numSubparts", 3.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("widthRange", 0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("scaleRange", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("splitGeomShiftRangeY", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("splitGeomShiftRangeZ", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("surfaceNormalShearingRange", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("fractureLineShearingRange", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("fractureNormalShearingRange", 0.000000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndSplittingPlane", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceRuntime", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator", 0)
    HK_PATCH_MEMBER_ADDED("offset", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("words", TYPE_ARRAY_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSerializableArrayBitField", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator")
    HK_PATCH_DEPENDS("hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndBreakableBodySnapshot", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("worldFromBody", TYPE_STRUCT, "hkQTransform", 0)
    HK_PATCH_MEMBER_ADDED_VEC_4("linearVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED_VEC_4("angularVelocity", 0.000000f,0.000000f,0.000000f,0.000000f)
    HK_PATCH_MEMBER_ADDED("enabledPieces", TYPE_STRUCT, "hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator", 0)
    HK_PATCH_MEMBER_ADDED("enabledConnections", TYPE_STRUCT, "hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator", 0)
    HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rootPieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("breakableBodyFlags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rigidBodyFlags", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndBitFieldhkArrayunsignedinthkContainerHeapAllocator", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDeformableBodySnapshot", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndBreakableBodySnapshot")
    HK_PATCH_MEMBER_ADDED("hierarchyFromPieceTransforms", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndBreakableBodySnapshot", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndControllerProcessor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingUnit")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndControllerProcessorDataBlock", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAssetProcessingDataBlock")
    HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingDataBlock", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndFlexibleJointProcessor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndControllerProcessor")
    HK_PATCH_MEMBER_ADDED_REAL("coneAngle", 20.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("twistAngle", 20.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("planeAngle", 3.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("relBendingStrength", 20.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("limitStiffness", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("relBreakingStrength", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("relPullingStrength", 1000.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxConnectionDistance", 0.050000f)
    HK_PATCH_MEMBER_ADDED_BYTE("connectToType", 1)
    HK_PATCH_MEMBER_ADDED_BYTE("dropConstraintOnBreakage", 0)
    HK_PATCH_MEMBER_ADDED_REAL("inertiaMultiplier", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxInertiaRatio", 10.000000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndControllerProcessor", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndWoodProcessor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndControllerProcessor")
    HK_PATCH_MEMBER_ADDED_REAL("deformationFriction", 0.500000f)
    HK_PATCH_MEMBER_ADDED_REAL("deformationStrength", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxDeformationDistance", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxDeformationAngle", 10.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("applyDeformationOnAllObjects", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndControllerProcessor", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndBuildingProcessor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndControllerProcessor")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndControllerProcessor", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSetRigidBodyPropertiesModifierData", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("materialId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("motionPropertiesId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("destructionData", TYPE_OBJECT, "hkndDestructionSystemData", 0)
    HK_PATCH_MEMBER_ADDED("mass", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("inertiaFactor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("collisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("flags", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndDestructionSystemData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndSetRigidBodyPropertiesAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 0)
    HK_PATCH_MEMBER_ADDED_REAL("gravityFactor", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("inertiaFactor", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("linearDamping", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("angularDamping", 0.500000f)
    HK_PATCH_MEMBER_ADDED_REAL("mass", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("friction", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("restitution", 0.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("setCollisionFilter", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("setDamping", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("setMass", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("setFriction", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("setRestitution", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("setDeactivation", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("enableDeactivation", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndIntegrityAnalyzerAction", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndAction")
    HK_PATCH_MEMBER_ADDED_REAL("breakingLength", 8.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("fracturePosition", 0.400000f)
    HK_PATCH_MEMBER_ADDED_REAL("destructionRadius", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("delay", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("refineRadius", 0.000000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
    HK_PATCH_DEPENDS("hkndAction", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDeformableShapeGroup", 0)
    HK_PATCH_MEMBER_ADDED("boneBufferStart", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("boneBufferLength", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("indexBufferStart", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("indexBufferLength", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDeformableShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndShape")
    HK_PATCH_MEMBER_ADDED("groups", TYPE_ARRAY_STRUCT, "hkndDeformableShapeGroup", 0)
    HK_PATCH_MEMBER_ADDED("boneIds", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("vertices", TYPE_ARRAY_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("boneIndices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("invBindPose", TYPE_ARRAY_STRUCT, "hkQTransform", 0)
    HK_PATCH_MEMBER_ADDED("indexBuffer", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("convexRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("deformablePieceId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndDeformableShapeGroup", 0)
    HK_PATCH_DEPENDS("hkndShape", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkQTransform", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndStaticShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndShapeInstance")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkndShapeInstance", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDeformationProcessor", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkndControllerProcessor")
    HK_PATCH_MEMBER_ADDED_REAL("deformationRadius", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("deformationStrength", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("constraintStrength", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("constraintBreakingLimit", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("softness", 0.600000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxDeformationDistance", 10.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maxDeformationAngle", 90.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("deformationTau", 1.000000f)
    HK_PATCH_MEMBER_ADDED_BYTE("skiningType", 2)
    HK_PATCH_MEMBER_ADDED_REAL("skinningSmoothing", 0.300000f)
    HK_PATCH_MEMBER_ADDED_REAL("hullTolerance", 0.001000f)
    HK_PATCH_MEMBER_ADDED_REAL("shapeWeldingTolerance", 0.010000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkndControllerProcessor", 0)
    HK_PATCH_DEPENDS("hkndAssetProcessingUnit", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceActionGeomShape", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkndDecorateFractureFaceActionGeomSource", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpExternMeshShapeMesh")
    HK_PATCH_MEMBER_ADDED("geom", TYPE_OBJECT, "hkndGeometry", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hknpExternMeshShapeMesh", 0)
    HK_PATCH_DEPENDS("hkndGeometry", 0)
HK_PATCH_END()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
