// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Behavior specific product patches applied to release 2012_2.
// This file is #included by hkbPatches_2012_2.cpp

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbProceduralBlenderGenerator", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbGenerator")
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbGenerator", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbProceduralBlenderGenerator", 0, "hkbProceduralBlenderGenerator", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbParametricMotionGenerator", 1, "hkbParametricMotionGenerator", 2)
    HK_PATCH_PARENT_SET("hkbGenerator", "hkbProceduralBlenderGenerator")
    HK_PATCH_DEPENDS("hkbGenerator", 0)
    HK_PATCH_DEPENDS("hkbProceduralBlenderGenerator", 1)
HK_PATCH_END()

//////////////////////////////////////////////////////////////////////////
// New Physics interface/implementation specific classes
//////////////////////////////////////////////////////////////////////////

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbConstraintSetup", 0)
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRagdollControllerSetup", 0)
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbShapeSetup", 0)
    HK_PATCH_MEMBER_ADDED_REAL("capsuleHeight", 1.7f)
    HK_PATCH_MEMBER_ADDED_REAL("capsuleRadius", 0.4f)
    HK_PATCH_MEMBER_ADDED("fileName", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRigidBodySetup", 0)
    HK_PATCH_MEMBER_ADDED_INT("collisionFilterInfo", 1)
    HK_PATCH_MEMBER_ADDED("type", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("shapeSetup", TYPE_STRUCT, "hkbShapeSetup", 0)
    HK_PATCH_DEPENDS("hkbShapeSetup", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbCharacterControllerSetup", 0)
    HK_PATCH_MEMBER_ADDED("rigidBodySetup", TYPE_STRUCT, "hkbRigidBodySetup", 0)
    HK_PATCH_MEMBER_ADDED("controllerCinfo", TYPE_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkbRigidBodySetup", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbRagdollInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbPhysicsInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbNullPhysicsInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbPhysicsInterface")
    HK_PATCH_DEPENDS("hkbPhysicsInterface", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbKeyFrameControlData", 0)
    HK_PATCH_MEMBER_ADDED_REAL("hierarchyGain", 0.170000f)
    HK_PATCH_MEMBER_ADDED_REAL("velocityDamping", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("accelerationGain", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("velocityGain", 0.600000f)
    HK_PATCH_MEMBER_ADDED_REAL("positionGain", 0.050000f)
    HK_PATCH_MEMBER_ADDED_REAL("positionMaxLinearVelocity", 1.400000f)
    HK_PATCH_MEMBER_ADDED_REAL("positionMaxAngularVelocity", 1.800000f)
    HK_PATCH_MEMBER_ADDED_REAL("snapGain", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("snapMaxLinearVelocity", 0.300000f)
    HK_PATCH_MEMBER_ADDED_REAL("snapMaxAngularVelocity", 0.300000f)
    HK_PATCH_MEMBER_ADDED_REAL("snapMaxLinearDistance", 0.030000f)
    HK_PATCH_MEMBER_ADDED_REAL("snapMaxAngularDistance", 0.100000f)
HK_PATCH_END()


HK_PATCH_BEGIN("hkbCharacterData", 9, "hkbCharacterData", 10)
    HK_PATCH_MEMBER_ADDED("characterControllerSetup", TYPE_STRUCT, "hkbCharacterControllerSetup", 0)
    HK_PATCH_FUNCTION(hkbCharacterData_9_to_10)
    HK_PATCH_MEMBER_REMOVED("characterControllerInfo", TYPE_STRUCT, "hkbCharacterDataCharacterControllerInfo", 0)
    HK_PATCH_DEPENDS("hkbCharacterControllerSetup", 0)
    HK_PATCH_DEPENDS("hkbRigidBodySetup", 0)
    HK_PATCH_DEPENDS("hkbCharacterDataCharacterControllerInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbRigidBodyRagdollControlData", 1, "hkbRigidBodyRagdollControlData", 2)
    HK_PATCH_MEMBER_ADDED("keyFrameControlData", TYPE_STRUCT, "hkbKeyFrameControlData", 0)
    HK_PATCH_FUNCTION(hkbRigidBodyRagdollControlData_1_to_2)
    HK_PATCH_MEMBER_REMOVED("keyFrameHierarchyControlData", TYPE_STRUCT, "hkaKeyFrameHierarchyUtilityControlData", 0)
    HK_PATCH_DEPENDS("hkaKeyFrameHierarchyUtilityControlData", 0)
    HK_PATCH_DEPENDS("hkbKeyFrameControlData", 0)
HK_PATCH_END()

#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbpRagdollInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbRagdollInterface")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbRagdollInterface", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbpPhysicsInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbPhysicsInterface")
    HK_PATCH_DEPENDS("hkbPhysicsInterface", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#endif

#if defined(HK_FEATURE_PRODUCT_PHYSICS)

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbnpRagdollInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbRagdollInterface")
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbRagdollInterface", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbnpPhysicsInterface", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbPhysicsInterface")
    HK_PATCH_DEPENDS("hkbPhysicsInterface", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#endif

//////////////////////////////////////////////////////////////////////////
// Renamed deprecated Physics implementation specific classes / old dependency clean-up
//////////////////////////////////////////////////////////////////////////

HK_PATCH_BEGIN("hkbCustomTestGenerator", 0, "hkbCustomTestGenerator", 1)
    HK_PATCH_MEMBER_REMOVED("hkRigidBody", TYPE_OBJECT, "hkpRigidBody", 0)
    
    HK_PATCH_MEMBER_ADDED_POINTER("hkRigidBody", "hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpRigidBody", 0)
    HK_PATCH_DEPENDS("hkpEntity", 3)
    HK_PATCH_DEPENDS("hkpWorldObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbHandle", 1, "hkbHandle", 2)
    HK_PATCH_MEMBER_REMOVED("rigidBody", TYPE_OBJECT, "hkpRigidBody", 0)
    
    HK_PATCH_MEMBER_ADDED_POINTER("rigidBody", "hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpRigidBody", 0)
    HK_PATCH_DEPENDS("hkpEntity", 3)
    HK_PATCH_DEPENDS("hkpWorldObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()


HK_PATCH_BEGIN("hkbCharacterDataCharacterControllerInfo", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("capsuleHeight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("capsuleRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("collisionFilterInfo", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("characterControllerCinfo", TYPE_OBJECT, "hkpCharacterControllerCinfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpCharacterControllerCinfo", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#if defined(HK_FEATURE_PRODUCT_PHYSICS_2012)

HK_PATCH_BEGIN("hkbTarget", 2, "hkbpTarget", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTargetRigidBodyModifier", 3, "hkbpTargetRigidBodyModifier", 4)
    HK_PATCH_DEPENDS("hkbpTarget", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifierHand", 1, "hkbpReachTowardTargetModifierHand", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifier", 1, "hkbpReachTowardTargetModifier", 2)
    HK_PATCH_DEPENDS("hkbpTarget", 3)
    HK_PATCH_DEPENDS("hkbpReachTowardTargetModifierHand", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachModifierHand", 0, "hkbpReachModifierHand", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachModifier", 0, "hkbpReachModifier", 1)
    HK_PATCH_DEPENDS("hkbpReachModifierHand", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbMoveBoneTowardTargetModifier", 2, "hkbpMoveBoneTowardTargetModifier", 3)
    HK_PATCH_DEPENDS("hkbpTarget", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFaceTargetModifier", 1, "hkbpFaceTargetModifier", 2)
    HK_PATCH_DEPENDS("hkbpTarget", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbControlledReachModifier", 0, "hkbpControlledReachModifier", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbConstrainRigidBodyModifier", 1, "hkbpConstrainRigidBodyModifier", 2)
    HK_PATCH_DEPENDS("hkbpTarget", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCheckRagdollSpeedModifier", 1, "hkbpCheckRagdollSpeedModifier", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCheckBalanceModifier", 0, "hkbpCheckBalanceModifier", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceModifierStepInfo", 0, "hkbpBalanceModifierStepInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceModifier", 0, "hkbpBalanceModifier", 1)
    HK_PATCH_DEPENDS("hkbpBalanceModifierStepInfo", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifierHand", 1, "hkbpCatchFallModifierHand", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifier", 1, "hkbpCatchFallModifier", 2)
    HK_PATCH_DEPENDS("hkbpCatchFallModifierHand", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceRadialSelectorGenerator", 0, "hkbpBalanceRadialSelectorGenerator", 1)
    HK_PATCH_DEPENDS("hkbpCheckBalanceModifier", 1)
HK_PATCH_END()

#else
// Else we need to delete these
HK_PATCH_BEGIN("hkbTarget", 2, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
    HK_PATCH_DEPENDS("hkReferencedObject", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbTargetRigidBodyModifier", 3, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("isCloseToTargetOut", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetOut", TYPE_OBJECT, "hkbTarget", 0)
    HK_PATCH_MEMBER_REMOVED("closeToTargetEvent", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("eventToSendToTarget", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("eventToSend", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("targetPriority", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetOnlySpheres", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useVelocityPrediction", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensorInWS", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensingPropertyKey", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("eventMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensorDirectionBS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("closeToTargetOffsetInBoneSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensorOffsetInBoneSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("closeToTargetAnimationBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("closeToTargetRagdollBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensorAnimationBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensorRagdollBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxAngleToTarget", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetDistanceMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetAngleMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("closeToTargetDistanceThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxTargetHeightAboveSensor", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxTargetDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ignoreMySystemGroup", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetOnlyOnce", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensingLayer", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbTarget", 2)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifierHand", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("isEnabled", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("shoulderIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachTowardTargetModifier", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("targetIn", TYPE_OBJECT, "hkbTarget", 0)
    HK_PATCH_MEMBER_REMOVED("giveUpIfNoTarget", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("reachPastTarget", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("holdTarget", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetChangeSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutDuration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutGainSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInGainSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("reachDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("distanceBetweenHands", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("rightHand", TYPE_STRUCT, "hkbReachTowardTargetModifierHand", 0)
    HK_PATCH_MEMBER_REMOVED("leftHand", TYPE_STRUCT, "hkbReachTowardTargetModifierHand", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbTarget", 2)
    HK_PATCH_DEPENDS("hkbReachTowardTargetModifierHand", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachModifierHand", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("handIkTrackIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("boneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensingRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetBackHandNormal", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetOrSensingPosition", TYPE_VEC_4, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbReachModifier", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("extrapolate", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ignoreMySystemGroup", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("reachMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("sensingPropertyKey", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("raycastLayer", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutDuration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetGain", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("noTargetGain", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("newTargetGain", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("hands", TYPE_ARRAY_STRUCT, "hkbReachModifierHand", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbReachModifierHand", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbMoveBoneTowardTargetModifier", 2, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("targetIn", TYPE_OBJECT, "hkbTarget", 0)
    HK_PATCH_MEMBER_REMOVED("eventToSendWhenTargetReached", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("useAnimationData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("accumulatedMotion", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("totalMotion", TYPE_VEC_12, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("animationFromRagdoll", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("finalAnimBoneOrientationMS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("initialAnimBonePositionMS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("finalAnimBonePositionMS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("currentBoneIsValidOut", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("affectOrientation", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useVelocityPrediction", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("alignMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetMode", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("animationBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("duration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("childGenerator", TYPE_OBJECT, "hkbGenerator", 0)
    HK_PATCH_MEMBER_REMOVED("currentBoneRotationOut", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("currentBonePositionOut", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("alignWithCharacterForwardBS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("targetAlignAxisTS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("alignAxisBS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("offsetInBoneSpace", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbTarget", 2)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
    HK_PATCH_DEPENDS("hkbGenerator", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbFaceTargetModifier", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("targetIn", TYPE_OBJECT, "hkbTarget", 0)
    HK_PATCH_MEMBER_REMOVED("onlyOnce", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("offsetAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbTarget", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbControlledReachModifier", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("isHandEnabled", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("handIndex", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("sensorAngle", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutDuration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutEnd", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutStart", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInEnd", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInStart", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbConstrainRigidBodyModifier", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("targetIn", TYPE_OBJECT, "hkbTarget", 0)
    HK_PATCH_MEMBER_REMOVED("isConstraintHinge", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("clearTargetData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("constraintType", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("boneToConstrainPlacement", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("pivotPlacement", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("breakable", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollBoneToConstrain", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("breakThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbTarget", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCheckRagdollSpeedModifier", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("eventToSend", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("maxSpeedThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minSpeedThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCheckBalanceModifier", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("extractRagdollPose", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("comBiasX", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("worldUpAxisIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("offBalanceEventThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("eventToSendWhenOffBalance", TYPE_STRUCT, "hkbEvent", 0)
    HK_PATCH_MEMBER_REMOVED("balanceOnAnklesFraction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollRightFootBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollLeftFootBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbEvent", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceModifierStepInfo", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("fractionOfSolution", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("boneIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceModifier", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("stepInfo", TYPE_ARRAY_STRUCT, "hkbBalanceModifierStepInfo", 0)
    HK_PATCH_MEMBER_REMOVED("comBiasX", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInTime", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("upAxis", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("balanceOnAnklesFraction", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollRightFootBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollLeftFootBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("passThrough", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("comDistThreshold", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("giveUp", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbBalanceModifierStepInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifierHand", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("ragdollAnkleIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollShoulderIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("animShoulderIndex", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCatchFallModifier", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbModifier", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("catchFallDoneEvent", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_REMOVED("spineIndices", TYPE_OBJECT, "hkbBoneIndexArray", 0)
    HK_PATCH_MEMBER_REMOVED("catchFallPosIsValid", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("currentTwistDirection", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("currentTwistGain", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("timeSinceLastModify", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("currentReachGain", TYPE_TUPLE_REAL, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("catchFallPosInBS", TYPE_TUPLE_VEC_4, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("orientHands", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("directionOfFallRagdollBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("velocityRagdollBoneIndex", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("raycastLayer", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutTwistSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInTwistSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutDuration", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeOutReachGainSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("fadeInReachGainSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxReachDistanceBackward", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxReachDistanceForward", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("handsBendDistance", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("previousTargetBlendWeight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("radarRange", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("spreadHandsMultiplier", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("rightHand", TYPE_STRUCT, "hkbCatchFallModifierHand", 0)
    HK_PATCH_MEMBER_REMOVED("leftHand", TYPE_STRUCT, "hkbCatchFallModifierHand", 0)
    HK_PATCH_MEMBER_REMOVED("directionOfFallUpLS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("directionOfFallRightLS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("directionOfFallForwardLS", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
    HK_PATCH_DEPENDS("hkbBoneIndexArray", 0)
    HK_PATCH_DEPENDS("hkbCatchFallModifierHand", 1)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbBalanceRadialSelectorGenerator", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkbRadialSelectorGenerator", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("checkBalanceModifier", TYPE_OBJECT, "hkbCheckBalanceModifier", 0)
    HK_PATCH_MEMBER_REMOVED("yAxisMS", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("xAxisMS", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkbRadialSelectorGenerator", 0)
    HK_PATCH_DEPENDS("hkbCheckBalanceModifier", 0)
HK_PATCH_END()

#endif

//////////////////////////////////////////////////////////////////////////
// New Ai interface/implementation specific classes
//////////////////////////////////////////////////////////////////////////

// control data

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlControlDataNonBlendable", 0)
    HK_PATCH_MEMBER_ADDED_BYTE("canControl", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlControlData", 0)
    HK_PATCH_MEMBER_ADDED("blendable", TYPE_STRUCT, "hkbAiControlControlDataBlendable", 0)
    HK_PATCH_MEMBER_ADDED("nonBlendable", TYPE_STRUCT, "hkbAiControlControlDataNonBlendable", 0)
    HK_PATCH_DEPENDS("hkbAiControlControlDataBlendable", 0)
    HK_PATCH_DEPENDS("hkbAiControlControlDataNonBlendable", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlControlDataBlendable", 0)
    HK_PATCH_MEMBER_ADDED_REAL("desiredSpeed", 5.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("maximumSpeed", 5.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbCharacterData", 8, "hkbCharacterData", 9)
    HK_PATCH_MEMBER_ADDED("aiControlDriverInfo", TYPE_OBJECT, "hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

// commands

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlCancelPathCommand", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlPathToCommand", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("characterId", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("goalPoint", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#if defined(HK_FEATURE_PRODUCT_AI)

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlDriverInfo", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED_REAL("radius", 0.400000f)
    HK_PATCH_MEMBER_ADDED_INT("stateSource", 0)
    HK_PATCH_MEMBER_ADDED_INT("customSourceBone", -1)
    HK_PATCH_MEMBER_ADDED_BYTE("loopBackVelocity", 0)
    HK_PATCH_MEMBER_ADDED_REAL("sensorHorizontalExtent", 5.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("sensorHeight", 2.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("wallFollowingAngle", 0.100000f)
    HK_PATCH_MEMBER_ADDED_REAL("velocityHysteresis", 0.010000f)
    HK_PATCH_MEMBER_ADDED_REAL("sidednessChangingPenalty", 0.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("collisionPenalty", 1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("penetrationPenalty", 100.000000f)
    HK_PATCH_MEMBER_ADDED_INT("maxNeighbors", 16)
    HK_PATCH_MEMBER_ADDED_REAL("leftTurnRadius", -1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("rightTurnRadius", -1.000000f)
    HK_PATCH_MEMBER_ADDED_REAL("goalDistTolerance", 0.250000f)
    HK_PATCH_MEMBER_ADDED_REAL("userEdgeTolerance", 0.250000f)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiControlModifier", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
    HK_PATCH_MEMBER_ADDED("controlData", TYPE_STRUCT, "hkbAiControlControlData", 0)
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkbAiControlControlData", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierSteeringInfo", 0)
    HK_PATCH_MEMBER_ADDED("requestedVelocity", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("forwardSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("rightSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("totalSpeed", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("localAngle", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifier", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkbModifier")
    HK_PATCH_MEMBER_ADDED("steeringInfo", TYPE_STRUCT, "hkbAiSteeringModifierSteeringInfo", 0)
    HK_PATCH_MEMBER_ADDED("userEdgeInfo", TYPE_STRUCT, "hkbAiSteeringModifierUserEdgeInfo", 0)
    HK_PATCH_MEMBER_ADDED("eventMapping", TYPE_STRUCT, "hkbAiSteeringModifierEventMapping", 0)
    HK_PATCH_MEMBER_ADDED("defaultControlData", TYPE_STRUCT, "hkbAiControlControlData", 0)
    HK_PATCH_DEPENDS("hkbAiControlControlData", 0)
    HK_PATCH_DEPENDS("hkbNode", 1)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbAiSteeringModifierEventMapping", 0)
    HK_PATCH_DEPENDS("hkbAiSteeringModifierUserEdgeInfo", 0)
    HK_PATCH_DEPENDS("hkbModifier", 0)
    HK_PATCH_DEPENDS("hkbBindable", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkbAiSteeringModifierSteeringInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierUserEdgeEvent", 0)
    HK_PATCH_MEMBER_ADDED_INT("userdataId", 0)
    HK_PATCH_MEMBER_ADDED_INT("userdataMask", 0xFFFFFFFF)
    HK_PATCH_MEMBER_ADDED("event", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
    HK_PATCH_DEPENDS("hkbEventBase", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierEventMapping", 0)
    HK_PATCH_MEMBER_ADDED("startPath", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_ADDED("goalReached", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_ADDED("pathCancelled", TYPE_STRUCT, "hkbEventProperty", 0)
    HK_PATCH_MEMBER_ADDED("userEdgeEvents", TYPE_ARRAY_STRUCT, "hkbAiSteeringModifierUserEdgeEvent", 0)
    HK_PATCH_DEPENDS("hkbEventProperty", 1)
    HK_PATCH_DEPENDS("hkbAiSteeringModifierUserEdgeEvent", 0)
    HK_PATCH_DEPENDS("hkbEventBase", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierInternalState", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
    HK_PATCH_MEMBER_ADDED("requestedVelocityInternal", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("hasLastUserEdgeEntry", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("lastUserEdgeEntry", TYPE_STRUCT, "hkbAiSteeringModifierInternalUserEdgeInfo", 0)
    HK_PATCH_DEPENDS("hkbAiSteeringModifierInternalUserEdgeInfo", 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierUserEdgeInfo", 0)
    HK_PATCH_MEMBER_ADDED("hasEntryInfoOut", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryUserDataOut", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryPointOut", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("exitPointOut", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryEdgeDirection", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("exitEdgeDirection", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("localAngleToExitPointOut", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("localAngleToTraversalDirectionOut", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkbAiSteeringModifierInternalUserEdgeInfo", 0)
    HK_PATCH_MEMBER_ADDED("entrySection", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryPoint", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryData", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("oppositeSection", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("entryEdgeDirection", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("edgeTransform", TYPE_VEC_16, HK_NULL, 0)
HK_PATCH_END()

#endif

//////////////////////////////////////////////////////////////////////////
// Demo or Test Related
//////////////////////////////////////////////////////////////////////////

HK_PATCH_BEGIN("hkbDemoConfigStickVariableInfo", 1, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("variableName", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minValue", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxValue", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("minStickValue", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("maxStickValue", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("stickAxis", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("stick", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("complimentVariableValue", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("negateVariableValue", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigCharacterInfo", 3, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("overrideCharacterDataFilename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("initialPosition", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("initialRotation", TYPE_VEC_4, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("modelUpAxis", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("ragdollBoneLayers", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("overrideBehaviorFilename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfig", 5, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_PARENT_SET("hkReferencedObject", HK_NULL)
    HK_PATCH_MEMBER_REMOVED("characterInfo", TYPE_ARRAY_OBJECT, "hkbDemoConfigCharacterInfo", 0)
    HK_PATCH_MEMBER_REMOVED("terrainInfo", TYPE_ARRAY_STRUCT, "hkbDemoConfigTerrainInfo", 0)
    HK_PATCH_MEMBER_REMOVED("skinAttributeIndices", TYPE_ARRAY_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("buttonPressToEventMap", TYPE_TUPLE_INT, HK_NULL, 16)
    HK_PATCH_MEMBER_REMOVED("buttonReleaseToEventMap", TYPE_TUPLE_INT, HK_NULL, 16)
    HK_PATCH_MEMBER_REMOVED("worldUpAxis", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("extraCharacterClones", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("numTracks", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("proxyHeight", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("proxyRadius", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("proxyOffset", TYPE_REAL, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("rootPath", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("projectDataFilename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useAttachments", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useProxy", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useSkyBox", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useTrackingCamera", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("accumulateMotion", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("testCloning", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("useSplineCompression", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("gamePadToRotateTerrainAboutItsAxisMap", TYPE_TUPLE_INT, HK_NULL, 6)
    HK_PATCH_MEMBER_REMOVED("gamePadToAddRemoveCharacterMap", TYPE_TUPLE_INT, HK_NULL, 2)
    HK_PATCH_MEMBER_REMOVED("filter", TYPE_OBJECT, "hkpGroupFilter", 0)
    HK_PATCH_MEMBER_REMOVED("stickVariables", TYPE_ARRAY_STRUCT, "hkbDemoConfigStickVariableInfo", 0)
    HK_PATCH_MEMBER_REMOVED("forceLoad", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkbDemoConfigCharacterInfo", 3)
    HK_PATCH_DEPENDS("hkbDemoConfigStickVariableInfo", 1)
    HK_PATCH_DEPENDS("hkpGroupFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
    HK_PATCH_DEPENDS("hkpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkbDemoConfigTerrainInfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkbDemoConfigTerrainInfo", 0, HK_NULL, HK_CLASS_REMOVED)
    HK_PATCH_MEMBER_REMOVED("filename", TYPE_CSTRING, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("layer", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("systemGroup", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("createDisplayObjects", TYPE_BYTE, HK_NULL, 0)
    HK_PATCH_MEMBER_REMOVED("terrainRigidBody", TYPE_OBJECT, "hkpRigidBody", 0)
    HK_PATCH_DEPENDS("hkpRigidBody", 0)
    HK_PATCH_DEPENDS("hkpEntity", 3)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hkpWorldObject", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

#if !defined(HK_FEATURE_PRODUCT_PHYSICS_2012)
// We need an empty definition here
HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpEntity", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkpEntity", 0, "hkpEntity", 3)
HK_PATCH_END()

HK_PATCH_BEGIN("hkpEntity", 3, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpRigidBody", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkpRigidBody", 0, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpWorldObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkpWorldObject", 0, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkpCharacterControllerCinfo", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkpCharacterControllerCinfo", 0, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hkaKeyFrameHierarchyUtilityControlData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hkaKeyFrameHierarchyUtilityControlData", 0, HK_NULL, HK_CLASS_REMOVED)
HK_PATCH_END()
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
