// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file


static void hkbCharacterData_9_to_10(hkDataObject& obj)
{
    const hkDataObject oldCharacterControllerInfo = obj["characterControllerInfo"].asObject();
    hkDataObject newCharacterControllerSetup = obj["characterControllerSetup"].asObject();

    // Setup the controller
    {
        hkDataObject newRigidBodySetup = newCharacterControllerSetup["rigidBodySetup"].asObject();
        newRigidBodySetup["collisionFilterInfo"] = oldCharacterControllerInfo["collisionFilterInfo"].asInt();
        newRigidBodySetup["type"] = 0; // ignored anyway

        hkDataObject newShapeSetup = newRigidBodySetup["shapeSetup"].asObject();
        newShapeSetup["capsuleHeight"] = oldCharacterControllerInfo["capsuleHeight"].asReal();
        newShapeSetup["capsuleRadius"] = oldCharacterControllerInfo["capsuleRadius"].asReal();
        newShapeSetup["type"] = 0;

        hkDataObject characterControllerCinfo = oldCharacterControllerInfo["characterControllerCinfo"].asObject();
        newCharacterControllerSetup["controllerCinfo"] = characterControllerCinfo;
    }
}

static void hkbRigidBodyRagdollControlData_1_to_2(hkDataObject& obj)
{
    const hkDataObject oldControlData = obj["keyFrameHierarchyControlData"].asObject();
    hkDataObject newControlData = obj["keyFrameControlData"].asObject();

    hkDataObject::Iterator oldIter(oldControlData);
    while (oldIter.advance())
    {
        const char* oldMemberName = oldIter.currentField().getName();

        HK_ASSERT_NO_MSG(0x22440107, newControlData.hasMember(oldMemberName));
        HK_ASSERT_NO_MSG(0x22440108, newControlData[oldMemberName].getType().m_type->extendsOrEquals<hkReal>() && oldControlData[oldMemberName].getType().m_type->extendsOrEquals<hkReal>());

        newControlData[oldMemberName] = oldControlData[oldMemberName];
    }
}

void HK_CALL registerBehaviorPatches_2012_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2012_2/hkbPatches_2012_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
