// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void _copyDataToStridedArray( hkDataArray& srcArray, hkDataArray& dstArray )
{
    dstArray.setSize( srcArray.getSize() );

    const int n = srcArray.getSize();
    for (int i=0; i<n; i++)
    {
        hkDataObject src = srcArray[i].asObject();
        dstArray[i] = src["data"].asInt();
    }
}

static void _copyArrays( hkDataObject& obj, const char* oldArrayName, const char* newArrayName )
{
    hkDataArray oldArray = obj[oldArrayName].asArray();
    hkDataArray newArray = obj[newArrayName].asArray();
    _copyDataToStridedArray( oldArray, newArray );
}

static void hkaiNavMesh_13_to_14(hkDataObject& navMeshObj)
{
    // Assume that old striding was 1
    _copyArrays(navMeshObj, "faces", "faceData");
    _copyArrays(navMeshObj, "edges", "edgeData");
}

static void hkaiNavMeshInstance_3_to_4(hkDataObject& instanceObj)
{
    _copyArrays(instanceObj, "ownedFaces", "ownedFaceData");
    _copyArrays(instanceObj, "ownedEdges", "ownedEdgeData");
    _copyArrays(instanceObj, "instancedFaces", "instancedFaceData");
    _copyArrays(instanceObj, "instancedEdges", "instancedEdgeData");
}

namespace
{
    float convertWallFollowingFactorToAngle(float wallFollowingFactor)
    {
        return (float)hkMath::acos(hkMath::clamp(hkReal(1-wallFollowingFactor/2), 0, 1));
    }
}

static void hkaiAvoidanceSolverAvoidanceProperties_9_to_10(hkDataObject& obj)
{
    hkDataObject aabb = obj["localSensorAabb"].asObject();
    hkVector4f vMin; vMin.setAll(-hkSimdFloat32_5);
    hkVector4f vMax; vMax.setAll(hkSimdFloat32_5);
    aabb["min"] = vMin;
    aabb["max"] = vMax;

    float wallFollowingFactor = obj["wallFollowingFactor"].asReal();
    float wallFollowingAngle = convertWallFollowingFactorToAngle(wallFollowingFactor);
    obj["wallFollowingAngle"] = wallFollowingAngle;
}

static void hkaiLocalSteeringInput_4_to_5(hkDataObject& obj)
{
    float wallFollowingFactor = obj["wallFollowingFactor"].asReal();
    float wallFollowingAngle = convertWallFollowingFactorToAngle(wallFollowingFactor);
    obj["wallFollowingAngle"] = wallFollowingAngle;
}

static void hkaiEdgePathEdge_0_to_1(hkDataObject& obj)
{
    hkInt32 oldFaceKey = obj["face"].asInt();
    hkDataObject persistentKey = obj["facePersistent"].asObject();
    persistentKey["key"] = oldFaceKey;
    persistentKey["offset"] = -1;
}

void HK_CALL registerAiPatches_2012_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2012_1/hkaiPatches_2012_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
