// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Config/hkConfigPackedKey.h> // Needed for HK_CONFIG_PACKED_KEY define

// Registration function is at the end of the file

static void hkaiNavMeshPathSearchParameters_3_to_4(hkDataObject& searchParams)
{
    int oldEnum = searchParams["outputPathType"].asInt();
    if (oldEnum == 2) // Smooth and project
    {
        searchParams["outputPathFlags"] = 3; // smooth | project
    }
    else
    {
        searchParams ["outputPathFlags"] = oldEnum; // either none or smooth only
    }
}

static void hkaiNavVolumeGenerationSettings_7_to_8(hkDataObject& genSettings)
{
    hkDataObject defaultConstructionInfo = genSettings["defaultConstructionInfo"].asObject();
    defaultConstructionInfo["flags"] = genSettings["defaultConstructionProperties"];
}

static void hkaiNavMeshPathSearchParameters_5_to_6(hkDataObject& searchParams)
{
    // This could probably be done as a rename, but I'm a little nervous about renaming a bool to flags.
    int oldVal = searchParams["checkForLineOfSight"].asInt();
    if (oldVal == 1) // checkLineOfSight was enabled
    {
        searchParams["lineOfSightFlags"] = 1;
    }
    else
    {
        searchParams ["lineOfSightFlags"] = 0;
    }
}


void HK_CALL registerAiPatches_2011_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2011_2/hkaiPatches_2011_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
