// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    static void _copyArray( hkDataObject& obj, const char* srcName, const char* dstName )
    {
        hkDataArray src = obj[srcName].asArray();
        hkDataArray dst = obj[dstName].asArray();

        const int size = src.getSize();
        dst.setSize( size );
        for (int i = 0; i < size; i++)
        {
            dst[i] = src[i].asObject();
        }
    }
}

static void hkdDeformableBreakableShapePhysicsSkinShape_0_to_1(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    _copyArray(obj, "old_sections", "sections");
}

static void hkdDecorateFractureFaceActionShapeDecorationInfo_1_to_2(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    //_copyArray(obj, "old_sharedData", "sharedData");
    _copyArray(obj, "old_connectionDecorations", "connectionDecorations");
}

static void hkdDecalMapActionDecalMapData_0_to_1(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    _copyArray(obj, "old_decals", "decals");
    _copyArray(obj, "old_decors", "decors");
    _copyArray(obj, "old_decorInfo", "decorInfo");
}

static void hkdBreakableBodyShapeKeyToChildMap_0_to_1(hkDataObject& obj)
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    _copyArray(obj, "old_shapeKeyToChild", "shapeKeyToChild");
}

void HK_CALL registerDestructionPatches_2010_2(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2010_2/hkdPatches_2010_2.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
