// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>

// Registration function is at the end of the file

static void hkdRandomSplitFracture_0_to_1(hkDataObject& obj)
{
    // member init to behave like version 0
    obj["randomSeed1"] = obj["randomSeed"].asInt();
    obj["randomSeed2"] = 0;
    obj["randomSeed3"] = 0;
    obj["randomSeed4"] = 0;
    obj["randomRange"] = 0.5f;
}

static void hkdShapeInstanceInfo_3_to_4(hkDataObject& obj)
{
    const hkQuaternionf q = obj["rotation"].asQuaternionf();
    const hkVector4f t = obj["translation"].asVector4f();

    const hkDataWorld* world = obj.getClass().getWorld();
    hkDataClass qtDataClass( world->findClass("hkQTransform") );
    hkDataObject qtObj = world->newObject( qtDataClass );

    qtObj["translation"] = t;
    qtObj["rotation"] = q;
    obj["transform"] = qtObj;
}

void HK_CALL registerDestructionPatches_2010_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2010_1/hkdPatches_2010_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
