// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Compat/hkCompat.h>
#include <Common/Compat/Common/Serialize/Data/hkDataObject.h>
#include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.h>
#include <Common/Base/KeyCode.h>
#include <Common/Base/Container/String/hkStringBuf.h>

// Registration function is at the end of the file

// versions a single object that has been moved inside another member which holds as array of these objects.
static void versionObjectToEmbedded(hkDataObject& obj, const char* oldMemberName, const char* newMemberName, const char* embeddedArrayName, hkDataClass newMemberClass)
{
    // create a new object
    hkDataObject newArrayObj = obj.getClass().getWorld()->newObject( newMemberClass );
    obj[newMemberName] = newArrayObj;

    hkDataArray newArray = newArrayObj[embeddedArrayName].asArray();
    newArray.setSize(1);
    newArray[0] = obj[oldMemberName].asObject();
}

// This function is used when you've renamed a member and you want to make sure the bindings on the node are renamed accordingly.
static void replacePropertyNameInBindings( hkDataObject& variableBindingSet, const char* oldName, const char* newName )
{
    if ( !variableBindingSet.isNull() )
    {
        hkDataArray bindingsArray = variableBindingSet["bindings"].asArray();
        int sz = bindingsArray.getSize();

        for( int i = 0; i < sz; i++ )
        {
            hkDataObject binding = bindingsArray[i].asObject();
            const char* oldMemberPath = binding["memberPath"].asString();

            if ( hkString::beginsWith( oldMemberPath, oldName ) )
            {
                hkStringBuf s;
                s.printf("%s%s", newName, oldMemberPath + hkString::strLen(oldName));
                binding["memberPath"] = s.cString();
            }
        }
    }
}

// This function replicates a binding to one member for a new member.  This is used if you introduce a new member
// but you want it bound to the same variable as an existing member.
static void replicateBindings( hkDataObject& variableBindingSet, const char* oldName, const char* newName )
{
    if ( !variableBindingSet.isNull() )
    {
        hkDataArray bindingsArray = variableBindingSet["bindings"].asArray();
        int sz = bindingsArray.getSize();

        for( int i = 0; i < sz; i++ )
        {
            hkDataObject binding = bindingsArray[i].asObject();
            const char* oldMemberPath = binding["memberPath"].asString();

            if ( hkString::beginsWith( oldMemberPath, oldName ) )
            {
                hkStringBuf s;
                s.printf("%s%s", newName, oldMemberPath + hkString::strLen(oldName));
                int j = bindingsArray.getSize();
                bindingsArray.setSize( j + 1 );
                bindingsArray[j] = binding;
                bindingsArray[j].asObject()["memberPath"] = s.cString();
            }
        }
    }
}

static void hkbLookAtModifier_2_to_3(hkDataObject& obj)
{
    // by default we assume that the neck and the head are aligned
    obj["neckForwardLS"] = obj["headForwardLS"].asVector4();

    hkDataObject variableBindingSet = obj["variableBindingSet"].asObject();

    replacePropertyNameInBindings( variableBindingSet, "headForwardHS", "headForwardLS" );
    replacePropertyNameInBindings( variableBindingSet, "headRightHS", "neckRightLS" );
    replicateBindings( variableBindingSet, "headForwardLS", "neckForwardLS" );
}

static void hkbStateMachineStateInfo_3_to_4(hkDataObject& obj)
{
    versionObjectToEmbedded( obj, "enterNotifyEvent", "enterNotifyEvents", "events", obj.getClass().getWorld()->findClass("hkbStateMachineEventPropertyArray") );
    versionObjectToEmbedded( obj, "exitNotifyEvent", "exitNotifyEvents", "events", obj.getClass().getWorld()->findClass("hkbStateMachineEventPropertyArray") );
}

void HK_CALL registerBehaviorPatches_2010_1(hkVersionPatchManager& man)
{
#   define HK_PATCHES_FILE <Common/Compat/Patches/2010_1/hkbPatches_2010_1.hxx>
#   include <Common/Compat/Common/Serialize/Version/hkVersionPatchManager.cxx>
#   undef HK_PATCHES_FILE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
