// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if !defined(HK_PATCHES_FILE)
#   error You must define HK_PATCHES_FILE before including this file
#endif

#if !defined(HK_PATCH_SET_OBJECT)
#define HK_PATCH_SET_OBJECT man
#endif





#include <Common/Base/Config/hkConfigBranches.h>
{
#define HK_CLASS_ADDED -1
#define HK_CLASS_REMOVED -1

// HK_FAKEUSAGE to prevent bogus warning C4189 on Visual Studio
#define HK_FAKEUSAGE(NAME) (void)NAME

static const hkReal hkVec4Identity[] = { 0, 0, 0, 1 };
static const hkReal hkVec12Identity[] = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0 };
static const hkReal hkVec16Identity[] = { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1 };

//
// Defaults
//
#define HK_PATCH_BEGIN(CLASSNAME, OLDVER, NEWNAME, NEWVER)
#define     HK_PATCH_DEPENDS(CNAME, VERSION)
#define     HK_PATCH_PARENT_SET(OLDNAME, NEWNAME)

#define     HK_PATCH_MEMBER_ADDED(NAME, TYPE, TYPE_NAME, TUPLES)
#define     HK_PATCH_MEMBER_ADDED_INT(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_ADDED_REAL(NAME, VALUE) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkReal(VALUE);
#define     HK_PATCH_MEMBER_ADDED_BOOL(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_ADDED_BYTE(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_ADDED_VEC_4(NAME, vx, vy, vz, vw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {vx, vy, vz, vw};
#define     HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY(NAME)
#define     HK_PATCH_MEMBER_ADDED_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw};
#define     HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY(NAME)
#define     HK_PATCH_MEMBER_ADDED_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw};
#define     HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY(NAME)
#define     HK_PATCH_MEMBER_ADDED_CSTRING(NAME, VALUE) static const char* HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = VALUE;
#define     HK_PATCH_MEMBER_ADDED_POINTER(NAME, SUBTYPE, VALUE) static const void* HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = VALUE;

#define     HK_PATCH_MEMBER_TYPE_CHANGED(NAME, OLD_TYPE, OLD_TYPE_NAME, OLD_TUPLES, NEW_TYPE, NEW_TYPE_NAME, NEW_TUPLES, FUNCTION)

#define     HK_PATCH_MEMBER_DEFAULT_SET_INT(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_DEFAULT_SET_REAL(NAME, VALUE) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkReal(VALUE);
#define     HK_PATCH_MEMBER_DEFAULT_SET_BOOL(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_DEFAULT_SET_BYTE(NAME, VALUE) static const hkInt64 HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = hkInt64(VALUE);
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_4(NAME, vx, vy, vz, vw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {vx, vy, vz, vw};
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw};
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) static const hkReal HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)[] = {ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw};
#define     HK_PATCH_MEMBER_DEFAULT_SET_CSTRING(NAME, VALUE) static const char* HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = VALUE;
#define     HK_PATCH_MEMBER_DEFAULT_SET_POINTER(NAME, VALUE) static const void* HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__) = VALUE;

#define     HK_PATCH_MEMBER_RENAMED(OLDNAME,NEWNAME)
#define     HK_PATCH_FUNCTION(NAME)
#define     HK_PATCH_MEMBER_REMOVED(NAME, TYPE, TYPE_NAME, TUPLES)

#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED(NAME, DEFAULT)
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED(NAME, DEFAULT)
#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED(NAME, DEFAULT)
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED(NAME, DEFAULT)

#define HK_PATCH_END()
#       include HK_PATCHES_FILE
#undef  HK_PATCH_BEGIN
#undef      HK_PATCH_DEPENDS
#undef      HK_PATCH_PARENT_SET

#undef      HK_PATCH_MEMBER_ADDED
#undef      HK_PATCH_MEMBER_ADDED_INT
#undef      HK_PATCH_MEMBER_ADDED_REAL
#undef      HK_PATCH_MEMBER_ADDED_BOOL
#undef      HK_PATCH_MEMBER_ADDED_BYTE
#undef      HK_PATCH_MEMBER_ADDED_VEC_4
#undef      HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_12
#undef      HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_16
#undef      HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_CSTRING
#undef      HK_PATCH_MEMBER_ADDED_POINTER

#undef      HK_PATCH_MEMBER_TYPE_CHANGED

#undef      HK_PATCH_MEMBER_DEFAULT_SET_INT
#undef      HK_PATCH_MEMBER_DEFAULT_SET_REAL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BOOL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BYTE
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_4
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_12
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_16
#undef      HK_PATCH_MEMBER_DEFAULT_SET_CSTRING
#undef      HK_PATCH_MEMBER_DEFAULT_SET_POINTER

#undef      HK_PATCH_MEMBER_RENAMED
#undef      HK_PATCH_FUNCTION
#undef      HK_PATCH_MEMBER_REMOVED

#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED
#undef  HK_PATCH_END
//
// Patches
//

#define HK_PATCH_BEGIN(CLASSNAME, OLDVER, NEWNAME, NEWVER)
#define     HK_PATCH_DEPENDS(CNAME, VERSION) static const hkReflect::Version::PatchInfo::DependsPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {CNAME, VERSION};
#define     HK_PATCH_PARENT_SET(OLDNAME, NEWNAME) static const hkReflect::Version::PatchInfo::SetParentPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {OLDNAME, NEWNAME};

#define     HK_PATCH_MEMBER_ADDED(NAME, TYPE, TYPE_NAME, TUPLES) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE,TYPE_NAME,TUPLES, HK_NULL};
#define     HK_PATCH_MEMBER_ADDED_INT(NAME, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_INT,HK_NULL,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_ADDED_REAL(NAME, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_REAL,HK_NULL,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_ADDED_BOOL(NAME, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_BYTE,HK_NULL,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_ADDED_BYTE(NAME, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_BYTE,HK_NULL,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_ADDED_VEC_4(NAME, vx, vy, vz, vw) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_4,HK_NULL,0,reinterpret_cast<const hkVector4*>(&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__))};
#define     HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY(NAME) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_4,HK_NULL,0,reinterpret_cast<const hkVector4*>(&hkVec4Identity)};
#define     HK_PATCH_MEMBER_ADDED_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_12,HK_NULL,0,reinterpret_cast<const hkQsTransform*>(&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__))};
#define     HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY(NAME) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_12,HK_NULL,0,reinterpret_cast<const hkQsTransform*>(&hkVec12Identity)};
#define     HK_PATCH_MEMBER_ADDED_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_16,HK_NULL,0,reinterpret_cast<const hkTransform*>(&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__))};
#define     HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY(NAME) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_VEC_16,HK_NULL,0,reinterpret_cast<const hkTransform*>(&hkVec16Identity)};
#define     HK_PATCH_MEMBER_ADDED_CSTRING(NAME, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_CSTRING,HK_NULL,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_ADDED_POINTER(NAME, SUBTYPE, VALUE) static const hkReflect::Version::PatchInfo::MemberAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE_OBJECT,SUBTYPE,0,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};

#define     HK_PATCH_MEMBER_TYPE_CHANGED(NAME, OLD_TYPE, OLD_TYPE_NAME, OLD_TUPLES, NEW_TYPE, NEW_TYPE_NAME, NEW_TUPLES, FUNCTION) static const hkReflect::Version::PatchInfo::TypeChangedFunctionPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = { NAME, hkReflect::Version::OLD_TYPE, OLD_TYPE_NAME, OLD_TUPLES, hkReflect::Version::NEW_TYPE, NEW_TYPE_NAME, NEW_TUPLES, FUNCTION };

#define     HK_PATCH_MEMBER_DEFAULT_SET_INT(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_REAL(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_BOOL(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_BYTE(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_4(NAME, vx, vy, vz, vw) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, &HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_CSTRING(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};
#define     HK_PATCH_MEMBER_DEFAULT_SET_POINTER(NAME, VALUE) static const hkReflect::Version::PatchInfo::DefaultChangedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,&HK_PREPROCESSOR_JOIN_TOKEN(d,__LINE__)};

#define     HK_PATCH_MEMBER_RENAMED(OLDNAME,NEWNAME) static const hkReflect::Version::PatchInfo::MemberRenamedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {OLDNAME,NEWNAME};
#define     HK_PATCH_FUNCTION(NAME) static const hkReflect::Version::PatchInfo::DataObjectFunctionPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = { #NAME, NAME };
#define     HK_PATCH_MEMBER_REMOVED(NAME, TYPE, TYPE_NAME, TUPLES) static const hkReflect::Version::PatchInfo::MemberRemovedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME,hkReflect::Version::TYPE,TYPE_NAME,TUPLES};

#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED(NAME, DEFAULT) static const hkReflect::Version::PatchInfo::TypeTemplateParameterAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, DEFAULT};
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED(NAME, DEFAULT) static const hkReflect::Version::PatchInfo::ValueTemplateParameterAddedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, DEFAULT};
#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED(NAME, DEFAULT) static const hkReflect::Version::PatchInfo::TypeTemplateParameterRemovedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, DEFAULT};
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED(NAME, DEFAULT) static const hkReflect::Version::PatchInfo::ValueTemplateParameterRemovedPatch HK_PREPROCESSOR_JOIN_TOKEN(p,__LINE__) = {NAME, DEFAULT};

#define HK_PATCH_END()
#       include HK_PATCHES_FILE
#undef  HK_PATCH_BEGIN
#undef      HK_PATCH_DEPENDS
#undef      HK_PATCH_PARENT_SET

#undef      HK_PATCH_MEMBER_ADDED
#undef      HK_PATCH_MEMBER_ADDED_INT
#undef      HK_PATCH_MEMBER_ADDED_REAL
#undef      HK_PATCH_MEMBER_ADDED_BOOL
#undef      HK_PATCH_MEMBER_ADDED_BYTE
#undef      HK_PATCH_MEMBER_ADDED_VEC_4
#undef      HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_12
#undef      HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_16
#undef      HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_CSTRING
#undef      HK_PATCH_MEMBER_ADDED_POINTER

#undef      HK_PATCH_MEMBER_TYPE_CHANGED

#undef      HK_PATCH_MEMBER_DEFAULT_SET_INT
#undef      HK_PATCH_MEMBER_DEFAULT_SET_REAL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BOOL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BYTE
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_4
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_16
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_12
#undef      HK_PATCH_MEMBER_DEFAULT_SET_CSTRING
#undef      HK_PATCH_MEMBER_DEFAULT_SET_POINTER

#undef      HK_PATCH_MEMBER_RENAMED
#undef      HK_PATCH_FUNCTION
#undef      HK_PATCH_MEMBER_REMOVED

#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED
#undef  HK_PATCH_END

//
// PatchInfos (wrapping several logical patches)
//

#define HK_PATCH_BEGIN(CLASSNAME, OLDVER, NEWCLASSNAME, NEWVER) { HK_CONSTEXPR const char* const classname = CLASSNAME; HK_FAKEUSAGE(classname); HK_CONSTEXPR const char* const newclassname = NEWCLASSNAME; HK_FAKEUSAGE(newclassname); HK_CONSTEXPR const int oldver = OLDVER; HK_CONSTEXPR const int newver = NEWVER; HK_CONSTEXPR const bool isNew = false; static HK_CONSTEXPR const hkReflect::Version::PatchInfo::Component patch[] = {
#define     HK_PATCH_DEPENDS(CNAME, VERSION) {hkReflect::Version::PatchInfo::PATCH_DEPENDS, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_PARENT_SET(OLDNAME, NEWNAME) {hkReflect::Version::PatchInfo::PATCH_PARENT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define     HK_PATCH_MEMBER_ADDED(NAME, TYPE, TYPE_NAME, TUPLES) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_INT(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_REAL(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_BOOL(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_BYTE(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_4(NAME, vx, vy, vz, vw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY(NAME) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY(NAME) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY(NAME) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_CSTRING(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_ADDED_POINTER(NAME, SUBTYPE, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define     HK_PATCH_MEMBER_TYPE_CHANGED(NAME, OLD_TYPE, OLD_TYPE_NAME, OLD_TUPLES, NEW_TYPE, NEW_TYPE_NAME, NEW_TUPLES, FUNCTION) { hkReflect::Version::PatchInfo::PATCH_TYPE_CHANGED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define     HK_PATCH_MEMBER_DEFAULT_SET_INT(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_REAL(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_BOOL(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_BYTE(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_4(NAME, vx, vy, vz, vw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_16(NAME, ax, ay, az, aw, bx, by, bz, bw, cx, cy, cz, cw, dx, dy, dz, dw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_VEC_12(NAME, tx, ty, tz, tw, rix, riy, riz, rr, sx, sy, sz, sw) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_CSTRING(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_DEFAULT_SET_POINTER(NAME, VALUE) {hkReflect::Version::PatchInfo::PATCH_MEMBER_DEFAULT_SET, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define     HK_PATCH_MEMBER_RENAMED(OLDNAME,NEWNAME) {hkReflect::Version::PatchInfo::PATCH_MEMBER_RENAMED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_FUNCTION(NAME) {hkReflect::Version::PatchInfo::PATCH_DATAOBJECT_FUNCTION, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_MEMBER_REMOVED(NAME, TYPE, TYPE_NAME, TUPLES) {hkReflect::Version::PatchInfo::PATCH_MEMBER_REMOVED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED(NAME, DEFAULT) {hkReflect::Version::PatchInfo::PATCH_TYPE_TEMPLATE_PARAMETER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED(NAME, DEFAULT) {hkReflect::Version::PatchInfo::PATCH_VALUE_TEMPLATE_PARAMETER_ADDED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED(NAME, DEFAULT) {hkReflect::Version::PatchInfo::PATCH_TYPE_TEMPLATE_PARAMETER_REMOVED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},
#define     HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED(NAME, DEFAULT) {hkReflect::Version::PatchInfo::PATCH_VALUE_TEMPLATE_PARAMETER_REMOVED, HK_PREPROCESSOR_JOIN_TOKEN(&p,__LINE__)},

#define HK_PATCH_END() {hkReflect::Version::PatchInfo::PATCH_INVALID, HK_NULL} }; static HK_CONSTEXPR const hkReflect::Version::PatchInfo pinfo = {classname, newclassname, oldver, newver, patch, HK_COUNT_OF(patch) - 1, isNew, false}; HK_PATCH_SET_OBJECT.handlePatch(&pinfo); }

#       include HK_PATCHES_FILE
#undef  HK_PATCH_BEGIN
#undef      HK_PATCH_DEPENDS
#undef      HK_PATCH_PARENT_SET

#undef      HK_PATCH_MEMBER_ADDED
#undef      HK_PATCH_MEMBER_ADDED_INT
#undef      HK_PATCH_MEMBER_ADDED_REAL
#undef      HK_PATCH_MEMBER_ADDED_BOOL
#undef      HK_PATCH_MEMBER_ADDED_BYTE
#undef      HK_PATCH_MEMBER_ADDED_VEC_4
#undef      HK_PATCH_MEMBER_ADDED_VEC_4_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_12
#undef      HK_PATCH_MEMBER_ADDED_VEC_12_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_VEC_16
#undef      HK_PATCH_MEMBER_ADDED_VEC_16_IDENTITY
#undef      HK_PATCH_MEMBER_ADDED_CSTRING
#undef      HK_PATCH_MEMBER_ADDED_POINTER

#undef      HK_PATCH_MEMBER_TYPE_CHANGED

#undef      HK_PATCH_MEMBER_DEFAULT_SET_INT
#undef      HK_PATCH_MEMBER_DEFAULT_SET_REAL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BOOL
#undef      HK_PATCH_MEMBER_DEFAULT_SET_BYTE
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_4
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_16
#undef      HK_PATCH_MEMBER_DEFAULT_SET_VEC_12
#undef      HK_PATCH_MEMBER_DEFAULT_SET_CSTRING
#undef      HK_PATCH_MEMBER_DEFAULT_SET_POINTER

#undef      HK_PATCH_MEMBER_RENAMED
#undef      HK_PATCH_FUNCTION
#undef      HK_PATCH_MEMBER_REMOVED
#undef  HK_PATCH_END

#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_ADDED
#undef      HK_PATCH_TEMPLATE_TYPE_PARAMETER_REMOVED
#undef      HK_PATCH_TEMPLATE_VALUE_PARAMETER_REMOVED
#undef HK_CLASS_ADDED
#undef HK_CLASS_REMOVED

#undef HK_FAKEUSAGE
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
