// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename FT, int count, typename VECTORTYPE>
HK_INLINE void hkDataObject::Value::fillVec(VECTORTYPE& v, int offset) const
{
    HK_COMPILE_TIME_ASSERT(sizeof(VECTORTYPE) == (sizeof(FT) * count));

    hkReflect::ArrayVar vv(&v);
    HK_ON_DEBUG(const hkReflect::Type* type = m_object.getType());
    HK_ON_DEBUG(if (type->asRecord()) { type = type->asRecord()->getField(0).getType(); });
    hkReflect::ArrayVar h(m_object);
    HK_ASSERT_NO_MSG(0x7eed854b, h.isValid());
    HK_ASSERT_NO_MSG(0x7eed854b, vv.isValid());
    HK_ASSERT_NO_MSG(0x1dfbe143, h.getSubType()->asFloat());

    for (int i = 0; i < count; i++)
    {
        hkReflect::FloatVar fv(h[i + offset]);
        hkReflect::FloatVar vfv(vv[i]);
        vfv.setValue(fv.getValue());
    }
}

#if defined(HK_REAL_IS_FLOAT)
HK_INLINE hkVector4 hkDataObject::Value::asVector4() const { return asVector4f(); }
HK_INLINE hkQuaternion hkDataObject::Value::asQuaternion() const { return asQuaternionf(); }
HK_INLINE hkMatrix3 hkDataObject::Value::asMatrix3() const { return asMatrix3f(); }
HK_INLINE hkRotation hkDataObject::Value::asRotation() const { return asRotationf(); }
HK_INLINE hkQsTransform hkDataObject::Value::asQsTransform() const { return asQsTransformf(); }
HK_INLINE hkMatrix4 hkDataObject::Value::asMatrix4() const { return asMatrix4f(); }
HK_INLINE hkTransform hkDataObject::Value::asTransform() const { return asTransformf(); }
HK_INLINE hkSymmetricMatrix3 hkDataObject::Value::asSymmetricMatrix3() const { return asSymmetricMatrix3f(); }
#else
HK_INLINE hkVector4 hkDataObject::Value::asVector4() const { return asVector4d(); }
HK_INLINE hkQuaternion hkDataObject::Value::asQuaternion() const { return asQuaterniond(); }
HK_INLINE hkMatrix3 hkDataObject::Value::asMatrix3() const { return asMatrix3d(); }
HK_INLINE hkRotation hkDataObject::Value::asRotation() const { return asRotationd(); }
HK_INLINE hkQsTransform hkDataObject::Value::asQsTransform() const { return asQsTransformd(); }
HK_INLINE hkMatrix4 hkDataObject::Value::asMatrix4() const { return asMatrix4d(); }
HK_INLINE hkTransform hkDataObject::Value::asTransform() const { return asTransformd(); }
HK_INLINE hkSymmetricMatrix3 hkDataObject::Value::asSymmetricMatrix3() const { return asSymmetricMatrix3d(); }
#endif

HK_INLINE hkVector4f hkDataObject::Value::asVector4f() const
{
    hkVector4f ret;
    fillVec<float, 4>(ret);
    return ret;
}
HK_INLINE hkQuaternionf hkDataObject::Value::asQuaternionf() const
{
    hkQuaternionf ret;
    fillVec<float, 4>(ret);
    return ret;
}
HK_INLINE hkMatrix3f hkDataObject::Value::asMatrix3f() const
{
    hkMatrix3f ret;
    fillVec<float, 12>(ret);
    return ret;
}
HK_INLINE hkRotationf hkDataObject::Value::asRotationf() const
{
    hkRotationf ret;
    fillVec<float, 12>(ret);
    return ret;
}
HK_INLINE hkQsTransformf hkDataObject::Value::asQsTransformf() const
{
    hkQsTransformf ret;
    fillVec<float, 4>(ret.m_translation);
    fillVec<float, 4>(ret.m_rotation, 4);
    fillVec<float, 4>(ret.m_scale, 8);
    return ret;
}
HK_INLINE hkMatrix4f hkDataObject::Value::asMatrix4f() const
{
    hkMatrix4f ret;
    fillVec<float, 16>(ret);
    return ret;
}
HK_INLINE hkTransformf hkDataObject::Value::asTransformf() const
{
    hkTransformf ret;
    fillVec<float, 16>(ret);
    return ret;
}

HK_INLINE hkSymmetricMatrix3f hkDataObject::Value::asSymmetricMatrix3f() const
{
    hkSymmetricMatrix3f ret;
    fillVec<float, 4>(ret.m_diag);
    fillVec<float, 4>(ret.m_offDiag, 4);
    return ret;
}

HK_INLINE hkVector4d hkDataObject::Value::asVector4d() const
{
    hkVector4d ret;
    fillVec<double, 4>(ret);
    return ret;
}
HK_INLINE hkQuaterniond hkDataObject::Value::asQuaterniond() const
{
    hkQuaterniond ret;
    fillVec<double, 4>(ret);
    return ret;
}
HK_INLINE hkMatrix3d hkDataObject::Value::asMatrix3d() const
{
    hkMatrix3d ret;
    fillVec<double, 12>(ret);
    return ret;
}
HK_INLINE hkRotationd hkDataObject::Value::asRotationd() const
{
    hkRotationd ret;
    fillVec<double, 12>(ret);
    return ret;
}
HK_INLINE hkQsTransformd hkDataObject::Value::asQsTransformd() const
{
    hkQsTransformd ret;
    fillVec<double, 4>(ret.m_translation);
    fillVec<double, 4>(ret.m_rotation, 4);
    fillVec<double, 4>(ret.m_scale, 8);
    return ret;
}
HK_INLINE hkMatrix4d hkDataObject::Value::asMatrix4d() const
{
    hkMatrix4d ret;
    fillVec<double, 16>(ret);
    return ret;
}
HK_INLINE hkTransformd hkDataObject::Value::asTransformd() const
{
    hkTransformd ret;
    fillVec<double, 16>(ret);
    return ret;
}

HK_INLINE hkSymmetricMatrix3d hkDataObject::Value::asSymmetricMatrix3d() const
{
    hkSymmetricMatrix3d ret;
    fillVec<double, 4>(ret.m_diag);
    fillVec<double, 4>(ret.m_offDiag, 4);
    return ret;
}

HK_INLINE void hkDataObject::Value::operator=(const hkVector4f& v)
{
    setVec(reinterpret_cast<const float*>(&v), 4);
}
HK_INLINE void hkDataObject::Value::operator=(const hkQuaternionf& v)
{
    setVec(reinterpret_cast<const float*>(&v), 4);
}
HK_INLINE void hkDataObject::Value::operator=(const hkMatrix3f& v)
{
    setVec(reinterpret_cast<const float*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkRotationf& v)
{
    setVec(reinterpret_cast<const float*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkQsTransformf& v)
{
    setVec(reinterpret_cast<const float*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkMatrix4f& v)
{
    setVec(reinterpret_cast<const float*>(&v), 16);
}
HK_INLINE void hkDataObject::Value::operator=(const hkTransformf& v)
{
    setVec(reinterpret_cast<const float*>(&v), 16);
}

HK_INLINE void hkDataObject::Value::operator=(const hkVector4d& v)
{
    setVec(reinterpret_cast<const double*>(&v), 4);
}
HK_INLINE void hkDataObject::Value::operator=(const hkQuaterniond& v)
{
    setVec(reinterpret_cast<const double*>(&v), 4);
}
HK_INLINE void hkDataObject::Value::operator=(const hkMatrix3d& v)
{
    setVec(reinterpret_cast<const double*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkRotationd& v)
{
    setVec(reinterpret_cast<const double*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkQsTransformd& v)
{
    setVec(reinterpret_cast<const double*>(&v), 12);
}
HK_INLINE void hkDataObject::Value::operator=(const hkMatrix4d& v)
{
    setVec(reinterpret_cast<const double*>(&v), 16);
}
HK_INLINE void hkDataObject::Value::operator=(const hkTransformd& v)
{
    setVec(reinterpret_cast<const double*>(&v), 16);
}

HK_INLINE hkDataObject::Value hkDataObject::Array::operator[](int index) const
{
#ifdef HK_DEBUG_SLOW
    HK_ASSERT_NO_MSG(0x4607467a, m_type->asArray());
    //if( const hkReflect::ArrayType* arr = m_type->asArray() )
    //{
    //  hkReflect::ArrayVar array(arr, m_object);
    //}
    //HK_ASSERT(0x91d8a0a, !arr || m_size == arr->getArraySize(m_object), "Data array size has been changed externally");
    //HK_ASSERT(0x548e8d94, !arr || m_data == arr->getDataPointer(hkAddByteOffset(m_object) m_offset)), "Data array pointer has been changed externally");
#endif

    hkReflect::Var objectVar(hkAddByteOffset(m_data, m_stride * index), m_elemType);

    HK_ASSERT_NO_MSG(0x608ade04, (objectVar.getAddress() >= m_data) && (objectVar.getAddress() < hkAddByteOffset(m_data, m_stride * m_size)));
    return hkDataObject::Value(objectVar, m_parent, m_id);
}

/// Get value as integer.
template<typename T>
T hkDataObject::Value::asInteger() const
{
    hkReflect::IntVar src(m_object);

    if(src.isValid())
    {
        T t = src.getValue().convertTo<T>();
        return t;
    }
    else if (const hkReflect::BoolType* boolType = m_object.getType()->asBool())
    {
        hkReflect::BoolVar srcBool(m_object);

        return T(srcBool.getValue());
    }

    HK_ASSERT_NO_MSG(0x64d03da7, 0);
    return T();
}

// Bools and ints are used interchangeably
bool hkDataObject::Value::asBool() const
{
    const hkReflect::BoolType* boolType = m_object.getType()->asBool();
    const hkReflect::IntType* intType = m_object.getType()->asInteger();

    if (boolType != HK_NULL)
    {
        hkReflect::BoolVar src(m_object);
        HK_ASSERT_NO_MSG(0x23ff0da7, src.isValid());
        return src.getValue();
    }
    else if (intType != HK_NULL)
    {
        hkReflect::IntVar src(m_object);
        HK_ASSERT_NO_MSG(0x23ff0da8, src.isValid());
        return !src.getValue().isZero();
    }
    else
    {
        HK_ASSERT_NO_MSG(0x23ff0da9, 0); // Not a bool type
    }
    return false;
}

 hkDataObject::Iterator::Iterator(const hkDataObject& obj)
     : m_obj(obj)
     , m_it(obj.m_object.getType())
 {
     HK_ASSERT_NO_MSG(0x606b5f, m_obj.m_object.getType()->asRecord());
 }

 bool hkDataObject::Iterator::advance()
 {
     if (!m_it.advance())
     {
         return false;
     }

     return true;
 }

 hkDataObject::Value hkDataObject::Iterator::current() const
 {
     return hkDataObject::Value(m_obj.m_object[m_it.current()], m_obj.m_parent, m_obj.m_id);
 }

 hkReflect::FieldDecl hkDataObject::Iterator::currentField() const
 {
     return m_it.current();
 }

template<typename FLOATTYPE>
void hkDataObject::Value::setVec(const FLOATTYPE* r, int nreal)
{
    HK_ON_DEBUG(const hkReflect::Type* type = m_object.getType());
    HK_ON_DEBUG(if (type->asRecord()) { type = type->asRecord()->getField(0).getType(); });
    hkReflect::ArrayVar h(m_object);
    HK_ASSERT_NO_MSG(0x1693a976, h.isValid());
    HK_ASSERT_NO_MSG(0x78423ae4, nreal == h.getCount());
    HK_ASSERT_NO_MSG(0x486c2420, h.getSubType()->asFloat());

    for (int i = 0; i < nreal; i++)
    {
        hkReflect::FloatVar fv(h[i]);
        fv.setValue(r[i]);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
