// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/String/hkStringBuf.h>
#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Math/SymmetricMatrix/hkSymmetricMatrix3.h>

class CompatPatcher;
class hkVersionedRecordType;

// Interface that looks like the legacy hkDataObject but actually wraps a Var-based versioning object
class hkDataObject
{
public:
    class Array;

    enum VarOrExtraType
    {
        VAR = 0,
        EXTRA = 1
    };

    class VarOrExtra
    {
    public:
        enum
        {
            IS_EXTRA_BIT = 0x80000000,
            ID_MASK = 0x7fffffff
        };
        VarOrExtra(int id = 0, VarOrExtraType isExt = VAR) : m_idAndType(((isExt == EXTRA) ? hkUint32(IS_EXTRA_BIT) : 0) | (id & ID_MASK)) {}
        VarOrExtra(const VarOrExtra& o) : m_idAndType(o.m_idAndType) {}

        bool isVar() const { return (m_idAndType & IS_EXTRA_BIT) == 0; }
        bool isExtra() const { return (m_idAndType & IS_EXTRA_BIT) != 0; }

        int getId() const { return m_idAndType & ID_MASK; }

        void set(int id, VarOrExtraType isExt) { m_idAndType = (((isExt == EXTRA) ? hkUint32(IS_EXTRA_BIT) : 0) | (id & ID_MASK)); }
        void set(const VarOrExtra& o) { m_idAndType = o.m_idAndType; }
        bool operator==(const VarOrExtra& o) const { return m_idAndType == o.m_idAndType; }
    private:
        hkUint32 m_idAndType;
    };

    class Type
    {
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, Type);

        Type(CompatPatcher* parent, const hkReflect::Type* t) : m_parent(parent), m_type(t) {}

        bool isPointer() const;
        bool isClass() const;
        bool isTuple() const;
        bool isArray() const;

        Type getParent();
        CompatPatcher* m_parent;
        const hkReflect::Type* m_type;
    };

    class Value
    {
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, Value);

        /// Assign 'l' to value.
        void operator=(const Value& l);
        /// Assign 32-bit integer to value.
        void operator=(int i);
        void operator=(hkUint32 i); // unsigned
        /// Assign 64-bit integer to value.
        void operator=(hkInt64 i);
        /// Assign 32-bit float to value.
        void operator=(float r);
        /// Assign 64-bit float to value.
        void operator=(double d);
        /// Assign bool to value.
        void operator=(bool b);
        /// Assign 16-bit float to value.
        void operator=(hkHalf16 r);
        /// Assign c-style string to value.
        void operator=(const char* s);
        //      /// Assign array or tuple to value.
        void operator=(const Array& l);
        /// Assign object to value.
        void operator=(const hkDataObject& o);
        /// Assign HK_NULL object
        void setNull();

        template<typename T>
        T asInteger() const;

        int asInt() const { return asInteger<int>();  }
        HK_INLINE bool asBool() const;
        hkInt64 asInt64() const { return asInteger<hkInt64>(); };

        /// Get value as 32-bit float.
        float asReal() const;
        /// Get value as 32-bit float.
        hkHalf16 asHalf() const;
        /// Get value as c-style string.
        const char* asString() const;
        /// Get value as array or tuple.
        Array asArray() const;
        /// Get value as object.
        hkDataObject asObject() const;
    protected:
        template<typename FT, int count, typename VECTORTYPE>
        HK_INLINE void fillVec(VECTORTYPE& v, int offset = 0) const;
    public:
        /// Set an array of floats
        template<typename FLOATTYPE>
        void setVec(const FLOATTYPE* r, int nreal);

        const char* getTypeName() const;
        /// Returns true if this value on this object has been set
        HK_INLINE hkBool32 isSet() const { return m_object.getAddress() != HK_NULL; }

        //      /// Get value type.
        Type getType() const { return Type(m_parent, m_object.getType()); }

        HK_INLINE hkVector4 asVector4() const;
        HK_INLINE hkQuaternion asQuaternion() const;
        HK_INLINE hkMatrix3 asMatrix3() const;
        HK_INLINE hkRotation asRotation() const;
        HK_INLINE hkQsTransform asQsTransform() const;
        HK_INLINE hkMatrix4 asMatrix4() const;
        HK_INLINE hkTransform asTransform() const;
        HK_INLINE hkSymmetricMatrix3 asSymmetricMatrix3() const;

        HK_INLINE hkVector4f asVector4f() const;
        HK_INLINE hkQuaternionf asQuaternionf() const;
        HK_INLINE hkMatrix3f asMatrix3f() const;
        HK_INLINE hkRotationf asRotationf() const;
        HK_INLINE hkQsTransformf asQsTransformf() const;
        HK_INLINE hkMatrix4f asMatrix4f() const;
        HK_INLINE hkTransformf asTransformf() const;
        HK_INLINE hkSymmetricMatrix3f asSymmetricMatrix3f() const;

        HK_INLINE hkVector4d asVector4d() const;
        HK_INLINE hkQuaterniond asQuaterniond() const;
        HK_INLINE hkMatrix3d asMatrix3d() const;
        HK_INLINE hkRotationd asRotationd() const;
        HK_INLINE hkQsTransformd asQsTransformd() const;
        HK_INLINE hkMatrix4d asMatrix4d() const;
        HK_INLINE hkTransformd asTransformd() const;
        HK_INLINE hkSymmetricMatrix3d asSymmetricMatrix3d() const;

        void operator=(const hkVector4f& v);
        void operator=(const hkQuaternionf& v);
        void operator=(const hkMatrix3f& v);
        void operator=(const hkRotationf& v);
        void operator=(const hkQsTransformf& v);
        void operator=(const hkMatrix4f& v);
        void operator=(const hkTransformf& v);

        void operator=(const hkVector4d& v);
        void operator=(const hkQuaterniond& v);
        void operator=(const hkMatrix3d& v);
        void operator=(const hkRotationd& v);
        void operator=(const hkQsTransformd& v);
        void operator=(const hkMatrix4d& v);
        void operator=(const hkTransformd& v);

        Value(hkReflect::Var obj, class CompatPatcher* parent, VarOrExtra id)
            : m_object(obj)
            , m_parent(parent)
            , m_id(id)
        {
            HK_ASSERT_NO_MSG(0x3ca25d1e, m_object.getType() || (!m_object.getType() && !m_object.getAddress()));
            // Check if we need to follow a reference to a different location
            if (m_object && m_object.getType()->asRecord())
            {
                addBackLinkIfRequired();
            }
        }

        hkReflect::Var getInternal() const { return m_object; }

    protected:
        void addBackLinkIfRequired();
        void setVariableArrayObjectId(int id);

        hkReflect::Var m_object;
        class CompatPatcher* m_parent;
        VarOrExtra m_id;
    };

    class Class
    {
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, Class);

        // Minimal interface, only as needed for patches
        struct MemberInfo
        {
            const char* m_name;
        };

        Class(const hkReflect::Type* type, class CompatPatcher* parent);
        class hkDataWorld* getWorld() const;
        const void* getImplementation() const { return m_type; }

        int getNumMembers() const;
        void getMemberInfo(int index, MemberInfo& memberInfoOut) const;
        void getAllMemberInfos(hkArray<MemberInfo>& memberInfosOut) const;

        bool hasMember(const char* name) const { return m_type->asRecord()->findField(name,false) != HK_NULL; }
        const char* getName() const { return m_type->getName(); }
        hkBool32 isNull() const { return m_type == HK_NULL; }
        Class getParent() const;

        hkUlong getValueParameter(const char* name) const;

        bool operator ==(const Class& other) const { return m_type == other.m_type; }

    protected:
        class CompatPatcher* m_parent;
        const hkReflect::Type* m_type;
    };

    class Array
    {
        friend class hkDataObject::Value;
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, Array);

        int getSize() const;
        void setSize(int newSize);
        void reserve(int newSize);
        void removeAt(int idx);
        Value operator[](int index) const;
        template<typename T> void setAll(const T* buf, int n)
        {
            setSize(n);
            for(int i=0;i<n;i++)
            {
                (*this)[i] = buf[i];
            }
        }

        // Note this returns the Element type, not the array type
        Class getClass() const;
        Array swizzleObjectMember(const char* name) const;
        //const void* getImplementation() const { return m_object; }

        Array(void* obj, const hkReflect::Type* type, class CompatPatcher* parent, hkDataObject::VarOrExtra id, const char* swizzledMemberName = HK_NULL);

        hkUint32Le* m_idPtr;
        const hkReflect::Type* m_type;
        class CompatPatcher* m_parent;
        void* m_data;
        int m_size;
        int m_stride;
        const hkReflect::Type* m_elemType;
        VarOrExtra m_id;
    private:
        // Returns the loaded objects for the array contents if it is a variable array. For fixed arrays, the contents are in-place
        hkSerialize::VarN getVariableArrayObjects() const;
        void setVariableArrayObjects(hkSerialize::VarN newVal);

        int getVariableArrayObjectId() const;
        void setVariableArrayObjectId(int id);
    };

    class Iterator
    {
    public:
        HK_DECLARE_CLASS(Iterator, New);

        inline Iterator(const hkDataObject& obj);
        inline bool advance();
        inline hkDataObject::Value current() const;
        inline hkReflect::FieldDecl currentField() const;

    private:
        const hkDataObject& m_obj;
        hkReflect::DeclIter<hkReflect::FieldDecl> m_it;
    };

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE, hkDataObject);

    /// Null constructor
    hkDataObject();
    /// Constructor - instantiates a temporary public wrapper
    /// using the private hkDataObjectImpl.
    hkDataObject(hkReflect::Var object, class CompatPatcher* parent, VarOrExtra id);
    /// Constructor - instantiates a temporary public wrapper
    /// using the hkDataObjectImpl shared by the given 'o'.
    hkDataObject( const hkDataObject& o );

    /// Assign a temporary wrapper using the hkDataObjectImpl shared by the given 'o'.
    void operator=( const hkDataObject& o );
    /// Return true if hkDataObjects are the same.
    bool operator==( const hkDataObject& o ) const;
    /// Return true if hkDataObjects are different.
    bool operator!=( const hkDataObject& o ) const;

    /// Destructor.
    ~hkDataObject();


    /// Get value of class member named 'name'.
    Value operator[](const char* name);
    /// Get const value of class member named 'name'.
    const Value operator[](const char* name) const;

    /// Return true if object stores value of class member named 'name'.
    hkBool32 hasMember(const char* name) const;

    hkBool32 isNull() const;
    Class getClass() const { return Class(m_object.getType(), m_parent); }
    Type getType() const { return Type(m_parent, m_object.getType()); }
    const void* getImplementation() const { return m_object.getAddress(); }

    class hkDataWorld& getWorld() const;
private:

    hkReflect::Var m_object;
    class CompatPatcher* m_parent;
    VarOrExtra m_id;
};

class hkDataWorld
{
public:
    hkDataWorld(CompatPatcher* parent);
    hkDataObject newObject(hkDataObject::Class t) const;

    hkDataObject::Class findClass(const char* name) const; // For compatibility
protected:
    class CompatPatcher* m_parent;
};

typedef hkDataObject::Array hkDataArray;
typedef hkDataObject::Class hkDataClass;

#include <Common/Compat/Common/Serialize/Data/hkDataObject.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
