// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HKBASE_HKBASE_H
#define HKBASE_HKBASE_H

#include <Common/Base/Fwd/hksal.h>

#include <Common/Base/GlobalConfig.h>
#include <Common/Base/Types/hkBaseDefs.h>

#ifndef HK_UNITY_BUILD
    #define HK_UNITY_ANONYMOUS_NAMESPACE
    #define HK_UNITY_USING_ANONYMOUS_NAMESPACE
    #define HK_UNITY_ANONYMOUS_NAMESPACE_SYMBOL(...) __VA_ARGS__
    #define HK_UNITY_ID
#endif

// If HK_DIAG_DISABLE_WARNING_OVERRIDE is defined it means that warnings have already
// been disabled either in hkIncludesStart.h or manually via HK_DETAIL_INCLUDE_START or
// HK_DETAIL_DIAG_DISABLE_WARNINGS so should not be done again here.
#if (HK_DIAG_DISABLE_WARNING_OVERRIDE == 0)
HK_DETAIL_DIAG_DISABLE_WARNINGS_PUSH
#endif

#include <Common/Base/Types/hkTrait.h>
#include <Common/Base/Types/hkVarArgs.h>
#include <Common/Base/System/Error/hkErrorFwd.h>
#include <Common/Base/System/Error/hkAssert.h>

#if defined(HK_DEBUG) && !defined(__HAVOK_PARSER__) && !defined(HK_DYNAMIC_DLL) \
    && !defined(HK_PLATFORM_LINUX) 
    #define HK_MEMORY_TRACKER_ENABLE
#endif

struct hkPlacementNewArg;
inline void* operator new(hk_size_t, hkPlacementNewArg* p) { return p; }
inline void* operator new[](hk_size_t, hkPlacementNewArg* p) { return p; }

#if ( !defined(HK_COMPILER_SNC) || defined(__EXCEPTIONS) )
inline void operator delete(void* /*unused*/, hkPlacementNewArg* /*unused*/) { HK_REPORT_FAILURE(0x5c4071a3, ""); }
inline void operator delete[](void* /*unused*/, hkPlacementNewArg* /*unused*/) { HK_REPORT_FAILURE(0x7ca45d11, ""); }
#endif

namespace hkIo {
    namespace Detail {
        class ReadBufferAdapter;
        class WriteBufferAdapter;
    }
    class ReadBuffer;
    class WriteBuffer;
}

#include <Common/Base/Memory/MemoryClasses/hkMemoryClassDefinitions.h> 

#include <Common/Base/Reflect/Core/hkReflectDefs.h>
#include <Common/Base/Memory/Util/hkMemUtil.h>

#include <Common/Base/Memory/Router/hkMemoryRouter.h>

#include <Common/Base/Types/hkBaseTypes.h>

#include <Common/Base/Types/hkPtrAndInt.h>
#include <Common/Base/Container/ArrayView/hkArrayView.h>
#include <Common/Base/Reflect/hkReflect.h>

#include <Common/Base/Object/hkReferencedObject.h>
#include <Common/Base/Types/hkRefPtr.h>

namespace hkBaseSystem
{
    namespace Detail
    {
            // Like a refptr except that its destructor doesn't remove the reference.
            // Used for global variables which can be destroyed outside of hkBaseSystem::quit
        template<typename T>
        struct RefPtrNoDtor : public hkRefPtr < T >
        {
            using hkRefPtr<T>::operator=;
            ~RefPtrNoDtor() { this->unsetAndDontDecrementRefCount(); }
        };
    }
}

#include <Common/Base/System/Io/OStream/hkOStream.h>    
#include <Common/Base/System/Error/hkError.h>

#include <Common/Base/Reflect/Attributes/hkAttributes.h>
#include <Common/Base/Container/Tuple/hkTuple.h>

// This out-of-position includes are special-cased in hkPreBuild to suppress a warning.
// If you move them, please ensure that hkPreBuild is up-to-date.
#include <Common/Base/_Auto/TemplateTypes/hkReflectValue_Types.inl>
#include <Common/Base/_Auto/TemplateTypes/hkBaseTypes_Types.inl>
#include <Common/Base/_Auto/TemplateTypes/hkPtrAndInt_Types.inl>
#ifndef HK_EXCLUDE_ARRAY_VIEW_REFLECTION
#include <Common/Base/_Auto/TemplateTypes/hkArrayView_Types.inl>
#endif

#include <Common/Base/Container/Array/hkArray.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>
#include <Common/Base/Types/hkUFloat8.h>

#include <Common/Base/Container/StringView/hkStringView.h>

#include <Common/Base/Math/hkMath.h>
#include <Common/Base/Types/hkRefVariant.h>

#include <Common/Base/Types/hkHandle.h>

#include <Common/Base/Container/String/hkString.h>
#include <Common/Base/Container/String/hkStringPtr.h>
#include <Common/Base/Container/String/hkStringBuf.h> 

//
// This hkStruckPackingCheck checks whether hkUint64 data elements are aligned
// on 8 bytes boundaries. This is an implicit assumption that the current serialization
// system relies on, and this compile time check will make sure that it is true
// at least on windows platforms.
//
// If a different struct alignment is used (for example by another 3rd party library),
// use the following code to wrap all Havok includes:
//
// #include <Common/Base/hkIncludeStart.h>
// #include "any Havok include"
// #include <Common/Base/hkIncludeEnd.h>
//
#if defined(HK_PLATFORM_WIN32) && !defined(__HAVOK_PARSER__)
struct hkStructPackingCheck
{
    hkUint32 m_a;
    hkUint64 m_b;
};
HK_COMPILE_TIME_ASSERT( sizeof(hkStructPackingCheck) == 16 );
#endif

class hkStringBuf;

#endif // HKBASE_HKBASE_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
