// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkIo
{
    struct Path
    {
        Path() {}
        explicit Path(const char* s) : m_sb(s) {}
        Path operator+(const char* s) const { hkStringBuf sb(m_sb, s); return Path(sb); }
        Path operator/(const char* s) const { hkStringBuf sb(m_sb, "/", s); return Path(sb); }
        bool endsWith(const char* s) const { return m_sb.endsWith(s); }
        const char* cString() const { return m_sb.cString(); }
        hkStringPtr m_sb;
    };

    inline _Ret_notnull_ hkIo::Detail::ReadBufferImpl* createReaderImpl(const hkIo::Path& p) { return hkIo::Detail::createReaderImpl(p.cString()); }
    inline _Ret_notnull_ hkIo::Detail::WriteBufferImpl* createWriterImpl(const hkIo::Path& p) { return hkIo::Detail::createWriterImpl(p.cString()); }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
