// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace UnitTest
{

    template<int TAG = 0>  // Use different TAGs to make incompatible types
    class TaggedType
    {
    public:
        enum class State : hkUint8
        {
            DefaultConstructed,
            ArgConstructed,
            CopyConstructed,
            MoveConstructed,
            CopyAssigned,
            MoveAssigned,
            MovedFrom,
        };

        TaggedType();
        TaggedType(int value);
        TaggedType(TaggedType&& other);
        TaggedType(const TaggedType& other);

        TaggedType& operator=(TaggedType&& other);
        TaggedType& operator=(const TaggedType&);

        bool isDefaultConstructed() const { return m_state == State::DefaultConstructed; }
        bool isArgConstructed() const { return m_state == State::ArgConstructed; }
        bool isCopyConstructed() const { return m_state == State::CopyConstructed; }
        bool isMoveConstructed() const { return m_state == State::MoveConstructed; }
        bool isCopyAssigned() const { return m_state == State::CopyAssigned; }
        bool isMoveAssigned() const { return m_state == State::MoveAssigned; }
        bool isMovedFrom() const { return m_state == State::MovedFrom; }

    private:
        State m_state;
        int m_value;
    };

    struct ForwardingTestingHelper
    {
        ForwardingTestingHelper();

        ForwardingTestingHelper(
            TaggedType<1>&& t1,
            TaggedType<2>&& t2,
            TaggedType<3>&& t3,
            TaggedType<4>&& t4,
            TaggedType<5>&& t5);

        ForwardingTestingHelper(
            const TaggedType<1>& t1,
            const TaggedType<2>& t2,
            const TaggedType<3>& t3,
            const TaggedType<4>& t4,
            const TaggedType<5>& t5);

        TaggedType<1> t1;
        TaggedType<2> t2;
        TaggedType<3> t3;
        TaggedType<4> t4;
        TaggedType<5> t5;

        bool isEverythingMoveConstructed() const;
        bool isEverythingMovedFrom() const;
    };

}  // namespace UnitTest

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
