// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/UnitTestUtils.h>

namespace UnitTest {

    template<int TAG>
    TaggedType<TAG>::TaggedType()
        : m_state(State::DefaultConstructed)
        , m_value(0)
    {}

    template<int TAG>
    TaggedType<TAG>::TaggedType(int value)
        : m_state(State::DefaultConstructed)
        , m_value(value)
    {}

    template<int TAG>
    TaggedType<TAG>::TaggedType(TaggedType&& other)
        : m_state(State::MoveConstructed)
        , m_value(other.m_value)
    {
        other.m_state = State::MovedFrom;
        other.m_value = 0;
    }

    template<int TAG>
    TaggedType<TAG>::TaggedType(const TaggedType& other)
        : m_state(State::CopyConstructed)
        , m_value(other.m_value)
    {}

    template<int TAG>
    TaggedType<TAG>& TaggedType<TAG>::operator=(TaggedType&& other)
    {
        m_state = State::MoveAssigned;
        m_value = other.m_value;
        other.m_state = State::MovedFrom;
        other.m_value = 0;
        return *this;
    }

    template<int TAG>
    TaggedType<TAG>& TaggedType<TAG>::operator=(const TaggedType& other)
    {
        m_value = other.m_value;
        m_state = State::CopyAssigned;
        return *this;
    }


    ForwardingTestingHelper::ForwardingTestingHelper()
        : t1(1)
        , t2(2)
        , t3(3)
        , t4(4)
        , t5(5)
    {}

    ForwardingTestingHelper::ForwardingTestingHelper(
        TaggedType<1>&& t1,
        TaggedType<2>&& t2,
        TaggedType<3>&& t3,
        TaggedType<4>&& t4,
        TaggedType<5>&& t5)
            : t1(hk::move(t1))
            , t2(hk::move(t2))
            , t3(hk::move(t3))
            , t4(hk::move(t4))
            , t5(hk::move(t5))
    {}

    ForwardingTestingHelper::ForwardingTestingHelper(
        const TaggedType<1>& t1,
        const TaggedType<2>& t2,
        const TaggedType<3>& t3,
        const TaggedType<4>& t4,
        const TaggedType<5>& t5)
            : t1(t1)
            , t2(t2)
            , t3(t3)
            , t4(t4)
            , t5(t5)
    {}

    bool ForwardingTestingHelper::isEverythingMoveConstructed() const
    {
        return t1.isMoveConstructed()
            && t2.isMoveConstructed()
            && t3.isMoveConstructed()
            && t4.isMoveConstructed()
            && t5.isMoveConstructed();
    }

    bool ForwardingTestingHelper::isEverythingMovedFrom() const
    {
        return t1.isMovedFrom()
            && t2.isMovedFrom()
            && t3.isMovedFrom()
            && t4.isMovedFrom()
            && t5.isMovedFrom();
    }

}  // namespace UnitTest

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
